/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import java.util.ArrayList;
import java.util.List;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.guava.collect.ImmutableList;
import org.apache.sedona.shaded.s2.S2Builder;
import org.apache.sedona.shaded.s2.S2BuilderGraph;
import org.apache.sedona.shaded.s2.S2BuilderShapesLayer;
import org.apache.sedona.shaded.s2.S2Error;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.primitives.IdSetLexicon;
import org.apache.sedona.shaded.s2.primitives.IntVector;

public class S2PointVectorLayer
implements S2BuilderShapesLayer {
    private final Options options;
    private List<S2Point> points = null;
    private final IntVector labelSetIds;
    private final IdSetLexicon labelSetLexicon;
    private S2BuilderGraph.LabelFetcher fetcher = null;

    public S2PointVectorLayer() {
        this.labelSetIds = null;
        this.labelSetLexicon = null;
        this.options = new Options();
    }

    public S2PointVectorLayer(Options options) {
        this.labelSetIds = null;
        this.labelSetLexicon = null;
        this.options = options;
    }

    public S2PointVectorLayer(IntVector labelSetIds, IdSetLexicon labelSetLexicon, Options options) {
        this.labelSetIds = labelSetIds;
        this.labelSetLexicon = labelSetLexicon;
        this.options = options;
    }

    public String toString() {
        return "S2PointVectorLayer with Options.duplicateEdges=" + this.options.duplicateEdges();
    }

    public List<S2Point> getPointVector() {
        Preconditions.checkNotNull(this.points, "Must call build() first.");
        return this.points;
    }

    public S2Point.Shape getPointVectorShape() {
        Preconditions.checkNotNull(this.points, "Must call build() first.");
        return S2Point.Shape.fromList(this.points);
    }

    public Iterable<S2Point.Shape> shapes() {
        S2Point.Shape shape = this.getPointVectorShape();
        if (shape.numEdges() == 0) {
            return ImmutableList.of();
        }
        return ImmutableList.of(shape);
    }

    @Override
    public S2Builder.GraphOptions graphOptions() {
        return new S2Builder.GraphOptions(S2Builder.EdgeType.DIRECTED, S2Builder.GraphOptions.DegenerateEdges.KEEP, this.options.duplicateEdges(), S2Builder.GraphOptions.SiblingPairs.KEEP);
    }

    @Override
    public boolean build(S2BuilderGraph g2, S2Error error) {
        if (this.labelSetIds != null) {
            this.labelSetIds.clear();
            this.labelSetLexicon.clear();
            if (this.fetcher == null) {
                this.fetcher = new S2BuilderGraph.LabelFetcher(g2, S2Builder.EdgeType.DIRECTED);
            } else {
                this.fetcher.init(g2, S2Builder.EdgeType.DIRECTED);
            }
        }
        this.points = new ArrayList<S2Point>();
        IntVector labels = new IntVector();
        for (int edgeId = 0; edgeId < g2.edges().size(); ++edgeId) {
            S2Point dst;
            S2Point src;
            int dstId;
            int srcId = g2.edgeSrcId(edgeId);
            if (srcId != (dstId = g2.edgeDstId(edgeId)) && !(src = g2.vertex(srcId)).equalsPoint(dst = g2.vertex(dstId))) {
                error.init(S2Error.Code.INVALID_ARGUMENT, "Found non-degenerate edges", new Object[0]);
                continue;
            }
            this.points.add(g2.vertex(srcId));
            if (this.labelSetIds == null) continue;
            this.fetcher.fetch(edgeId, labels);
            this.labelSetIds.add(this.labelSetLexicon.add(labels));
        }
        return error.ok();
    }

    public static class Options {
        private S2Builder.GraphOptions.DuplicateEdges duplicateEdges;

        public Options() {
            this.duplicateEdges = S2Builder.GraphOptions.DuplicateEdges.MERGE;
        }

        public Options(S2Builder.GraphOptions.DuplicateEdges duplicateEdges) {
            this.duplicateEdges = duplicateEdges;
        }

        public void setDuplicateEdges(S2Builder.GraphOptions.DuplicateEdges duplicateEdges) {
            this.duplicateEdges = duplicateEdges;
        }

        public S2Builder.GraphOptions.DuplicateEdges duplicateEdges() {
            return this.duplicateEdges;
        }
    }
}

