/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster.serde;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.measure.IncommensurableException;
import org.apache.commons.io.IOUtils;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.CRS;
import org.geotools.referencing.wkt.Formattable;
import si.uom.NonSI;
import si.uom.SI;

public class CRSSerializer {
    private static final LoadingCache<CRSKey, byte[]> crsSerializationCache;
    private static final LoadingCache<ByteBuffer, CoordinateReferenceSystem> crsDeserializationCache;

    private CRSSerializer() {
    }

    public static byte[] serialize(CoordinateReferenceSystem crs) {
        return crsSerializationCache.get(new CRSKey(crs));
    }

    public static CoordinateReferenceSystem deserialize(byte[] bytes) {
        return crsDeserializationCache.get(ByteBuffer.wrap(bytes));
    }

    private static byte[] doSerializeCRS(CRSKey crsKey) throws IOException {
        CoordinateReferenceSystem crs = crsKey.crs;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DeflaterOutputStream dos = new DeflaterOutputStream(bos);){
                String wktString = crs instanceof Formattable ? ((Formattable)crs).toWKT(2, false) : crs.toWKT();
                dos.write(wktString.getBytes(StandardCharsets.UTF_8));
                dos.finish();
                byte[] res = bos.toByteArray();
                crsDeserializationCache.put(ByteBuffer.wrap(res), crs);
                byArray = res;
            }
            return byArray;
        }
    }

    private static CoordinateReferenceSystem doDeserializeCRS(ByteBuffer byteBuffer) throws IOException, FactoryException {
        byte[] bytes = byteBuffer.array();
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            CoordinateReferenceSystem coordinateReferenceSystem;
            try (InflaterInputStream dis = new InflaterInputStream(bis);){
                byte[] wktBytes = IOUtils.toByteArray((InputStream)dis);
                String wktString = new String(wktBytes, StandardCharsets.UTF_8);
                CoordinateReferenceSystem crs = CRS.parseWKT((String)wktString);
                crsSerializationCache.put(new CRSKey(crs), bytes);
                coordinateReferenceSystem = crs;
            }
            return coordinateReferenceSystem;
        }
    }

    public static void invalidateCache() {
        crsSerializationCache.invalidateAll();
        crsDeserializationCache.invalidateAll();
    }

    static {
        try {
            NonSI.DEGREE_ANGLE.getConverterToAny(SI.RADIAN).convert(1.0);
        }
        catch (IncommensurableException e) {
            throw new RuntimeException(e);
        }
        crsSerializationCache = Caffeine.newBuilder().maximumSize(100L).build(CRSSerializer::doSerializeCRS);
        crsDeserializationCache = Caffeine.newBuilder().maximumSize(100L).build(CRSSerializer::doDeserializeCRS);
    }

    private static class CRSKey {
        private final CoordinateReferenceSystem crs;
        private final int hashCode;

        CRSKey(CoordinateReferenceSystem crs) {
            this.crs = crs;
            this.hashCode = crs.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CRSKey) {
                return CRS.equalsIgnoreMetadata((Object)this.crs, (Object)((CRSKey)obj).crs);
            }
            return false;
        }
    }
}

