/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.jpostal;

import com.mapzen.jpostal.Config;
import com.mapzen.jpostal.LibPostal;
import com.mapzen.jpostal.ParsedComponent;
import com.mapzen.jpostal.ParserOptions;

public class AddressParser {
    private static volatile AddressParser instance = null;
    private final LibPostal libPostal;

    private static synchronized native void setup();

    private static synchronized native void setupDataDir(String var0);

    private synchronized native ParsedComponent[] libpostalParse(byte[] var1, ParserOptions var2);

    private static synchronized native void teardown();

    public static AddressParser getInstanceDataDir(String dataDir) {
        return AddressParser.getInstanceConfig(Config.builder().dataDir(dataDir).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AddressParser getInstanceConfig(Config config) {
        if (instance == null) {
            Class<AddressParser> clazz = AddressParser.class;
            synchronized (AddressParser.class) {
                if (instance == null) {
                    instance = new AddressParser(LibPostal.getInstance(config));
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else if (!AddressParser.instance.libPostal.getConfig().equals(config)) {
            throw Config.mismatchException(AddressParser.instance.libPostal.getConfig(), config);
        }
        return instance;
    }

    public static AddressParser getInstance() {
        return AddressParser.getInstanceDataDir(null);
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public ParsedComponent[] parseAddress(String address) {
        return this.parseAddressWithOptions(address, new ParserOptions.Builder().build());
    }

    public ParsedComponent[] parseAddressWithOptions(String address, ParserOptions options) {
        if (address == null) {
            throw new NullPointerException("String address must not be null");
        }
        if (options == null) {
            throw new NullPointerException("ParserOptions options must not be null");
        }
        return this.libpostalParse(address.getBytes(), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AddressParser(LibPostal libPostal) {
        if (libPostal == null) {
            throw new NullPointerException("LibPostal must not be null");
        }
        this.libPostal = libPostal;
        String dataDir = libPostal.getConfig().getDataDir();
        LibPostal libPostal2 = this.libPostal;
        synchronized (libPostal2) {
            if (dataDir == null) {
                AddressParser.setup();
            } else {
                AddressParser.setupDataDir(dataDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        LibPostal libPostal = this.libPostal;
        synchronized (libPostal) {
            AddressParser.teardown();
        }
    }

    public static void close() {
        LibPostal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void _close() {
        if (instance == null) return;
        Class<AddressParser> clazz = AddressParser.class;
        synchronized (AddressParser.class) {
            if (instance == null) return;
            AddressParser.teardown();
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

