/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.geom;

import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import javax.vecmath.Point2d;
import org.twak.utils.Line;
import org.twak.utils.Mathz;
import org.twak.utils.collections.MultiMap;
import org.twak.utils.geom.HalfMesh2;

public class HalfMeshez {
    public static void splitMergeCoincident(HalfMesh2 hm, double tol) {
        LinkedHashSet<HalfMesh2.HalfEdge> toProcess = new LinkedHashSet<HalfMesh2.HalfEdge>(hm.faces.stream().flatMap(f -> f.edgeList().stream()).collect(Collectors.toList()));
        LinkedHashSet<HalfMesh2.HalfEdge> toProcess1 = new LinkedHashSet<HalfMesh2.HalfEdge>(toProcess);
        int count = 0;
        block0: while (!toProcess1.isEmpty()) {
            HalfMesh2.HalfEdge e1 = (HalfMesh2.HalfEdge)toProcess1.iterator().next();
            toProcess1.remove(e1);
            if (e1.over != null) continue;
            LinkedHashSet toProcess2 = new LinkedHashSet(toProcess);
            while (!toProcess2.isEmpty()) {
                Line l2;
                HalfMesh2.HalfEdge e2 = (HalfMesh2.HalfEdge)toProcess2.iterator().next();
                toProcess2.remove(e2);
                Line l1 = e1.line();
                if (!(l1.distance(l2 = e2.line()) <= tol) || !(Math.abs(l2.absAngle(l1)) > 3.041592653589793)) continue;
                double maxMin = l1.findPPram(l2.end);
                double minMax = l1.findPPram(l2.start);
                if (Mathz.inRange(maxMin, 0.001, 0.999)) {
                    e1.split(l1.fromPPram(maxMin));
                } else {
                    if (!Mathz.inRange(minMax, 0.001, 0.999)) continue;
                    e1.split(l1.fromPPram(minMax));
                }
                for (HalfMesh2.HalfEdge processAgain : new HalfMesh2.HalfEdge[]{e1, e1.next, e2}) {
                    toProcess.add(processAgain);
                    toProcess1.add(processAgain);
                }
                if (++count <= 1000) continue block0;
                return;
            }
        }
        MultiMap<Point2d, HalfMesh2.HalfEdge> starts = new MultiMap<Point2d, HalfMesh2.HalfEdge>();
        for (HalfMesh2.HalfFace hf : hm) {
            for (HalfMesh2.HalfEdge he : hf) {
                if (he.over != null) continue;
                starts.put(new Point2d(he.start), he);
            }
        }
        for (HalfMesh2.HalfFace hf : hm) {
            for (HalfMesh2.HalfEdge he : hf) {
                if (he.over != null) continue;
                for (HalfMesh2.HalfEdge o : starts.get(he.end)) {
                    if (!he.start.equals(o.end)) continue;
                    he.over = o;
                }
            }
        }
        for (HalfMesh2.HalfFace hf : hm) {
            for (HalfMesh2.HalfEdge he : hf) {
                if (he.over != null) continue;
                for (HalfMesh2.HalfFace hf2 : hm) {
                    for (HalfMesh2.HalfEdge he2 : hf2) {
                        if (he2 == he || he2.over != null || !(he.start.distance(he2.end) < 0.01) || !(he.end.distance(he2.start) < 0.01)) continue;
                        he.over = he2;
                        he2.over = he;
                    }
                }
            }
        }
    }
}

