/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.twak.camp.Corner;
import org.twak.camp.Edge;
import org.twak.camp.HeightCollision;
import org.twak.camp.HeightEvent;
import org.twak.camp.Skeleton;
import org.twak.utils.geom.LinearForm3D;

public class EdgeCollision
implements HeightEvent {
    public Point3d loc;
    public Edge a;
    public Edge b;
    public Edge c;
    public boolean debugInfinite = false;

    public EdgeCollision(Point3d location, Edge e1, Edge e2, Edge e3) {
        this.loc = location;
        this.a = e1;
        this.b = e2;
        this.c = e3;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EdgeCollision) {
            EdgeCollision other = (EdgeCollision)obj;
            return this.a.equals(other.a) && (this.b.equals(other.b) && this.c.equals(other.c) || this.b.equals(other.c) && this.c.equals(other.b)) || this.a.equals(other.b) && (this.b.equals(other.a) && this.c.equals(other.c) || this.b.equals(other.c) && this.c.equals(other.a)) || this.a.equals(other.c) && (this.b.equals(other.a) && this.c.equals(other.b) || this.b.equals(other.b) && this.c.equals(other.a));
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash += this.a.hashCode();
        hash += this.b.hashCode();
        return (hash += this.c.hashCode()) * 31;
    }

    @Override
    public double getHeight() {
        return this.loc.z;
    }

    @Override
    public boolean process(Skeleton skel) {
        throw new Error();
    }

    public static void processConsecutive(Point3d loc, Corner a, Corner b, Skeleton skel) {
        skel.output.addOutputSideTo(b, (Tuple3d)loc, b.prevL, b.nextL);
        a.nextL.currentCorners.remove(b);
        b.nextL.currentCorners.remove(b);
        skel.liveCorners.remove(b);
    }

    public static void processJump(Point3d loc, Corner a, Corner an, Corner b, Skeleton skel, HeightCollision hc) {
        Corner ab = new Corner(loc.x, loc.y, loc.z);
        ab.prevL = b.nextL;
        ab.prevL.currentCorners.add(ab);
        ab.nextL = a.nextL;
        ab.nextL.currentCorners.add(ab);
        an.prevC = ab;
        b.nextC = ab;
        ab.prevC = b;
        ab.nextC = an;
        skel.liveCorners.add(ab);
        skel.qu.addCorner(ab, hc);
    }

    public static boolean bisectorsBound(Corner first, Point3d collision, Skeleton skel) {
        Vector3d dir;
        LinearForm3D prev = first.prevL.linearForm;
        LinearForm3D next = first.nextC.nextL.linearForm;
        double pDist = prev.pointDistance(collision);
        double nDist = next.pointDistance(collision);
        double prevDot = prev.normal().dot(first.nextL.direction());
        double nextDot = next.normal().dot(first.nextL.direction());
        if (prevDot < 0.0) {
            pDist = -pDist;
        }
        if (nextDot > 0.0) {
            nDist = -nDist;
        }
        if (first.nextC.nextL.uphill.equals(first.nextL.uphill)) {
            dir = first.nextL.direction();
            dir.normalize();
            dir.negate();
            next = new LinearForm3D(dir, first.nextC);
            nDist = next.pointDistance(collision);
        }
        if (first.prevL.uphill.equals(first.nextL.uphill)) {
            dir = first.prevL.direction();
            dir.normalize();
            prev = new LinearForm3D(dir, first);
            pDist = prev.pointDistance(collision);
        }
        double c = -1.0E-4;
        return pDist >= -1.0E-4 && nDist >= -1.0E-4;
    }

    public static Corner findCorner(Edge in, Point3d collision, Skeleton skel) {
        for (Corner lc : in.currentCorners) {
            if (lc.nextL != in) continue;
            LinearForm3D prev = lc.prevC.nextL.linearForm.clone();
            LinearForm3D next = lc.nextC.nextL.linearForm.clone();
            double pDist = prev.pointDistance(collision);
            double nDist = next.pointDistance(collision);
            double prevDot = prev.normal().dot(in.direction());
            double nextDot = next.normal().dot(in.direction());
            if (prevDot < 0.0) {
                pDist = -pDist;
            }
            if (nextDot > 0.0) {
                nDist = -nDist;
            }
            double c = -1.0E-4;
            if (!(pDist >= -1.0E-4) || !(nDist >= -1.0E-4)) continue;
            return lc;
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.loc) + ":" + String.valueOf(this.a) + "," + String.valueOf(this.b) + "," + String.valueOf(this.c);
    }
}

