/*
 * Decompiled with CFR 0.152.
 */
package org.graphframes.examples;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.storage.StorageLevel$;
import org.graphframes.GraphFrame;
import org.graphframes.GraphFrame$;
import org.graphframes.WithBroadcastThreshold;
import org.graphframes.WithLocalCheckpoints;
import org.graphframes.examples.LDBCUtils$;
import org.graphframes.lib.ConnectedComponents;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ConnectedComponentsLDBC$ {
    public static final ConnectedComponentsLDBC$ MODULE$ = new ConnectedComponentsLDBC$();

    public void main(String[] args) {
        String benchmarkGraphName = (String)ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])args)).getOrElse((Function0 & Serializable)() -> "kgs");
        Path resourcesPath = Paths.get((String)((Option)Predef$.MODULE$.wrapRefArray((Object[])args).lift().apply((Object)BoxesRunTime.boxToInteger((int)1))).getOrElse((Function0 & Serializable)() -> "/tmp/ldbc_graphalitics_datesets"), new String[0]);
        Path caseRoot = resourcesPath.resolve(benchmarkGraphName);
        SparkConf sparkConf = new SparkConf().setMaster("local[*]").setAppName("GraphFramesBenchmarks").set("spark.sql.shuffle.partitions", String.valueOf(BoxesRunTime.boxToInteger((int)(Runtime.getRuntime().availableProcessors() * 2)))).set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        SparkSession spark = SparkSession$.MODULE$.builder().config(sparkConf).getOrCreate();
        SparkContext context = spark.sparkContext();
        context.setLogLevel("ERROR");
        context.setCheckpointDir("/tmp/graphframes-checkpoints");
        LDBCUtils$.MODULE$.downloadLDBCIfNotExists(resourcesPath, benchmarkGraphName);
        Dataset edges = spark.read().format("csv").option("header", "false").option("delimiter", " ").schema(StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("src", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("dst", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))).load(((Object)caseRoot.resolve(new StringBuilder(2).append(benchmarkGraphName).append(".e").toString())).toString()).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK_SER());
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)new StringBuilder(12).append("Read edges: ").append(edges.count()).toString());
        Dataset vertices = spark.read().format("csv").option("header", "false").schema(StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("id", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))).load(((Object)caseRoot.resolve(new StringBuilder(2).append(benchmarkGraphName).append(".v").toString())).toString()).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK_SER());
        Predef$.MODULE$.println((Object)new StringBuilder(15).append("Read vertices: ").append(vertices.count()).toString());
        GraphFrame graph = GraphFrame$.MODULE$.apply((Dataset<Row>)vertices, (Dataset<Row>)edges);
        Properties props = new Properties();
        InputStream stream = Files.newInputStream(caseRoot.resolve(new StringBuilder(11).append(benchmarkGraphName).append(".properties").toString()), new OpenOption[0]);
        props.load(stream);
        stream.close();
        Path expectedPath = caseRoot.resolve(new StringBuilder(4).append(benchmarkGraphName).append("-WCC").toString());
        Dataset expectedComponents = spark.read().format("csv").option("header", "false").option("delimiter", " ").schema(StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("id", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("wcomp", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))).load(((Object)expectedPath).toString()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "wcomp"})).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK_SER());
        Predef$.MODULE$.println((Object)new StringBuilder(21).append("Expected components: ").append(expectedComponents.count()).toString());
        long start = System.currentTimeMillis();
        Dataset<Row> results = ((ConnectedComponents)((WithLocalCheckpoints)((Object)((WithBroadcastThreshold)((Object)graph.connectedComponents().setAlgorithm("graphframes"))).setBroadcastThreshold(-1))).setUseLocalCheckpoints(true)).run();
        Predef$.MODULE$.println((Object)new StringBuilder(22).append("Connected components: ").append(results.count()).toString());
        Dataset combined = results.join(expectedComponents, (Seq)new .colon.colon((Object)"id", (List)Nil$.MODULE$), "left");
        combined.show(10);
        Dataset notMatchedRows = combined.filter(functions$.MODULE$.col("wcomp").$eq$bang$eq((Object)functions$.MODULE$.col("component")));
        Predef$.MODULE$.println((Object)new StringBuilder(24).append("Not matched rows count: ").append(notMatchedRows.count()).toString());
        notMatchedRows.show(20);
        long end = System.currentTimeMillis();
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("Total time in seconds: ").append((double)(end - start) / 1000.0).toString());
        spark.stop();
    }

    private ConnectedComponentsLDBC$() {
    }
}

