/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import org.apache.sedona.shaded.guava.annotations.VisibleForTesting;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.guava.collect.ImmutableList;
import org.apache.sedona.shaded.s2.S2Builder;
import org.apache.sedona.shaded.s2.S2BuilderGraph;
import org.apache.sedona.shaded.s2.S2BuilderShapesLayer;
import org.apache.sedona.shaded.s2.S2Error;
import org.apache.sedona.shaded.s2.S2LaxPolygonShape;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2PolygonDegeneracyFinder;
import org.apache.sedona.shaded.s2.S2Shape;
import org.apache.sedona.shaded.s2.primitives.IdSetLexicon;
import org.apache.sedona.shaded.s2.primitives.IntVector;

public class S2LaxPolygonLayer
implements S2BuilderShapesLayer {
    private final Options options;
    private S2LaxPolygonShape polygon = null;
    private ArrayList<IntVector> labelSetIds = new ArrayList();
    private final IdSetLexicon labelSetLexicon;
    private S2BuilderGraph.LabelFetcher fetcher = null;

    public S2LaxPolygonLayer() {
        this.options = new Options();
        this.labelSetIds = null;
        this.labelSetLexicon = null;
    }

    public S2LaxPolygonLayer(Options options) {
        this.options = options;
        this.labelSetIds = null;
        this.labelSetLexicon = null;
    }

    public S2LaxPolygonLayer(Options options, IdSetLexicon labelSetLexicon, ArrayList<IntVector> labelSetIds) {
        Preconditions.checkNotNull(options);
        Preconditions.checkNotNull(labelSetLexicon);
        Preconditions.checkNotNull(labelSetIds);
        this.options = options;
        this.labelSetIds = labelSetIds;
        this.labelSetLexicon = labelSetLexicon;
    }

    public S2LaxPolygonShape getPolygon() {
        Preconditions.checkNotNull(this.polygon, "Must call build() first.");
        return this.polygon;
    }

    public String toString() {
        return "S2LaxPolygonLayer with options " + this.options;
    }

    public Iterable<S2Shape> shapes() {
        return ImmutableList.of(this.getPolygon());
    }

    @VisibleForTesting
    ArrayList<IntVector> getLabelSetIdsForLoops() {
        Preconditions.checkNotNull(this.labelSetIds, "Must call build() first.");
        return this.labelSetIds;
    }

    @Override
    public S2Builder.GraphOptions graphOptions() {
        if (this.options.degenerateBoundaries() == DegenerateBoundaries.DISCARD) {
            return new S2Builder.GraphOptions(this.options.edgeType(), S2Builder.GraphOptions.DegenerateEdges.DISCARD, S2Builder.GraphOptions.DuplicateEdges.KEEP, S2Builder.GraphOptions.SiblingPairs.DISCARD);
        }
        return new S2Builder.GraphOptions(this.options.edgeType(), S2Builder.GraphOptions.DegenerateEdges.DISCARD_EXCESS, S2Builder.GraphOptions.DuplicateEdges.KEEP, S2Builder.GraphOptions.SiblingPairs.DISCARD_EXCESS);
    }

    @Override
    public boolean build(S2BuilderGraph g2, S2Error error) {
        if (this.labelSetIds != null) {
            this.labelSetIds.clear();
            this.labelSetLexicon.clear();
        }
        if (g2.options().edgeType() == S2Builder.EdgeType.DIRECTED) {
            return this.buildDirected(g2, error);
        }
        error.init(S2Error.Code.UNIMPLEMENTED, "Undirected edges not supported yet", new Object[0]);
        return false;
    }

    private static void discardEdges(S2BuilderGraph g2, IntVector edgesToDiscard, S2BuilderGraph.EdgeList newEdges, IntVector newInputEdgeIdSetIds) {
        assert (edgesToDiscard.isSorted());
        newEdges.clear();
        newInputEdgeIdSetIds.clear();
        newEdges.ensureCapacity(g2.numEdges());
        newInputEdgeIdSetIds.ensureCapacity(g2.numEdges());
        int i = 0;
        for (int edgeId = 0; edgeId < g2.numEdges(); ++edgeId) {
            if (i != edgesToDiscard.size() && edgeId == edgesToDiscard.get(i)) {
                ++i;
                continue;
            }
            newEdges.copyEdge(g2.edges(), edgeId);
            newInputEdgeIdSetIds.add(g2.inputEdgeIdSetId(edgeId));
        }
        assert (i == edgesToDiscard.size());
    }

    private static void maybeAddFullLoop(S2BuilderGraph g2, ArrayList<List<S2Point>> loops) {
        if (g2.isFullPolygonPredicate().test(g2)) {
            loops.add(ImmutableList.of());
        }
    }

    private boolean buildDirected(S2BuilderGraph g2, S2Error error) {
        ArrayList<int[]> edgeLoops;
        S2BuilderGraph.EdgeList newEdges = new S2BuilderGraph.EdgeList();
        IntVector newInputEdgeIdSetIds = new IntVector();
        ArrayList<List<S2Point>> loops = new ArrayList<List<S2Point>>();
        DegenerateBoundaries degenerateBoundaries = this.options.degenerateBoundaries();
        switch (degenerateBoundaries) {
            case DISCARD: {
                if (g2.numEdges() != 0) break;
                S2LaxPolygonLayer.maybeAddFullLoop(g2, loops);
                break;
            }
            case KEEP: {
                if (!S2PolygonDegeneracyFinder.isFullyDegenerate(g2)) break;
                S2LaxPolygonLayer.maybeAddFullLoop(g2, loops);
                break;
            }
            default: {
                boolean discardHoles = degenerateBoundaries == DegenerateBoundaries.DISCARD_HOLES;
                S2PolygonDegeneracyFinder.PolygonDegeneracyList degeneracies = S2PolygonDegeneracyFinder.findPolygonDegeneracies(g2);
                if (degeneracies.size() == g2.numEdges()) {
                    if (degeneracies.size() == 0) {
                        S2LaxPolygonLayer.maybeAddFullLoop(g2, loops);
                    } else if (degeneracies.isHole(0)) {
                        loops.add(ImmutableList.of());
                    }
                }
                IntVector edgesToDiscard = new IntVector();
                for (int i = 0; i < degeneracies.size(); ++i) {
                    if (degeneracies.isHole(i) != discardHoles) continue;
                    edgesToDiscard.add(degeneracies.edgeId(i));
                }
                if (edgesToDiscard.isEmpty()) break;
                edgesToDiscard.sort();
                S2LaxPolygonLayer.discardEdges(g2, edgesToDiscard, newEdges, newInputEdgeIdSetIds);
                g2 = new S2BuilderGraph(g2.options(), g2.vertices(), newEdges, newInputEdgeIdSetIds, g2.inputEdgeIdSetLexicon(), g2.labelSetIds(), g2.labelSetLexicon(), g2.isFullPolygonPredicate());
            }
        }
        if (!g2.getDirectedLoops(S2BuilderGraph.LoopType.CIRCUIT, edgeLoops = new ArrayList<int[]>(), error)) {
            return error.ok();
        }
        this.appendPolygonLoops(g2, edgeLoops, loops);
        this.appendEdgeLabels(g2, edgeLoops);
        this.polygon = S2LaxPolygonShape.create(loops);
        return true;
    }

    private void appendPolygonLoops(S2BuilderGraph g2, ArrayList<int[]> edgeLoops, ArrayList<List<S2Point>> loops) {
        for (int[] edgeLoop : edgeLoops) {
            ArrayList<S2Point> vertices = new ArrayList<S2Point>(edgeLoop.length);
            for (int edgeId : edgeLoop) {
                vertices.add(g2.vertex(g2.edges().getSrcId(edgeId)));
            }
            loops.add(vertices);
        }
    }

    private void appendEdgeLabels(S2BuilderGraph g2, List<int[]> edgeLoops) {
        if (this.labelSetIds == null) {
            return;
        }
        if (this.fetcher == null) {
            this.fetcher = new S2BuilderGraph.LabelFetcher(g2, this.options.edgeType());
        } else {
            this.fetcher.init(g2, this.options.edgeType());
        }
        IntVector labels = new IntVector();
        for (int[] edgeLoop : edgeLoops) {
            IntVector loopLabelSetIds = IntVector.ofCapacity(edgeLoop.length);
            for (int edgeId : edgeLoop) {
                this.fetcher.fetch(edgeId, labels);
                loopLabelSetIds.add(this.labelSetLexicon.add(labels));
            }
            this.labelSetIds.add(loopLabelSetIds);
        }
    }

    public static class Options {
        private S2Builder.EdgeType edgeType;
        private DegenerateBoundaries degenerateBoundaries;

        public Options() {
            this.edgeType = S2Builder.EdgeType.DIRECTED;
            this.degenerateBoundaries = DegenerateBoundaries.KEEP;
        }

        public Options(S2Builder.EdgeType edgeType) {
            Preconditions.checkNotNull(edgeType);
            this.edgeType = edgeType;
        }

        public S2Builder.EdgeType edgeType() {
            return this.edgeType;
        }

        @CanIgnoreReturnValue
        public Options setEdgeType(S2Builder.EdgeType edgeType) {
            Preconditions.checkNotNull(edgeType);
            this.edgeType = edgeType;
            return this;
        }

        public DegenerateBoundaries degenerateBoundaries() {
            return this.degenerateBoundaries;
        }

        @CanIgnoreReturnValue
        public Options setDegenerateBoundaries(DegenerateBoundaries degenerateBoundaries) {
            Preconditions.checkNotNull(degenerateBoundaries);
            this.degenerateBoundaries = degenerateBoundaries;
            return this;
        }

        public String toString() {
            return "EdgeType " + this.edgeType.name() + ", DegenerateBoundaries " + this.degenerateBoundaries.name();
        }
    }

    public static enum DegenerateBoundaries {
        DISCARD,
        DISCARD_HOLES,
        DISCARD_SHELLS,
        KEEP;

    }
}

