/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.geometrySerde;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.Serializable;
import org.apache.sedona.common.S2Geography.Geography;
import org.apache.sedona.common.S2Geography.GeographySerializer;
import org.apache.sedona.common.geometryObjects.Circle;
import org.apache.sedona.common.geometrySerde.GeometrySerializer;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeometrySerde
extends Serializer
implements Serializable {
    public void write(Kryo kryo, Output out, Object object) {
        if (object instanceof Circle) {
            Circle circle = (Circle)object;
            this.writeType(out, Type.CIRCLE);
            out.writeDouble(circle.getRadius().doubleValue());
            this.writeGeometry(kryo, out, circle.getCenterGeometry());
            this.writeUserData(kryo, out, circle);
        } else if (object instanceof Point || object instanceof LineString || object instanceof Polygon || object instanceof GeometryCollection) {
            this.writeType(out, Type.SHAPE);
            this.writeGeometry(kryo, out, (Geometry)object);
        } else if (object instanceof Envelope) {
            Envelope envelope = (Envelope)object;
            this.writeType(out, Type.ENVELOPE);
            out.writeDouble(envelope.getMinX());
            out.writeDouble(envelope.getMaxX());
            out.writeDouble(envelope.getMinY());
            out.writeDouble(envelope.getMaxY());
        } else if (object instanceof Geography) {
            this.writeType(out, Type.GEOGRAPHY);
            try {
                this.writeGeography(out, (Geography)object);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new UnsupportedOperationException("Cannot serialize object of type " + object.getClass().getName());
        }
    }

    private void writeType(Output out, Type type) {
        out.writeByte((byte)type.id);
    }

    private void writeGeometry(Kryo kryo, Output out, Geometry geometry) {
        byte[] data = GeometrySerializer.serialize(geometry);
        out.writeInt(data.length);
        out.write(data, 0, data.length);
        this.writeUserData(kryo, out, geometry);
    }

    private void writeGeography(Output out, Geography geography) throws IOException {
        byte[] data = GeographySerializer.serialize(geography);
        out.writeInt(data.length);
        out.write(data, 0, data.length);
    }

    private void writeUserData(Kryo kryo, Output out, Geometry geometry) {
        out.writeBoolean(geometry.getUserData() != null);
        if (geometry.getUserData() != null) {
            kryo.writeClass(out, geometry.getUserData().getClass());
            kryo.writeObject(out, geometry.getUserData());
        }
    }

    public Object read(Kryo kryo, Input input, Class aClass) {
        byte typeId = input.readByte();
        Type geometryType = Type.fromId(typeId);
        switch (geometryType) {
            case SHAPE: {
                return this.readGeometry(kryo, input);
            }
            case CIRCLE: {
                double radius = input.readDouble();
                Geometry centerGeometry = this.readGeometry(kryo, input);
                Object userData = this.readUserData(kryo, input);
                Circle circle = new Circle(centerGeometry, radius);
                circle.setUserData(userData);
                return circle;
            }
            case ENVELOPE: {
                double xMin = input.readDouble();
                double xMax = input.readDouble();
                double yMin = input.readDouble();
                double yMax = input.readDouble();
                if (xMin <= xMax) {
                    return new Envelope(xMin, xMax, yMin, yMax);
                }
                return new Envelope();
            }
            case GEOGRAPHY: {
                try {
                    return this.readGeography(input);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new UnsupportedOperationException("Cannot deserialize object of type " + String.valueOf((Object)geometryType));
    }

    private Object readUserData(Kryo kryo, Input input) {
        Object userData = null;
        if (input.readBoolean()) {
            Registration clazz = kryo.readClass(input);
            userData = kryo.readObject(input, clazz.getType());
        }
        return userData;
    }

    private Geometry readGeometry(Kryo kryo, Input input) {
        int length = input.readInt();
        byte[] bytes = new byte[length];
        input.readBytes(bytes);
        Geometry geometry = GeometrySerializer.deserialize(bytes);
        geometry.setUserData(this.readUserData(kryo, input));
        return geometry;
    }

    private Geography readGeography(Input input) throws IOException {
        int length = input.readInt();
        byte[] bytes = new byte[length];
        input.readBytes(bytes);
        Geography geography = GeographySerializer.deserialize(bytes);
        return geography;
    }

    private static enum Type {
        SHAPE(0),
        CIRCLE(1),
        ENVELOPE(2),
        GEOGRAPHY(3);

        private final int id;

        private Type(int id) {
            this.id = id;
        }

        public static Type fromId(int id) {
            for (Type type : Type.values()) {
                if (type.id != id) continue;
                return type;
            }
            return null;
        }
    }
}

