/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp.debug;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import org.twak.camp.Corner;
import org.twak.camp.Edge;
import org.twak.camp.Machine;
import org.twak.camp.Output;
import org.twak.camp.Skeleton;
import org.twak.camp.debug.DebugDevice;
import org.twak.camp.offset.OffsetSkeleton;
import org.twak.camp.ui.Bar;
import org.twak.camp.ui.Marker;
import org.twak.camp.ui.PointEditor;
import org.twak.utils.LContext;
import org.twak.utils.Mathz;
import org.twak.utils.Pair;
import org.twak.utils.collections.ConsecutivePairs;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.Loopable;
import org.twak.utils.collections.ReverseList;
import org.twak.utils.ui.Rainbow;

public class WeightedPointEditor
extends PointEditor {
    public Map<Bar, Double> weights = new HashMap<Bar, Double>();
    Point pressed = new Point();
    boolean changed = true;
    boolean busy = false;
    Output output;
    static int count = 0;

    public void positionMarker(Marker m3, Bar oldBar) {
        oldBar.mould.remove(m3);
        oldBar.mould.create(m3, null);
        this.weights.put(oldBar, Mathz.clamp(m3.distance(oldBar.start) / oldBar.start.distance(oldBar.end), 0.1, 0.9));
    }

    public WeightedPointEditor(PointEditor.BarSelected es) {
        super(es);
    }

    WeightedPointEditor() {
    }

    @Override
    protected void createInitial() {
        this.giggidyStar(0);
    }

    @Override
    public void movePoint(LContext<Bar> ctx, Point2d pt, Point2d location, MouseEvent evt) {
        if (pt instanceof Marker) {
            if (this.pressed == null) {
                this.pressed = evt.getPoint();
            }
            Marker m3 = (Marker)pt;
            m3.x = location.x;
            m3.y = location.y;
            this.positionMarker(m3, m3.bar);
        } else {
            pt.x = location.x;
            pt.y = location.y;
            for (Bar b : ctx.loop) {
                this.updateMarkers(b);
            }
        }
        this.changed = true;
    }

    public void updateMarkers(Bar b) {
        for (Marker m3 : b.mould.getAnchorsReadOnly(b.start, b.end, new Point2d[0])) {
            Vector2d dir = new Vector2d(b.end);
            dir.sub(b.start);
            dir.scale(Mathz.clamp(this.weights.get(b), 0.1, 0.9));
            dir.add(b.start);
            m3.set(dir);
            m3.bar = b;
        }
    }

    @Override
    public void remove(LContext<Bar> ctx, Point2d dragged) {
        this.changed = true;
        super.remove(ctx, dragged);
    }

    @Override
    public void addBetween(LContext<Bar> ctx, Point l) {
        this.changed = true;
        Point2d n = new Point2d(l.x, l.y);
        Bar b = new Bar(n, ctx.get().end);
        this.setup(b, 0.7);
        Loopable<Bar> loopable = ctx.loop.addAfter(ctx.loopable, b);
        ctx.get().end = n;
        this.dragged = new LContext<Bar>(loopable, ctx.loop);
        this.dragged.hook = n;
        loopable.get().tags.addAll(ctx.get().tags);
        this.edgeAdded(this.dragged);
        for (Bar bb : ctx.loop) {
            this.refreshMarkersOn(bb);
        }
    }

    public void setup(Bar b, double weight) {
        Marker wm = new Marker();
        wm.bar = b;
        this.weights.put(b, weight);
        Point2d loc = new Point2d(b.end);
        loc.sub(b.start);
        loc.scale(weight);
        loc.add(b.start);
        wm.set(loc);
        b.mould.create(wm, null);
        this.positionMarker(wm, b);
    }

    @Override
    public void paintPointEditor(Graphics2D g2) {
        g2.setColor(new Color(0, 50, 0));
        g2.setStroke(new BasicStroke(4.0f));
        for (Loop loop : this.edges) {
            for (Bar bar : loop) {
                g2.drawLine(this.ma.toX(bar.start.x), this.ma.toY(bar.start.y), this.ma.toX(bar.end.x), this.ma.toY(bar.end.y));
            }
        }
        for (Bar bar : this.edges.eIterator()) {
            this.drawPixel((Graphics)g2, bar.start);
        }
        if (this.changed) {
            this.recalculate();
        }
        this.paintMultiColourOutput(g2);
        for (Bar b : this.edges.eIterator()) {
            for (Marker mark : b.mould.markersOn(b)) {
                g2.setColor(Color.orange);
                int r = 5;
                g2.fillOval(this.ma.toX(mark.x) - r, this.ma.toY(mark.y) - r, r * 2, r * 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculate() {
        LoopL<Edge> out = new LoopL<Edge>();
        for (Loop lb : this.edges) {
            Loop<Edge> loop = new Loop<Edge>();
            out.add((Edge)((Object)loop));
            for (Bar bar : lb) {
                double val = 1.0;
                List<Marker> lm = bar.mould.markersOn(bar);
                if (lm.size() > 0 && lm.get(0) instanceof Marker) {
                    val = this.weights.get(bar);
                }
                Machine machine = new Machine(val);
                Edge e = new Edge(new Point3d(bar.start.x, bar.start.y, 0.0), new Point3d(bar.end.x, bar.end.y, 0.0), 0.7853981633974483);
                e.machine = machine;
                loop.append(e);
            }
            for (Loopable loopable : loop.loopableIterator()) {
                ((Edge)loopable.get()).end = ((Edge)loopable.getNext().get()).start;
            }
            Object offset = null;
            try {
                DebugDevice.reset();
                Skeleton skeleton = new Skeleton(out, true);
                skeleton.skeleton();
                this.output = skeleton.output;
            }
            finally {
                this.busy = false;
                this.repaint();
            }
        }
    }

    public void paintMultiColourOutput(Graphics2D g2) {
        if (this.output != null && this.output.faces != null) {
            int faceCount = this.output.faces.size();
            g2.setStroke(new BasicStroke(1.0f));
            int faceIndex = 0;
            for (Output.Face face : this.output.faces.values()) {
                ++faceIndex;
                if (!(face.edge.getAngle() < 0.0)) continue;
                this.paintFace(faceCount, faceIndex, face, g2);
            }
            faceIndex = 0;
            for (Output.Face face : this.output.faces.values()) {
                ++faceIndex;
                if (!(face.edge.getAngle() >= 0.0)) continue;
                this.paintFace(faceCount, faceIndex, face, g2);
            }
            for (Output.Face face : this.output.faces.values()) {
                for (Loop loop : face.getLoopL()) {
                    Polygon pg = new Polygon();
                    for (Point3d p : loop) {
                        pg.addPoint(this.ma.toX(p.x), this.ma.toY(p.y));
                    }
                    if (pg.npoints <= 2) continue;
                    g2.setColor(new Color(0, 50, 0));
                    g2.drawPolygon(pg);
                }
            }
        }
    }

    private void paintFace(int faceCount, int faceIndex, Output.Face face, Graphics2D g2) {
        LoopL<Point3d> loopl = face.getLoopL();
        int loopIndex = 0;
        for (Loop loop : loopl) {
            Polygon pg = new Polygon();
            for (Point3d p : loop) {
                pg.addPoint(this.ma.toX(p.x), this.ma.toY(p.y));
            }
            if (pg.npoints > 2) {
                if (loopIndex == 0) {
                    g2.setColor(Rainbow.getColour(faceIndex));
                } else {
                    g2.setColor(Color.white);
                }
                g2.fillPolygon(pg);
            }
            ++loopIndex;
        }
    }

    void giggidyStar(int frame) {
        this.edges.clear();
        Loop<Bar> loop = new Loop<Bar>();
        this.edges.add(loop);
        double[] factors = new double[]{0.5, 0.2, 0.12, 0.7, 0.58, 0.48, 0.44, 0.23, 0.98, 0.12, 0.1};
        int points = 9;
        ArrayList<Point2d> vals = new ArrayList<Point2d>();
        for (int i = 0; i < points; ++i) {
            double tau = Math.PI * 2 * (double)i / (double)points;
            double param = (double)frame / (600.0 * factors[i]);
            double a = factors[factors.length - i - 1] * 100.0;
            double b = 314.1592653589793 / (double)points;
            double yCen = 200.0 * Math.cos(tau);
            double xCen = 200.0 * Math.sin(tau);
            double x = xCen + a * Math.cos(param) + Math.cos(tau) - b * Math.sin(param) * Math.sin(tau);
            double y = yCen + a * Math.cos(param) + Math.sin(tau) + b * Math.sin(param) * Math.cos(tau);
            vals.add(new Point2d(x, y));
        }
        boolean c = false;
        for (Pair pair : new ConsecutivePairs(new ReverseList(vals), true)) {
            Bar b = new Bar((Point2d)pair.first(), (Point2d)pair.second());
            loop.append(b);
            this.setup(b, 0.8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public void paintUnthreaded(Graphics2D g2) {
        this.giggidyStar(count++);
        this.changed = true;
        g2.setColor(new Color(0, 50, 0));
        g2.setStroke(new BasicStroke(4.0f));
        for (Loop loop : this.edges) {
            for (Bar bar : loop) {
                g2.drawLine(this.ma.toX(bar.start.x), this.ma.toY(bar.start.y), this.ma.toX(bar.end.x), this.ma.toY(bar.end.y));
            }
        }
        for (Bar bar : this.edges.eIterator()) {
            this.drawPixel((Graphics)g2, bar.start);
        }
        LoopL<Edge> out = new LoopL<Edge>();
        for (Loop lb : this.edges) {
            LoopL<Corner> offset;
            Object e;
            Loop<Edge> loop = new Loop<Edge>();
            out.add((Edge)((Object)loop));
            for (Bar bar : lb) {
                double val = 1.0;
                List<Marker> lm = bar.mould.markersOn(bar);
                if (lm.size() > 0 && lm.get(0) instanceof Marker) {
                    val = this.weights.get(bar);
                }
                Machine machine = new Machine(val);
                e = new Edge(new Point3d(bar.start.x, bar.start.y, 0.0), new Point3d(bar.end.x, bar.end.y, 0.0), 0.7853981633974483);
                ((Edge)e).machine = machine;
                loop.append(e);
            }
            for (Loopable le : loop.loopableIterator()) {
                ((Edge)le.get()).end = ((Edge)le.getNext().get()).start;
            }
            try {
                DebugDevice.reset();
                Skeleton skeleton = new Skeleton(out, true);
                skeleton.skeleton();
                this.output = skeleton.output;
                offset = OffsetSkeleton.shrink(out, count % 200);
            }
            finally {
                this.busy = false;
                this.repaint();
            }
            this.paintMultiColourOutput(g2);
            for (Loop ls : offset) {
                for (Loopable c : ls.loopableIterator()) {
                    Point2d s2 = new Point2d(this.ma.toX(((Corner)c.get()).x), this.ma.toY(((Corner)c.get()).y));
                    e = new Point2d(this.ma.toX(((Corner)c.getNext().get()).x), this.ma.toY(((Corner)c.getNext().get()).y));
                    Line2D.Double l = new Line2D.Double(s2.x, s2.y, ((Point2d)e).x, ((Point2d)e).y);
                    g2.setColor(Color.white);
                    g2.setStroke(new BasicStroke(3.0f));
                    g2.draw(l);
                }
            }
        }
    }
}

