/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp;

import java.util.Comparator;
import java.util.Iterator;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.twak.camp.Edge;
import org.twak.camp.Machine;
import org.twak.camp.Skeleton;
import org.twak.camp.ui.Bar;
import org.twak.utils.Cache;
import org.twak.utils.LContext;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.Loopable;

public class Corner
extends Point3d
implements Iterable<Corner> {
    public Edge nextL;
    public Edge prevL;
    public Corner nextC;
    public Corner prevC;

    public Corner(double x, double y, double z) {
        super(x, y, z);
    }

    public Corner(Tuple3d in) {
        super(in);
    }

    public Corner(double x, double y) {
        super(x, y, 0.0);
    }

    public Corner(Point2d p) {
        super(p.x, p.y, 0.0);
    }

    public Point3d getLoc3() {
        return new Point3d(this.x, this.y, 0.0);
    }

    @Override
    public boolean equals(Object t1) {
        return this == t1;
    }

    @Override
    public String toString() {
        return String.format("(%f,%f,%f)", this.x, this.y, this.z);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public Iterator iterator() {
        return new CornerIterator(this);
    }

    public static void replace(Corner old, Corner neu, Skeleton skel) {
        old.prevL.currentCorners.remove(old);
        old.nextL.currentCorners.remove(old);
        old.nextC.prevC = neu;
        old.prevC.nextC = neu;
        neu.prevC = old.prevC;
        neu.nextC = old.nextC;
        neu.nextL = old.nextL;
        neu.prevL = old.prevL;
        neu.prevL.currentCorners.add(neu);
        neu.nextL.currentCorners.add(neu);
        skel.liveCorners.remove(old);
        skel.liveCorners.add(neu);
    }

    public static LoopL<Corner> dupeNewAll(LoopL<Corner> ribbon) {
        Cache<Corner, Corner> cacheC = new Cache<Corner, Corner>(){
            Cache<Machine, Machine> cacheM = new Cache<Machine, Machine>(){

                @Override
                public Machine create(Machine i) {
                    return new Machine(i.currentAngle);
                }
            };
            Cache<Edge, Edge> cacheE = new Cache<Edge, Edge>(){

                @Override
                public Edge create(Edge i) {
                    Edge out = new Edge(this.getCorner(i.start), this.getCorner(i.end));
                    out.setAngle(i.getAngle());
                    out.machine = cacheM.get(i.machine);
                    for (Corner c : i.currentCorners) {
                        out.currentCorners.add(this.getCorner(c));
                    }
                    return out;
                }
            };

            public Corner getCorner(Corner input) {
                Corner ner = (Corner)this.get(input);
                return ner;
            }

            @Override
            public Corner create(Corner i) {
                Corner ner = new Corner(i.x, i.y);
                this.cache.put(i, ner);
                ner.nextC = (Corner)this.get(i.nextC);
                ner.prevC = (Corner)this.get(i.prevC);
                ner.nextL = this.cacheE.get(i.nextL);
                ner.prevL = this.cacheE.get(i.prevL);
                return ner;
            }
        };
        LoopL<Corner> loopl = new LoopL<Corner>();
        for (Loop loop : ribbon) {
            Loop<Corner> loop2 = new Loop<Corner>();
            loopl.add((Corner)((Object)loop2));
            for (Corner c : loop) {
                loop2.append((Corner)cacheC.get(c));
            }
        }
        return loopl;
    }

    public static LoopL<Point3d> dupeNewAllPoints(LoopL<Point3d> ribbon) {
        Cache<Point3d, Point3d> cacheC = new Cache<Point3d, Point3d>(){

            @Override
            public Point3d create(Point3d i) {
                return new Point3d(i);
            }
        };
        LoopL<Point3d> loopl = new LoopL<Point3d>();
        for (Loop loop : ribbon) {
            Loop<Point3d> loop2 = new Loop<Point3d>();
            loopl.add((Point3d)((Object)loop2));
            for (Point3d c : loop) {
                loop2.append((Point3d)cacheC.get(c));
            }
        }
        return loopl;
    }

    public static LoopL<Point3d> dupeNewAllPoints(LoopL<Point3d> ribbon, final double height) {
        Cache<Point3d, Point3d> cacheC = new Cache<Point3d, Point3d>(){

            @Override
            public Point3d create(Point3d i) {
                return new Point3d(i.x, i.y, height);
            }
        };
        LoopL<Point3d> loopl = new LoopL<Point3d>();
        for (Loop loop : ribbon) {
            Loop<Point3d> loop2 = new Loop<Point3d>();
            loopl.add((Point3d)((Object)loop2));
            for (Point3d c : loop) {
                loop2.append((Point3d)cacheC.get(c));
            }
        }
        return loopl;
    }

    public static LoopL<Corner> fromBar(LoopL<Bar> ribbon) {
        LoopL<Corner> loopl = new LoopL<Corner>();
        Cache<Point2d, Corner> cache = new Cache<Point2d, Corner>(){

            @Override
            public Corner create(Point2d i) {
                return new Corner(i.x, i.y);
            }
        };
        for (Loop loop : ribbon) {
            Loop<Corner> loop2 = new Loop<Corner>();
            loopl.add((Corner)((Object)loop2));
            for (Bar bar : loop) {
                loop2.append((Corner)cache.get(bar.start));
            }
        }
        for (Loop loop : loopl) {
            for (Loopable loopable : loop.loopableIterator()) {
                Edge e;
                Corner n;
                Corner p = (Corner)loopable.get();
                p.nextC = n = (Corner)loopable.getNext().get();
                n.prevC = p;
                p.nextL = e = new Edge(p, n);
                n.prevL = e;
            }
        }
        return loopl;
    }

    public static LoopL<Point2d> toPoint2d(LoopL<Corner> shape) {
        return new LoopL.Map<Point2d>(shape){

            @Override
            public Point2d map(Loopable<Corner> input) {
                return new Point2d(input.get().x, input.get().y);
            }
        }.run();
    }

    public static LoopL<Point3d> toPoint3d(LoopL<Corner> shape) {
        return new LoopL.Map<Point3d>(shape){

            @Override
            public Point3d map(Loopable<Corner> input) {
                return new Point3d(input.get().x, input.get().y, input.get().z);
            }
        }.run();
    }

    public static LContext<Corner> findLContext(LoopL<Corner> in, Corner c) {
        for (Loop loop : in) {
            for (Loopable lc : loop.loopableIterator()) {
                if (lc.get() != c) continue;
                return new LContext<Corner>(lc, loop);
            }
        }
        return null;
    }

    public static LoopL<Corner> cornerToEdgeLoopL(LoopL<Edge> in) {
        LoopL<Corner> corners = new LoopL<Corner>();
        for (Loop loop : in) {
            Loop<Corner> lc = new Loop<Corner>();
            corners.add((Corner)((Object)lc));
            for (Edge e : loop) {
                lc.append(e.start);
                e.start.nextL = e;
                e.end.prevL = e;
                e.start.nextC = e.end;
                e.end.prevC = e.start;
            }
        }
        return corners;
    }

    public static class CornerDistanceComparator
    implements Comparator<Point3d> {
        Point3d start;

        public CornerDistanceComparator(Point3d corner) {
            this.start = corner;
        }

        @Override
        public int compare(Point3d o1, Point3d o2) {
            return Double.compare(this.start.distanceSquared(o1), this.start.distanceSquared(o2));
        }
    }

    public class CornerIterator
    implements Iterator<Corner> {
        Corner s;
        Corner n;
        Corner start;

        public CornerIterator(Corner start) {
            this.s = start;
            this.n = null;
        }

        @Override
        public boolean hasNext() {
            if (this.s == null) {
                return false;
            }
            if (this.n == null) {
                return true;
            }
            return this.n != this.s;
        }

        @Override
        public Corner next() {
            if (this.n == null) {
                this.n = this.s;
            }
            Corner out = this.n;
            this.n = this.n.nextC;
            return out;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

