/*
 * Decompiled with CFR 0.152.
 */
package org.graphframes.examples;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.graphframes.GraphFrame;
import org.graphframes.examples.LDBCUtils;
import org.graphframes.lib.TriangleCount;

public class TriangleCountExample {
    public static void main(String[] stringArray) {
        String string = stringArray.length > 0 ? stringArray[0] : "kgs";
        Path path = stringArray.length > 1 ? Paths.get(stringArray[1], new String[0]) : Paths.get("/tmp/ldbc_graphalitics_datesets", new String[0]);
        Path path2 = path.resolve(string);
        SparkConf sparkConf = new SparkConf().setAppName("TriangleCountExample").set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        SparkSession sparkSession = SparkSession.builder().config(sparkConf).getOrCreate();
        SparkContext sparkContext = sparkSession.sparkContext();
        sparkContext.setLogLevel("ERROR");
        sparkContext.setCheckpointDir("/tmp/graphframes-checkpoints");
        LDBCUtils.downloadLDBCIfNotExists(path, string);
        StructField[] structFieldArray = new StructField[]{new StructField("src", DataTypes.LongType, true, Metadata.empty()), new StructField("dst", DataTypes.LongType, true, Metadata.empty())};
        Dataset dataset = sparkSession.read().format("csv").option("header", "false").option("delimiter", " ").schema(new StructType(structFieldArray)).load(path2.resolve(string + ".e").toString()).persist(StorageLevel.MEMORY_AND_DISK_SER());
        System.out.println("Edges loaded: " + dataset.count());
        StructField[] structFieldArray2 = new StructField[]{new StructField("id", DataTypes.LongType, true, Metadata.empty())};
        Dataset dataset2 = sparkSession.read().format("csv").option("header", "false").option("delimiter", " ").schema(new StructType(structFieldArray2)).load(path2.resolve(string + ".v").toString()).persist(StorageLevel.MEMORY_AND_DISK_SER());
        System.out.println("Vertices loaded: " + dataset2.count());
        long l = System.currentTimeMillis();
        GraphFrame graphFrame = GraphFrame.apply((Dataset<Row>)dataset2, (Dataset<Row>)dataset);
        TriangleCount triangleCount = graphFrame.triangleCount();
        Dataset<Row> dataset3 = triangleCount.run();
        dataset3.show(20, false);
        long l2 = ((Row)dataset3.select(new Column[]{functions.sum((String)"count")}).first()).getLong(0);
        System.out.println("Found triangles: " + l2);
        long l3 = System.currentTimeMillis();
        System.out.println("Total running time in seconds: " + (double)(l3 - l) / 1000.0);
    }
}

