/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.geoparquet.internal;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.VersionParser;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.ConfigurationUtil;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.sedona.shaded.guava.annotations.VisibleForTesting;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetColumn;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetSchemaConverter;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Option;

public abstract class SpecificParquetRecordReaderBase<T>
extends RecordReader<Void, T> {
    protected Path file;
    protected MessageType fileSchema;
    protected MessageType requestedSchema;
    protected StructType sparkSchema;
    protected StructType sparkRequestedSchema;
    protected VersionParser.ParsedVersion writerVersion;
    protected ParquetColumn parquetColumn;
    protected long totalRowCount;
    protected ParquetRowGroupReader reader;

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.initialize(inputSplit, taskAttemptContext, (Option<ParquetMetadata>)Option.empty());
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext, Option<ParquetMetadata> fileFooter) throws IOException, InterruptedException {
        ParquetFileReader fileReader;
        Configuration configuration = taskAttemptContext.getConfiguration();
        FileSplit split = (FileSplit)inputSplit;
        this.file = split.getPath();
        if (fileFooter.isDefined()) {
            fileReader = new ParquetFileReader(configuration, this.file, (ParquetMetadata)fileFooter.get());
        } else {
            ParquetReadOptions options = HadoopReadOptions.builder((Configuration)configuration, (Path)this.file).withRange(split.getStart(), split.getStart() + split.getLength()).build();
            fileReader = new ParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)this.file, (Configuration)configuration), options);
        }
        this.reader = new ParquetRowGroupReaderImpl(fileReader);
        this.fileSchema = fileReader.getFileMetaData().getSchema();
        try {
            this.writerVersion = VersionParser.parse((String)fileReader.getFileMetaData().getCreatedBy());
        }
        catch (Exception options) {
            // empty catch block
        }
        Map fileMetadata = fileReader.getFileMetaData().getKeyValueMetaData();
        ReadSupport<T> readSupport = SpecificParquetRecordReaderBase.getReadSupportInstance(this.getReadSupportClass(configuration));
        ReadSupport.ReadContext readContext = readSupport.init(new InitContext(taskAttemptContext.getConfiguration(), SpecificParquetRecordReaderBase.toSetMultiMap(fileMetadata), this.fileSchema));
        this.requestedSchema = readContext.getRequestedSchema();
        fileReader.setRequestedSchema(this.requestedSchema);
        String sparkRequestedSchemaString = configuration.get(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA());
        this.sparkRequestedSchema = StructType$.MODULE$.fromString(sparkRequestedSchemaString);
        ParquetToSparkSchemaConverter converter = new ParquetToSparkSchemaConverter(configuration);
        this.parquetColumn = converter.convertParquetColumn(this.requestedSchema, (Option<StructType>)Option.apply((Object)this.sparkRequestedSchema));
        this.sparkSchema = (StructType)this.parquetColumn.sparkType();
        this.totalRowCount = fileReader.getFilteredRecordCount();
    }

    protected void initialize(String path, List<String> columns) throws IOException {
        Configuration config = new Configuration();
        config.setBoolean(SQLConf.PARQUET_BINARY_AS_STRING().key(), false);
        config.setBoolean(SQLConf.PARQUET_INT96_AS_TIMESTAMP().key(), false);
        config.setBoolean(SQLConf.CASE_SENSITIVE().key(), false);
        config.setBoolean(SQLConf.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key(), false);
        config.setBoolean(SQLConf.LEGACY_PARQUET_NANOS_AS_LONG().key(), false);
        this.file = new Path(path);
        long length = this.file.getFileSystem(config).getFileStatus(this.file).getLen();
        ParquetReadOptions options = HadoopReadOptions.builder((Configuration)config, (Path)this.file).withRange(0L, length).build();
        ParquetFileReader fileReader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)this.file, (Configuration)config), (ParquetReadOptions)options);
        this.reader = new ParquetRowGroupReaderImpl(fileReader);
        this.fileSchema = fileReader.getFooter().getFileMetaData().getSchema();
        if (columns == null) {
            this.requestedSchema = this.fileSchema;
        } else if (columns.size() > 0) {
            Types.MessageTypeBuilder builder = Types.buildMessage();
            for (String s2 : columns) {
                if (!this.fileSchema.containsField(s2)) {
                    throw new IOException("Can only project existing columns. Unknown field: " + s2 + " File schema:\n" + this.fileSchema);
                }
                builder.addFields(new Type[]{this.fileSchema.getType(s2)});
            }
            this.requestedSchema = builder.named(ParquetSchemaConverter.SPARK_PARQUET_SCHEMA_NAME());
        } else {
            this.requestedSchema = ParquetSchemaConverter.EMPTY_MESSAGE();
        }
        fileReader.setRequestedSchema(this.requestedSchema);
        this.parquetColumn = new ParquetToSparkSchemaConverter(config).convertParquetColumn(this.requestedSchema, (Option<StructType>)Option.empty());
        this.sparkSchema = (StructType)this.parquetColumn.sparkType();
        this.totalRowCount = fileReader.getFilteredRecordCount();
    }

    @VisibleForTesting
    protected void initialize(MessageType fileSchema, MessageType requestedSchema, ParquetRowGroupReader rowGroupReader, int totalRowCount) throws IOException {
        this.reader = rowGroupReader;
        this.fileSchema = fileSchema;
        this.requestedSchema = requestedSchema;
        Configuration config = new Configuration();
        config.setBoolean(SQLConf.PARQUET_BINARY_AS_STRING().key(), false);
        config.setBoolean(SQLConf.PARQUET_INT96_AS_TIMESTAMP().key(), false);
        config.setBoolean(SQLConf.CASE_SENSITIVE().key(), false);
        config.setBoolean(SQLConf.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key(), false);
        config.setBoolean(SQLConf.LEGACY_PARQUET_NANOS_AS_LONG().key(), false);
        this.parquetColumn = new ParquetToSparkSchemaConverter(config).convertParquetColumn(requestedSchema, (Option<StructType>)Option.empty());
        this.sparkSchema = (StructType)this.parquetColumn.sparkType();
        this.totalRowCount = totalRowCount;
    }

    public Void getCurrentKey() {
        return null;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    private static <K, V> Map<K, Set<V>> toSetMultiMap(Map<K, V> map) {
        HashMap setMultiMap = new HashMap();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            HashSet<V> set = new HashSet<V>();
            set.add(entry.getValue());
            setMultiMap.put(entry.getKey(), Collections.unmodifiableSet(set));
        }
        return Collections.unmodifiableMap(setMultiMap);
    }

    private Class<? extends ReadSupport<T>> getReadSupportClass(Configuration configuration) {
        return ConfigurationUtil.getClassFromConfig((Configuration)configuration, (String)"parquet.read.support.class", ReadSupport.class);
    }

    private static <T> ReadSupport<T> getReadSupportInstance(Class<? extends ReadSupport<T>> readSupportClass) {
        try {
            return readSupportClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new BadConfigurationException("could not instantiate read support class", (Throwable)e);
        }
    }

    private static class ParquetRowGroupReaderImpl
    implements ParquetRowGroupReader {
        private final ParquetFileReader reader;

        ParquetRowGroupReaderImpl(ParquetFileReader reader) {
            this.reader = reader;
        }

        @Override
        public PageReadStore readNextRowGroup() throws IOException {
            return this.reader.readNextFilteredRowGroup();
        }

        @Override
        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    static interface ParquetRowGroupReader
    extends Closeable {
        public PageReadStore readNextRowGroup() throws IOException;
    }
}

