/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v13SynchedPool.nt;

import ch.ethz.globis.pht64kd.MaxKTreeI;
import ch.ethz.globis.phtree.util.Refs;
import ch.ethz.globis.phtree.v13SynchedPool.nt.NtNode;
import ch.ethz.globis.phtree.v13SynchedPool.nt.NtNodeIteratorMinMax;
import java.util.NoSuchElementException;

public final class NtIteratorMinMax<T>
implements MaxKTreeI.PhIterator64<T> {
    private final PhIteratorStack stack;
    private long min;
    private long max;
    private final boolean isRootNegative;
    private final MaxKTreeI.NtEntry<T> resultBuf1;
    private final MaxKTreeI.NtEntry<T> resultBuf2;
    private boolean isFreeBuf1;
    boolean isFinished = false;

    public NtIteratorMinMax(int keyBitWidth) {
        this.stack = new PhIteratorStack(NtNode.calcTreeHeight(keyBitWidth));
        this.isRootNegative = keyBitWidth == 64;
        this.resultBuf1 = new MaxKTreeI.NtEntry<Object>(0L, new long[keyBitWidth], null);
        this.resultBuf2 = new MaxKTreeI.NtEntry<Object>(0L, new long[keyBitWidth], null);
    }

    @Override
    public void reset(MaxKTreeI tree, long min2, long max) {
        this.reset((NtNode)tree.getRoot(), min2, max);
    }

    @Override
    public void reset(MaxKTreeI tree) {
        this.reset((NtNode)tree.getRoot(), Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public MaxKTreeI.PhIterator64<T> reset(NtNode<T> root, long min2, long max) {
        this.min = min2;
        this.max = max;
        this.stack.size = 0;
        this.isFinished = false;
        if (root == null) {
            this.isFinished = true;
            return this;
        }
        this.stack.prepareAndPush(root, 0L);
        this.findNextElement();
        return this;
    }

    private void findNextElement() {
        MaxKTreeI.NtEntry<T> result;
        MaxKTreeI.NtEntry<T> ntEntry = result = this.isFreeBuf1 ? this.resultBuf1 : this.resultBuf2;
        while (!this.stack.isEmpty()) {
            NtNodeIteratorMinMax<T> p = this.stack.peek();
            while (p.increment(result)) {
                if (p.isNextSub()) {
                    p = this.stack.prepareAndPush(p.getCurrentSubNode(), p.getPrefix());
                    continue;
                }
                this.isFreeBuf1 = !this.isFreeBuf1;
                return;
            }
            this.stack.pop();
        }
        this.isFinished = true;
    }

    @Override
    public long nextKey() {
        return this.nextEntryReuse().getKey();
    }

    @Override
    public long[] nextKdKey() {
        long[] key = this.nextEntryReuse().getKdKey();
        long[] ret = new long[key.length];
        System.arraycopy(key, 0, ret, 0, key.length);
        return ret;
    }

    @Override
    public T nextValue() {
        return this.nextEntryReuse().getValue();
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished;
    }

    @Override
    @Deprecated
    public MaxKTreeI.NtEntry<T> nextEntry() {
        return new MaxKTreeI.NtEntry<T>(this.nextEntryReuse());
    }

    @Override
    public T next() {
        return this.nextEntryReuse().getValue();
    }

    @Override
    public MaxKTreeI.NtEntry<T> nextEntryReuse() {
        if (this.isFinished) {
            throw new NoSuchElementException();
        }
        MaxKTreeI.NtEntry<T> ret = this.isFreeBuf1 ? this.resultBuf2 : this.resultBuf1;
        this.findNextElement();
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private class PhIteratorStack {
        private final NtNodeIteratorMinMax<T>[] stack;
        private int size = 0;

        public PhIteratorStack(int depth) {
            this.stack = Refs.newArray(NtNodeIteratorMinMax.class, depth);
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public NtNodeIteratorMinMax<T> prepareAndPush(NtNode<T> node, long currentPrefix) {
            NtNodeIteratorMinMax ni;
            if ((ni = this.stack[this.size++]) == null) {
                ni = new NtNodeIteratorMinMax();
                this.stack[this.size - 1] = ni;
            }
            ni.init(NtIteratorMinMax.this.min, NtIteratorMinMax.this.max, currentPrefix, node, NtIteratorMinMax.this.isRootNegative && this.size == 1);
            return ni;
        }

        public NtNodeIteratorMinMax<T> peek() {
            return this.stack[this.size - 1];
        }

        public NtNodeIteratorMinMax<T> pop() {
            return this.stack[--this.size];
        }
    }
}

