/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree;

import ch.ethz.globis.phtree.PhEntryF;
import java.util.Comparator;

public class PhEntryDistF<T>
extends PhEntryF<T> {
    public static final Comparator<PhEntryDistF<?>> COMP = (o1, o2) -> {
        double d = o1.dist - o2.dist;
        return d > 0.0 ? 1 : (d < 0.0 ? -1 : 0);
    };
    private double dist;

    public PhEntryDistF(double[] key, T value, double dist) {
        super(key, value);
        this.dist = dist;
    }

    public PhEntryDistF(PhEntryF<T> e, double dist) {
        super(e);
        this.dist = dist;
    }

    public PhEntryDistF(PhEntryDistF<T> e) {
        super(e);
        this.dist = e.dist();
    }

    public void setCopyKey(double[] key, T val, double dist) {
        System.arraycopy(key, 0, this.getKey(), 0, this.getKey().length);
        this.set(val, dist);
    }

    public void set(PhEntryF<T> e, double dist) {
        super.setValue(e.getValue());
        System.arraycopy(e.getKey(), 0, this.getKey(), 0, this.getKey().length);
        this.dist = dist;
    }

    public void set(T val, double dist) {
        super.setValue(val);
        this.dist = dist;
    }

    public void clear() {
        this.dist = Double.MAX_VALUE;
    }

    public double dist() {
        return this.dist;
    }

    public void setDist(double dist) {
        this.dist = dist;
    }

    @Override
    public String toString() {
        return super.toString() + " dist=" + this.dist;
    }
}

