/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl.event;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.SerializationException;
import org.apache.rocketmq.common.utils.FastJsonSerializer;
import org.apache.rocketmq.common.utils.Serializer;
import org.apache.rocketmq.controller.impl.event.AlterSyncStateSetEvent;
import org.apache.rocketmq.controller.impl.event.ApplyBrokerIdEvent;
import org.apache.rocketmq.controller.impl.event.CleanBrokerDataEvent;
import org.apache.rocketmq.controller.impl.event.ElectMasterEvent;
import org.apache.rocketmq.controller.impl.event.EventMessage;
import org.apache.rocketmq.controller.impl.event.EventType;
import org.apache.rocketmq.controller.impl.event.UpdateBrokerAddressEvent;
import org.apache.rocketmq.logging.org.slf4j.Logger;

public class ListEventSerializer {
    private static final Serializer SERIALIZER = new FastJsonSerializer();

    private ListEventSerializer() {
    }

    private static void putShort(byte[] memory, int index, int value) {
        memory[index] = (byte)(value >>> 8);
        memory[index + 1] = (byte)value;
    }

    private static void putShort(ByteArrayOutputStream outputStream, int value) {
        outputStream.write((byte)(value >>> 8));
        outputStream.write((byte)value);
    }

    private static short getShort(byte[] memory, int index) {
        return (short)(memory[index] << 8 | memory[index + 1] & 0xFF);
    }

    private static void putInt(byte[] memory, int index, int value) {
        memory[index] = (byte)(value >>> 24);
        memory[index + 1] = (byte)(value >>> 16);
        memory[index + 2] = (byte)(value >>> 8);
        memory[index + 3] = (byte)value;
    }

    private static void putInt(ByteArrayOutputStream outputStream, int value) {
        outputStream.write((byte)(value >>> 24));
        outputStream.write((byte)(value >>> 16));
        outputStream.write((byte)(value >>> 8));
        outputStream.write((byte)value);
    }

    private static int getInt(byte[] memory, int index) {
        return memory[index] << 24 | (memory[index + 1] & 0xFF) << 16 | (memory[index + 2] & 0xFF) << 8 | memory[index + 3] & 0xFF;
    }

    public static byte[] serialize(List<EventMessage> message, Logger log) throws SerializationException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (EventMessage eventMessage : message) {
            short eventType = eventMessage.getEventType().getId();
            byte[] data = SERIALIZER.serialize((Object)eventMessage);
            if (data != null && data.length > 0) {
                ListEventSerializer.putShort(outputStream, eventType);
                ListEventSerializer.putInt(outputStream, data.length);
                outputStream.write(data, 0, data.length);
                continue;
            }
            log.error("serialize event message error, event: {}, this event will be discard", (Object)eventMessage);
        }
        return outputStream.toByteArray();
    }

    public static List<EventMessage> deserialize(byte[] bytes, Logger log) throws SerializationException {
        ArrayList<EventMessage> eventMessages = new ArrayList<EventMessage>();
        if (bytes == null || bytes.length <= 6) {
            return eventMessages;
        }
        int index = 0;
        while (index < bytes.length) {
            short eventId = ListEventSerializer.getShort(bytes, index);
            int dataLength = ListEventSerializer.getInt(bytes, index += 2);
            index += 4;
            if (dataLength > 0) {
                byte[] data = new byte[dataLength];
                System.arraycopy(bytes, index, data, 0, dataLength);
                EventType eventType = EventType.from(eventId);
                if (eventType != null) {
                    switch (eventType) {
                        case ALTER_SYNC_STATE_SET_EVENT: {
                            eventMessages.add((EventMessage)SERIALIZER.deserialize(data, AlterSyncStateSetEvent.class));
                            break;
                        }
                        case APPLY_BROKER_ID_EVENT: {
                            eventMessages.add((EventMessage)SERIALIZER.deserialize(data, ApplyBrokerIdEvent.class));
                            break;
                        }
                        case ELECT_MASTER_EVENT: {
                            eventMessages.add((EventMessage)SERIALIZER.deserialize(data, ElectMasterEvent.class));
                            break;
                        }
                        case CLEAN_BROKER_DATA_EVENT: {
                            eventMessages.add((EventMessage)SERIALIZER.deserialize(data, CleanBrokerDataEvent.class));
                            break;
                        }
                        case UPDATE_BROKER_ADDRESS: {
                            eventMessages.add((EventMessage)SERIALIZER.deserialize(data, UpdateBrokerAddressEvent.class));
                            break;
                        }
                        default: {
                            log.error("deserialize event message error, event id: {}, data: {}", (Object)eventId, (Object)data);
                            break;
                        }
                    }
                } else {
                    log.error("deserialize event message error, event id: {}, data: {}", (Object)eventId, (Object)data);
                }
                index += dataLength;
                continue;
            }
            log.error("deserialize event message error, event id: {}, data length: {}", (Object)eventId, (Object)dataLength);
        }
        return eventMessages;
    }
}

