/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.GetSpaceUsed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public abstract class CachingGetSpaceUsed
implements Closeable,
GetSpaceUsed {
    static final Logger LOG = LoggerFactory.getLogger(CachingGetSpaceUsed.class);
    protected final AtomicLong used = new AtomicLong();
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final long refreshInterval;
    private final long jitter;
    private final String dirPath;
    private Thread refreshUsed;
    private boolean shouldFirstRefresh;

    public CachingGetSpaceUsed(GetSpaceUsed.Builder builder) throws IOException {
        this(builder.getPath(), builder.getInterval(), builder.getJitter(), builder.getInitialUsed());
    }

    CachingGetSpaceUsed(File path, long interval, long jitter, long initialUsed) throws IOException {
        this.dirPath = path.getCanonicalPath();
        this.refreshInterval = interval;
        this.jitter = jitter;
        this.used.set(initialUsed);
        this.shouldFirstRefresh = true;
    }

    void init() {
        if (this.used.get() < 0L) {
            this.used.set(0L);
            if (!this.shouldFirstRefresh) {
                this.initRefeshThread(true);
                return;
            }
            this.refresh();
        }
        this.initRefeshThread(false);
    }

    private void initRefeshThread(boolean runImmediately) {
        if (this.refreshInterval > 0L) {
            this.refreshUsed = new Thread((Runnable)new RefreshThread(this, runImmediately), "refreshUsed-" + this.dirPath);
            this.refreshUsed.setDaemon(true);
            this.refreshUsed.start();
        } else {
            this.running.set(false);
            this.refreshUsed = null;
        }
    }

    protected abstract void refresh();

    protected void setShouldFirstRefresh(boolean shouldFirstRefresh) {
        this.shouldFirstRefresh = shouldFirstRefresh;
    }

    @Override
    public long getUsed() throws IOException {
        return Math.max(this.used.get(), 0L);
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public void incDfsUsed(long value) {
        this.used.addAndGet(value);
    }

    boolean running() {
        return this.running.get();
    }

    @VisibleForTesting
    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    @VisibleForTesting
    public long getJitter() {
        return this.jitter;
    }

    protected void setUsed(long usedValue) {
        this.used.set(usedValue);
    }

    @Override
    public void close() throws IOException {
        this.running.set(false);
        if (this.refreshUsed != null) {
            this.refreshUsed.interrupt();
        }
    }

    private static final class RefreshThread
    implements Runnable {
        final CachingGetSpaceUsed spaceUsed;
        private boolean runImmediately;

        RefreshThread(CachingGetSpaceUsed spaceUsed, boolean runImmediately) {
            this.spaceUsed = spaceUsed;
            this.runImmediately = runImmediately;
        }

        @Override
        public void run() {
            while (this.spaceUsed.running()) {
                try {
                    long refreshInterval = this.spaceUsed.refreshInterval;
                    if (this.spaceUsed.jitter > 0L) {
                        long jitter = this.spaceUsed.jitter;
                        refreshInterval += ThreadLocalRandom.current().nextLong(-jitter, jitter);
                    }
                    refreshInterval = Math.max(refreshInterval, 1L);
                    if (!this.runImmediately) {
                        Thread.sleep(refreshInterval);
                    }
                    this.runImmediately = false;
                    this.spaceUsed.refresh();
                }
                catch (InterruptedException e) {
                    LOG.warn("Thread Interrupted waiting to refresh disk information: " + e.getMessage());
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

