# PIP-162: LTS Releases

Some users of Pulsar cannot move as quickly as development does. In order to better support users we should declare certain release versions to be "Long Term Supported" or **LTS**

One motivation to declare a version LTS would be if the next version requires an environmental change like an update to the JDK version, or a major protocol change.

## Goal

For each version that we want to consider LTS. The project will have a discussion of at least one week on the dev@ mailing list. Should that discussion reach a positive consensus we will follow with a one week vote on the dev@ mailing list.

## Implementation

We will need to add information to the website.
- Add a `lts_versions.json` file to record LTS versions along with supported through date.
- Update the download page in the releases section to describe current LTS versions.
- Mark LTS versions in the "Older Releases" section.
- The latest LTS version is left in the release folder in `svn.apache.org/dist/releases/pulsar`. For example, when 2.11.0 is released then 2.10.0 would remain in the Apache Releases directory.


## Rejected Alternatives

The alternative being rejected is our current approach which is aspirational, but does not give a clear understanding of which versions we clearly intended to support.

If we consider other LTS candidates from current releases. The only viable version is 2.7.4. The 2.8 and 2.9 versions have feature incompleteness which make them less good for LTS
