/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.memory.NativeMemory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.HashOperations;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.SketchesStateException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.Intersection;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.SetOperation;
import com.yahoo.sketches.theta.Sketch;
import java.util.Arrays;

final class IntersectionImpl
extends SetOperation
implements Intersection {
    private final short seedHash_;
    private int lgArrLongs_;
    private int curCount_;
    private long thetaLong_;
    private boolean empty_;
    private long[] hashTable_ = null;
    private int maxLgArrLongs_ = 0;
    private Memory mem_ = null;

    private IntersectionImpl(short seedHash) {
        this.seedHash_ = seedHash;
    }

    static IntersectionImpl initNewHeapInstance(long seed) {
        IntersectionImpl impl = new IntersectionImpl(IntersectionImpl.computeSeedHash(seed));
        impl.empty_ = false;
        impl.curCount_ = -1;
        impl.thetaLong_ = Long.MAX_VALUE;
        impl.lgArrLongs_ = 0;
        impl.hashTable_ = null;
        impl.mem_ = null;
        return impl;
    }

    static IntersectionImpl heapifyInstance(Memory srcMem, long seed) {
        int preLongs = 3;
        long[] preArr = new long[3];
        srcMem.getLongArray(0L, preArr, 0, 3);
        long pre0 = preArr[0];
        int preambleLongs = PreambleUtil.extractPreLongs(pre0);
        if (preambleLongs != 3) {
            throw new SketchesArgumentException("PreambleLongs must equal 3");
        }
        int serVer = PreambleUtil.extractSerVer(pre0);
        if (serVer != 3) {
            throw new SketchesArgumentException("Ser Version must equal 3");
        }
        int famID = PreambleUtil.extractFamilyID(pre0);
        Family.INTERSECTION.checkFamilyID(famID);
        short seedHash = IntersectionImpl.computeSeedHash(seed);
        short seedHashMem = (short)PreambleUtil.extractSeedHash(pre0);
        Util.checkSeedHashes(seedHashMem, seedHash);
        IntersectionImpl impl = new IntersectionImpl(seedHash);
        impl.lgArrLongs_ = PreambleUtil.extractLgArrLongs(pre0);
        int flags = PreambleUtil.extractFlags(pre0);
        impl.empty_ = (flags & 4) > 0;
        impl.curCount_ = srcMem.getInt(8L);
        impl.thetaLong_ = srcMem.getLong(16L);
        if (impl.empty_) {
            if (impl.curCount_ != 0) {
                throw new SketchesArgumentException("srcMem empty state inconsistent with curCount: " + impl.empty_ + "," + impl.curCount_);
            }
        } else if (impl.curCount_ > 0) {
            impl.hashTable_ = new long[1 << impl.lgArrLongs_];
            srcMem.getLongArray(24L, impl.hashTable_, 0, 1 << impl.lgArrLongs_);
        }
        impl.mem_ = null;
        return impl;
    }

    static IntersectionImpl initNewDirectInstance(long seed, Memory dstMem) {
        short seedHash = IntersectionImpl.computeSeedHash(seed);
        IntersectionImpl impl = new IntersectionImpl(seedHash);
        int preLongs = 3;
        impl.maxLgArrLongs_ = IntersectionImpl.checkMaxLgArrLongs(dstMem);
        long[] preArr = new long[3];
        long pre0 = 0L;
        pre0 = PreambleUtil.insertPreLongs(3, pre0);
        pre0 = PreambleUtil.insertSerVer(3, pre0);
        pre0 = PreambleUtil.insertFamilyID(Family.INTERSECTION.getID(), pre0);
        impl.lgArrLongs_ = 5;
        pre0 = PreambleUtil.insertLgArrLongs(5, pre0);
        impl.empty_ = false;
        pre0 = PreambleUtil.insertFlags(0, pre0);
        preArr[0] = pre0 = PreambleUtil.insertSeedHash(seedHash, pre0);
        long pre1 = 0L;
        impl.curCount_ = -1;
        pre1 = PreambleUtil.insertCurCount(-1, pre1);
        preArr[1] = pre1 = PreambleUtil.insertP(1.0f, pre1);
        preArr[2] = impl.thetaLong_ = Long.MAX_VALUE;
        dstMem.putLongArray(0L, preArr, 0, 3);
        impl.mem_ = dstMem;
        return impl;
    }

    static IntersectionImpl wrapInstance(Memory srcMem, long seed) {
        int preLongs = 3;
        long[] preArr = new long[3];
        srcMem.getLongArray(0L, preArr, 0, 3);
        long pre0 = preArr[0];
        int preLongsMem = PreambleUtil.extractPreLongs(pre0);
        if (preLongsMem != 3) {
            throw new SketchesArgumentException("PreambleLongs must = 3.");
        }
        int serVer = PreambleUtil.extractSerVer(pre0);
        if (serVer != 3) {
            throw new SketchesArgumentException("Ser Version must = 3");
        }
        int famID = PreambleUtil.extractFamilyID(pre0);
        Family.INTERSECTION.checkFamilyID(famID);
        short seedHash = IntersectionImpl.computeSeedHash(seed);
        short seedHashMem = (short)PreambleUtil.extractSeedHash(pre0);
        Util.checkSeedHashes(seedHashMem, seedHash);
        IntersectionImpl impl = new IntersectionImpl(seedHash);
        impl.lgArrLongs_ = PreambleUtil.extractLgArrLongs(pre0);
        impl.maxLgArrLongs_ = IntersectionImpl.checkMaxLgArrLongs(srcMem);
        int flags = PreambleUtil.extractFlags(pre0);
        impl.empty_ = (flags & 4) > 0;
        impl.curCount_ = PreambleUtil.extractCurCount(preArr[1]);
        impl.thetaLong_ = preArr[2];
        if (impl.empty_ && impl.curCount_ != 0) {
            throw new SketchesArgumentException("srcMem empty state inconsistent with curCount: " + impl.empty_ + "," + impl.curCount_);
        }
        impl.mem_ = srcMem;
        return impl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update(Sketch sketchIn) {
        if (sketchIn == null) {
            this.empty_ = IntersectionImpl.setEmpty(true, this.mem_);
            if (this.curCount_ < 0) {
                this.thetaLong_ = IntersectionImpl.setThetaLong(Long.MAX_VALUE, this.mem_);
            }
            this.curCount_ = IntersectionImpl.setCurCount(0, this.mem_);
            return;
        }
        int sketchInEntries = sketchIn.getRetainedEntries(true);
        Util.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
        this.thetaLong_ = IntersectionImpl.setThetaLong(Math.min(this.thetaLong_, sketchIn.getThetaLong()), this.mem_);
        this.empty_ = IntersectionImpl.setEmpty(this.empty_ || sketchIn.isEmpty(), this.mem_);
        if (this.curCount_ == 0 || sketchInEntries == 0) {
            this.curCount_ = IntersectionImpl.setCurCount(0, this.mem_);
            this.hashTable_ = null;
            return;
        } else if (this.curCount_ < 0) {
            this.curCount_ = IntersectionImpl.setCurCount(sketchIn.getRetainedEntries(true), this.mem_);
            int requiredLgArrLongs = IntersectionImpl.computeMinLgArrLongsFromCount(this.curCount_);
            int priorLgArrLongs = this.lgArrLongs_;
            this.lgArrLongs_ = IntersectionImpl.setLgArrLongs(requiredLgArrLongs, this.mem_);
            if (this.mem_ != null) {
                if (requiredLgArrLongs > this.maxLgArrLongs_) throw new SketchesArgumentException("Insufficient dstMem hash table space: " + (1 << requiredLgArrLongs) + " > " + (1 << priorLgArrLongs));
                this.mem_.clear(24L, (long)(8 << this.lgArrLongs_));
            } else {
                this.hashTable_ = new long[1 << this.lgArrLongs_];
            }
            this.moveDataToTgt(sketchIn.getCache(), this.curCount_);
            return;
        } else {
            this.performIntersect(sketchIn);
        }
    }

    @Override
    public CompactSketch getResult(boolean dstOrdered, Memory dstMem) {
        long[] hashTable;
        if (this.curCount_ < 0) {
            throw new SketchesStateException("Calling getResult() with no intervening intersections is not a legal result.");
        }
        if (this.curCount_ == 0) {
            long[] compactCacheR = new long[]{};
            return CompactSketch.createCompactSketch(compactCacheR, this.empty_, this.seedHash_, this.curCount_, this.thetaLong_, dstOrdered, dstMem);
        }
        if (this.mem_ != null) {
            int htLen = 1 << this.lgArrLongs_;
            hashTable = new long[htLen];
            this.mem_.getLongArray(24L, hashTable, 0, htLen);
        } else {
            hashTable = this.hashTable_;
        }
        long[] compactCacheR = CompactSketch.compactCachePart(hashTable, this.lgArrLongs_, this.curCount_, this.thetaLong_, dstOrdered);
        return CompactSketch.createCompactSketch(compactCacheR, this.empty_, this.seedHash_, this.curCount_, this.thetaLong_, dstOrdered, dstMem);
    }

    @Override
    public CompactSketch getResult() {
        return this.getResult(true, null);
    }

    @Override
    public boolean hasResult() {
        return this.mem_ != null ? this.mem_.getInt(8L) >= 0 : this.curCount_ >= 0;
    }

    @Override
    public byte[] toByteArray() {
        int preBytes = 24;
        int dataBytes = this.curCount_ > 0 ? 8 << this.lgArrLongs_ : 0;
        byte[] byteArrOut = new byte[24 + dataBytes];
        if (this.mem_ != null) {
            this.mem_.getByteArray(0L, byteArrOut, 0, 24 + dataBytes);
        } else {
            NativeMemory memOut = new NativeMemory(byteArrOut);
            memOut.putByte(0L, (byte)3);
            memOut.putByte(1L, (byte)3);
            memOut.putByte(2L, (byte)Family.objectToFamily(this).getID());
            memOut.putByte(3L, (byte)0);
            memOut.putByte(4L, (byte)this.lgArrLongs_);
            if (this.empty_) {
                memOut.setBits(5L, (byte)4);
            } else {
                memOut.clearBits(5L, (byte)4);
            }
            memOut.putShort(6L, this.seedHash_);
            memOut.putInt(8L, this.curCount_);
            memOut.putFloat(12L, 1.0f);
            memOut.putLong(16L, this.thetaLong_);
            if (this.curCount_ > 0) {
                memOut.putLongArray(24L, this.hashTable_, 0, 1 << this.lgArrLongs_);
            }
        }
        return byteArrOut;
    }

    @Override
    public void reset() {
        this.lgArrLongs_ = IntersectionImpl.setLgArrLongs(this.lgArrLongs_, this.mem_);
        this.curCount_ = IntersectionImpl.setCurCount(-1, this.mem_);
        this.thetaLong_ = IntersectionImpl.setThetaLong(Long.MAX_VALUE, this.mem_);
        this.empty_ = IntersectionImpl.setEmpty(false, this.mem_);
        this.hashTable_ = null;
    }

    @Override
    public Family getFamily() {
        return Family.INTERSECTION;
    }

    private void performIntersect(Sketch sketchIn) {
        long[] hashTable;
        assert (this.curCount_ > 0 && !this.empty_);
        long[] cacheIn = sketchIn.getCache();
        int arrLongsIn = cacheIn.length;
        if (this.mem_ != null) {
            int htLen = 1 << this.lgArrLongs_;
            hashTable = new long[htLen];
            this.mem_.getLongArray(24L, hashTable, 0, htLen);
        } else {
            hashTable = this.hashTable_;
        }
        long[] matchSet = new long[Math.min(this.curCount_, sketchIn.getRetainedEntries(true))];
        int matchSetCount = 0;
        if (sketchIn.isOrdered()) {
            long hashIn;
            for (int i = 0; i < arrLongsIn && (hashIn = cacheIn[i]) < this.thetaLong_; ++i) {
                int foundIdx = HashOperations.hashSearch(hashTable, this.lgArrLongs_, hashIn);
                if (foundIdx == -1) continue;
                matchSet[matchSetCount++] = hashIn;
            }
        } else {
            for (int i = 0; i < arrLongsIn; ++i) {
                int foundIdx;
                long hashIn = cacheIn[i];
                if (hashIn <= 0L || hashIn >= this.thetaLong_ || (foundIdx = HashOperations.hashSearch(hashTable, this.lgArrLongs_, hashIn)) == -1) continue;
                matchSet[matchSetCount++] = hashIn;
            }
        }
        this.lgArrLongs_ = IntersectionImpl.setLgArrLongs(IntersectionImpl.computeMinLgArrLongsFromCount(this.curCount_), this.mem_);
        this.curCount_ = IntersectionImpl.setCurCount(matchSetCount, this.mem_);
        if (this.mem_ != null) {
            this.mem_.clear(24L, (long)(8 << this.lgArrLongs_));
        } else {
            Arrays.fill(this.hashTable_, 0, 1 << this.lgArrLongs_, 0L);
        }
        this.moveDataToTgt(matchSet, matchSetCount);
    }

    private void moveDataToTgt(long[] arr, int count) {
        int arrLongsIn = arr.length;
        int tmpCnt = 0;
        if (this.mem_ != null) {
            int preBytes = 24;
            for (int i = 0; i < arrLongsIn; ++i) {
                long hashIn = arr[i];
                if (HashOperations.continueCondition(this.thetaLong_, hashIn)) continue;
                HashOperations.hashInsertOnly(this.mem_, this.lgArrLongs_, hashIn, 24);
                ++tmpCnt;
            }
        } else {
            for (int i = 0; i < arrLongsIn; ++i) {
                long hashIn = arr[i];
                if (HashOperations.continueCondition(this.thetaLong_, hashIn)) continue;
                HashOperations.hashInsertOnly(this.hashTable_, this.lgArrLongs_, hashIn);
                ++tmpCnt;
            }
        }
        assert (tmpCnt == count) : "Intersection Count Check: got: " + tmpCnt + ", expected: " + count;
    }

    private static final int checkMaxLgArrLongs(Memory dstMem) {
        int preBytes = 24;
        long cap = dstMem.getCapacity();
        int maxLgArrLongs = Integer.numberOfTrailingZeros(Util.floorPowerOf2((int)(cap - 24L)) >>> 3);
        if (maxLgArrLongs < 5) {
            throw new SketchesArgumentException("dstMem not large enough for minimum sized hash table: " + cap);
        }
        return maxLgArrLongs;
    }

    private static final boolean setEmpty(boolean empty, Memory mem) {
        if (mem != null) {
            if (empty) {
                mem.setBits(5L, (byte)4);
            } else {
                mem.clearBits(5L, (byte)4);
            }
        }
        return empty;
    }

    private static final int setLgArrLongs(int lgArrLongs, Memory mem) {
        if (mem != null) {
            mem.putByte(4L, (byte)lgArrLongs);
        }
        return lgArrLongs;
    }

    private static final long setThetaLong(long thetaLong, Memory mem) {
        if (mem != null) {
            mem.putLong(16L, thetaLong);
        }
        return thetaLong;
    }

    private static final int setCurCount(int curCount, Memory mem) {
        if (mem != null) {
            mem.putInt(8L, curCount);
        }
        return curCount;
    }
}

