/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema.validator;

import org.apache.pulsar.broker.service.schema.KeyValueSchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.exceptions.InvalidSchemaDataException;
import org.apache.pulsar.broker.service.schema.validator.PrimitiveSchemaDataValidator;
import org.apache.pulsar.broker.service.schema.validator.ProtobufNativeSchemaDataValidator;
import org.apache.pulsar.broker.service.schema.validator.StringSchemaDataValidator;
import org.apache.pulsar.broker.service.schema.validator.StructSchemaDataValidator;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.schema.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SchemaDataValidator {
    public static final Logger LOGGER = LoggerFactory.getLogger(SchemaDataValidator.class);

    public static void validateSchemaData(SchemaData schemaData) throws InvalidSchemaDataException {
        switch (schemaData.getType()) {
            case AVRO: 
            case JSON: 
            case PROTOBUF: {
                StructSchemaDataValidator.of().validate(schemaData);
                break;
            }
            case PROTOBUF_NATIVE: {
                ProtobufNativeSchemaDataValidator.of().validate(schemaData);
                break;
            }
            case STRING: {
                StringSchemaDataValidator.of().validate(schemaData);
                break;
            }
            case BOOLEAN: 
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case INSTANT: 
            case LOCAL_DATE: 
            case LOCAL_TIME: 
            case LOCAL_DATE_TIME: {
                PrimitiveSchemaDataValidator.of().validate(schemaData);
                break;
            }
            case NONE: 
            case BYTES: {
                break;
            }
            case AUTO: 
            case AUTO_CONSUME: 
            case AUTO_PUBLISH: {
                throw new InvalidSchemaDataException("Schema " + String.valueOf(schemaData.getType()) + " is a client-side schema type");
            }
            case KEY_VALUE: {
                KeyValue<SchemaData, SchemaData> kvSchema = KeyValueSchemaCompatibilityCheck.decodeKeyValueSchemaData(schemaData);
                SchemaDataValidator.validateSchemaData((SchemaData)kvSchema.getKey());
                SchemaDataValidator.validateSchemaData((SchemaData)kvSchema.getValue());
                break;
            }
            default: {
                throw new InvalidSchemaDataException("Unknown schema type : " + String.valueOf(schemaData.getType()));
            }
        }
    }

    public void validate(SchemaData var1) throws InvalidSchemaDataException;
}

