/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Parameter
extends Expression {
    private final int position;

    public Parameter(int id) {
        this(Optional.empty(), id);
    }

    public Parameter(NodeLocation location, int id) {
        this(Optional.of(location), id);
    }

    private Parameter(Optional<NodeLocation> location, int position) {
        super(location);
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitParameter(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter that = (Parameter)o;
        return Objects.equals(this.position, that.position);
    }

    @Override
    public int hashCode() {
        return this.position;
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Parameter.sameClass(this, other)) {
            return false;
        }
        return this.position == ((Parameter)other).position;
    }
}

