/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorStats;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStore;
import org.apache.pulsar.transaction.coordinator.TransactionSubscription;
import org.apache.pulsar.transaction.coordinator.TxnMeta;
import org.apache.pulsar.transaction.coordinator.exceptions.CoordinatorException;
import org.apache.pulsar.transaction.coordinator.impl.TransactionMetadataStoreStats;
import org.apache.pulsar.transaction.coordinator.impl.TxnMetaImpl;
import org.apache.pulsar.transaction.coordinator.proto.TxnStatus;

class InMemTransactionMetadataStore
implements TransactionMetadataStore {
    private final TransactionCoordinatorID tcID;
    private final AtomicLong localID;
    private final ConcurrentMap<TxnID, TxnMetaImpl> transactions;
    private final TransactionMetadataStoreStats transactionMetadataStoreStats;
    private final LongAdder createTransactionCount;
    private final LongAdder commitTransactionCount;
    private final LongAdder abortTransactionCount;
    private final LongAdder transactionTimeoutCount;

    InMemTransactionMetadataStore(TransactionCoordinatorID tcID) {
        this.tcID = tcID;
        this.localID = new AtomicLong(0L);
        this.transactions = new ConcurrentHashMap<TxnID, TxnMetaImpl>();
        this.transactionMetadataStoreStats = new TransactionMetadataStoreStats();
        this.createTransactionCount = new LongAdder();
        this.commitTransactionCount = new LongAdder();
        this.abortTransactionCount = new LongAdder();
        this.transactionTimeoutCount = new LongAdder();
    }

    @Override
    public CompletableFuture<TxnMeta> getTxnMeta(TxnID txnid) {
        CompletableFuture<TxnMeta> getFuture = new CompletableFuture<TxnMeta>();
        TxnMetaImpl txn = (TxnMetaImpl)this.transactions.get(txnid);
        if (null == txn) {
            getFuture.completeExceptionally(new CoordinatorException.TransactionNotFoundException(txnid));
        } else {
            getFuture.complete(txn);
        }
        return getFuture;
    }

    @Override
    public CompletableFuture<TxnID> newTransaction(long timeoutInMills, String owner) {
        if (owner != null && StringUtils.isBlank((CharSequence)owner)) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Owner can't be blank"));
        }
        TxnID txnID = new TxnID(this.tcID.getId(), this.localID.getAndIncrement());
        TxnMetaImpl txn = new TxnMetaImpl(txnID, System.currentTimeMillis(), timeoutInMills, owner);
        this.transactions.put(txnID, txn);
        return CompletableFuture.completedFuture(txnID);
    }

    @Override
    public CompletableFuture<Void> addProducedPartitionToTxn(TxnID txnid, List<String> partitions) {
        return this.getTxnMeta(txnid).thenCompose(txn -> {
            try {
                txn.addProducedPartitions(partitions);
                return CompletableFuture.completedFuture(null);
            }
            catch (CoordinatorException.InvalidTxnStatusException e) {
                CompletableFuture error = new CompletableFuture();
                error.completeExceptionally(e);
                return error;
            }
        });
    }

    @Override
    public CompletableFuture<Void> addAckedPartitionToTxn(TxnID txnid, List<TransactionSubscription> partitions) {
        return this.getTxnMeta(txnid).thenCompose(txn -> {
            try {
                txn.addAckedPartitions(partitions);
                return CompletableFuture.completedFuture(null);
            }
            catch (CoordinatorException.InvalidTxnStatusException e) {
                CompletableFuture error = new CompletableFuture();
                error.completeExceptionally(e);
                return error;
            }
        });
    }

    @Override
    public CompletableFuture<Void> updateTxnStatus(TxnID txnid, TxnStatus newStatus, TxnStatus expectedStatus, boolean isTimeout) {
        return this.getTxnMeta(txnid).thenCompose(txn -> {
            try {
                txn.updateTxnStatus(newStatus, expectedStatus);
                if (isTimeout && expectedStatus == TxnStatus.ABORTING) {
                    this.transactionTimeoutCount.increment();
                }
                return CompletableFuture.completedFuture(null);
            }
            catch (CoordinatorException.InvalidTxnStatusException e) {
                CompletableFuture error = new CompletableFuture();
                error.completeExceptionally(e);
                return error;
            }
        });
    }

    @Override
    public TransactionCoordinatorID getTransactionCoordinatorID() {
        return this.tcID;
    }

    @Override
    public TransactionCoordinatorStats getCoordinatorStats() {
        return null;
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        this.transactions.clear();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public TransactionMetadataStoreStats getMetadataStoreStats() {
        this.transactionMetadataStoreStats.setActives(this.transactions.size());
        this.transactionMetadataStoreStats.setCoordinatorId(this.tcID.getId());
        this.transactionMetadataStoreStats.setCreatedCount(this.createTransactionCount.longValue());
        this.transactionMetadataStoreStats.setCommittedCount(this.commitTransactionCount.longValue());
        this.transactionMetadataStoreStats.setAbortedCount(this.abortTransactionCount.longValue());
        return this.transactionMetadataStoreStats;
    }

    @Override
    public List<TxnMeta> getSlowTransactions(long timeout) {
        return null;
    }
}

