/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spiller;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.trino.ExceededSpillLimitException;
import io.trino.operator.Operator;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;

@ThreadSafe
public class SpillSpaceTracker {
    private final long maxBytes;
    @GuardedBy(value="this")
    private long currentBytes;

    public SpillSpaceTracker(DataSize maxSize) {
        Objects.requireNonNull(maxSize, "maxSize is null");
        this.maxBytes = maxSize.toBytes();
        this.currentBytes = 0L;
    }

    public synchronized ListenableFuture<Void> reserve(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        if (this.currentBytes + bytes >= this.maxBytes) {
            throw ExceededSpillLimitException.exceededLocalLimit(DataSize.succinctBytes((long)this.maxBytes));
        }
        this.currentBytes += bytes;
        return Operator.NOT_BLOCKED;
    }

    public synchronized void free(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        Preconditions.checkArgument((this.currentBytes - bytes >= 0L ? 1 : 0) != 0, (Object)"tried to free more disk space than is reserved");
        this.currentBytes -= bytes;
    }

    @Managed
    public synchronized long getCurrentBytes() {
        return this.currentBytes;
    }

    @Managed
    public synchronized long getMaxBytes() {
        return this.maxBytes;
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("maxBytes", this.maxBytes).add("currentBytes", this.currentBytes).toString();
    }
}

