/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.net.MediaType;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.JsonBodyGenerator;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.memory.MemoryInfo;
import io.trino.memory.MemoryPoolAssignmentsRequest;
import io.trino.metadata.InternalNode;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RemoteNodeMemory {
    private static final Logger log = Logger.get(RemoteNodeMemory.class);
    private final InternalNode node;
    private final HttpClient httpClient;
    private final URI memoryInfoUri;
    private final JsonCodec<MemoryInfo> memoryInfoCodec;
    private final JsonCodec<MemoryPoolAssignmentsRequest> assignmentsRequestJsonCodec;
    private final AtomicReference<Optional<MemoryInfo>> memoryInfo = new AtomicReference(Optional.empty());
    private final AtomicReference<Future<?>> future = new AtomicReference();
    private final AtomicLong lastUpdateNanos = new AtomicLong();
    private final AtomicLong lastWarningLogged = new AtomicLong();
    private final AtomicLong currentAssignmentVersion = new AtomicLong(-1L);

    public RemoteNodeMemory(InternalNode node, HttpClient httpClient, JsonCodec<MemoryInfo> memoryInfoCodec, JsonCodec<MemoryPoolAssignmentsRequest> assignmentsRequestJsonCodec, URI memoryInfoUri) {
        this.node = Objects.requireNonNull(node, "node is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.memoryInfoUri = Objects.requireNonNull(memoryInfoUri, "memoryInfoUri is null");
        this.memoryInfoCodec = Objects.requireNonNull(memoryInfoCodec, "memoryInfoCodec is null");
        this.assignmentsRequestJsonCodec = Objects.requireNonNull(assignmentsRequestJsonCodec, "assignmentsRequestJsonCodec is null");
    }

    public long getCurrentAssignmentVersion() {
        return this.currentAssignmentVersion.get();
    }

    public Optional<MemoryInfo> getInfo() {
        return this.memoryInfo.get();
    }

    public InternalNode getNode() {
        return this.node;
    }

    public void asyncRefresh(final MemoryPoolAssignmentsRequest assignments) {
        Duration sinceUpdate = Duration.nanosSince((long)this.lastUpdateNanos.get());
        if (Duration.nanosSince((long)this.lastWarningLogged.get()).toMillis() > 1000L && sinceUpdate.toMillis() > 10000L && this.future.get() != null) {
            log.warn("Memory info update request to %s has not returned in %s", new Object[]{this.memoryInfoUri, sinceUpdate.toString(TimeUnit.SECONDS)});
            this.lastWarningLogged.set(System.nanoTime());
        }
        if (sinceUpdate.toMillis() > 1000L && this.future.get() == null) {
            Request request = Request.Builder.preparePost().setUri(this.memoryInfoUri).setHeader("Content-Type", MediaType.JSON_UTF_8.toString()).setBodyGenerator((BodyGenerator)JsonBodyGenerator.jsonBodyGenerator(this.assignmentsRequestJsonCodec, (Object)assignments)).build();
            final HttpClient.HttpResponseFuture responseFuture = this.httpClient.executeAsync(request, (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(this.memoryInfoCodec));
            this.future.compareAndSet((Future<?>)null, (Future<?>)responseFuture);
            Futures.addCallback((ListenableFuture)responseFuture, (FutureCallback)new FutureCallback<FullJsonResponseHandler.JsonResponse<MemoryInfo>>(){

                public void onSuccess(@Nullable FullJsonResponseHandler.JsonResponse<MemoryInfo> result) {
                    RemoteNodeMemory.this.lastUpdateNanos.set(System.nanoTime());
                    RemoteNodeMemory.this.future.compareAndSet((Future<?>)responseFuture, (Future<?>)null);
                    long version = RemoteNodeMemory.this.currentAssignmentVersion.get();
                    if (result != null) {
                        if (result.hasValue()) {
                            RemoteNodeMemory.this.memoryInfo.set(Optional.ofNullable((MemoryInfo)result.getValue()));
                        }
                        if (result.getStatusCode() != HttpStatus.OK.code()) {
                            log.warn("Error fetching memory info from %s returned status %d", new Object[]{RemoteNodeMemory.this.memoryInfoUri, result.getStatusCode()});
                            return;
                        }
                    }
                    RemoteNodeMemory.this.currentAssignmentVersion.compareAndSet(version, assignments.getVersion());
                }

                public void onFailure(Throwable t) {
                    log.warn("Error fetching memory info from %s: %s", new Object[]{RemoteNodeMemory.this.memoryInfoUri, t.getMessage()});
                    RemoteNodeMemory.this.lastUpdateNanos.set(System.nanoTime());
                    RemoteNodeMemory.this.future.compareAndSet((Future<?>)responseFuture, (Future<?>)null);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }
}

