/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.Session;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SimpleStatsRule;
import io.trino.cost.StatsNormalizer;
import io.trino.cost.StatsProvider;
import io.trino.matching.Pattern;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;
import java.util.Optional;

public class LimitStatsRule
extends SimpleStatsRule<LimitNode> {
    private static final Pattern<LimitNode> PATTERN = Patterns.limit();

    public LimitStatsRule(StatsNormalizer normalizer) {
        super(normalizer);
    }

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(LimitNode node, StatsProvider statsProvider, Lookup lookup, Session session, TypeProvider types) {
        PlanNodeStatsEstimate sourceStats = statsProvider.getStats(node.getSource());
        if (sourceStats.getOutputRowCount() <= (double)node.getCount()) {
            return Optional.of(sourceStats);
        }
        return Optional.of(PlanNodeStatsEstimate.buildFrom(sourceStats).setOutputRowCount(node.getCount()).build());
    }
}

