/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Suppliers;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.transaction.TransactionId;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class SystemTransactionHandle
implements ConnectorTransactionHandle {
    private final TransactionId transactionId;
    private final Supplier<ConnectorTransactionHandle> connectorTransactionHandle;

    SystemTransactionHandle(TransactionId transactionId, Function<TransactionId, ConnectorTransactionHandle> transactionHandleFunction) {
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        Objects.requireNonNull(transactionHandleFunction, "transactionHandleFunction is null");
        this.connectorTransactionHandle = Suppliers.memoize(() -> (ConnectorTransactionHandle)transactionHandleFunction.apply(transactionId));
    }

    @JsonCreator
    public SystemTransactionHandle(@JsonProperty(value="transactionId") TransactionId transactionId, @JsonProperty(value="connectorTransactionHandle") ConnectorTransactionHandle connectorTransactionHandle) {
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        Objects.requireNonNull(connectorTransactionHandle, "connectorTransactionHandle is null");
        this.connectorTransactionHandle = () -> connectorTransactionHandle;
    }

    @JsonProperty
    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty
    public ConnectorTransactionHandle getConnectorTransactionHandle() {
        return this.connectorTransactionHandle.get();
    }

    public int hashCode() {
        return this.transactionId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SystemTransactionHandle other = (SystemTransactionHandle)obj;
        return this.transactionId.equals(other.transactionId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("transactionHandle", (Object)this.transactionId).toString();
    }
}

