/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.trino.connector.system.SystemColumnHandle;
import io.trino.connector.system.SystemTableHandle;
import io.trino.connector.system.SystemTablesProvider;
import io.trino.connector.system.jdbc.JdbcTable;
import io.trino.metadata.MetadataUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class SystemTablesMetadata
implements ConnectorMetadata {
    private final SystemTablesProvider tables;

    public SystemTablesMetadata(SystemTablesProvider tables) {
        this.tables = Objects.requireNonNull(tables, "tables is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return (List)this.tables.listSystemTables(session).stream().map(table -> table.getTableMetadata().getTable().getSchemaName()).distinct().collect(ImmutableList.toImmutableList());
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Optional<SystemTable> table = this.tables.getSystemTable(session, tableName);
        if (table.isEmpty()) {
            return null;
        }
        return SystemTableHandle.fromSchemaTableName(tableName);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.checkAndGetTable(session, tableHandle).getTableMetadata();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return (List)this.tables.listSystemTables(session).stream().map(SystemTable::getTableMetadata).map(ConnectorTableMetadata::getTable).filter(table -> schemaName.isEmpty() || table.getSchemaName().equals(schemaName.get())).collect(ImmutableList.toImmutableList());
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        String columnName;
        ConnectorTableMetadata tableMetadata = this.checkAndGetTable(session, tableHandle).getTableMetadata();
        ColumnMetadata columnMetadata = MetadataUtil.findColumnMetadata(tableMetadata, columnName = ((SystemColumnHandle)columnHandle).getColumnName());
        Preconditions.checkArgument((columnMetadata != null ? 1 : 0) != 0, (String)"Column '%s' on table '%s' does not exist", (Object)columnName, (Object)tableMetadata.getTable());
        return columnMetadata;
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        ConnectorTableMetadata tableMetadata = this.checkAndGetTable(session, tableHandle).getTableMetadata();
        return SystemColumnHandle.toSystemColumnHandles(tableMetadata);
    }

    private SystemTable checkAndGetTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SystemTableHandle systemTableHandle = (SystemTableHandle)tableHandle;
        return this.tables.getSystemTable(session, systemTableHandle.getSchemaTableName()).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Table '%s' not found", systemTableHandle.getSchemaTableName())));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        if (prefix.getTable().isPresent()) {
            SchemaTableName tableName = prefix.toSchemaTableName();
            return this.tables.getSystemTable(session, tableName).map(systemTable -> Collections.singletonMap(tableName, systemTable.getTableMetadata().getColumns())).orElseGet(ImmutableMap::of);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SystemTable table : this.tables.listSystemTables(session)) {
            ConnectorTableMetadata tableMetadata = table.getTableMetadata();
            if (!prefix.matches(tableMetadata.getTable())) continue;
            builder.put((Object)tableMetadata.getTable(), (Object)tableMetadata.getColumns());
        }
        return builder.build();
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        return new ConnectorTableProperties();
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
        TupleDomain newDomain;
        SystemTableHandle table = (SystemTableHandle)handle;
        TupleDomain<ColumnHandle> oldDomain = table.getConstraint();
        if (oldDomain.equals((Object)(newDomain = oldDomain.intersect(constraint.getSummary()))) && constraint.predicate().isEmpty()) {
            return Optional.empty();
        }
        SystemTable systemTable = this.checkAndGetTable(session, table);
        if (systemTable instanceof JdbcTable) {
            TupleDomain<ColumnHandle> filtered = ((JdbcTable)systemTable).applyFilter(session, this.effectiveConstraint(oldDomain, constraint, (TupleDomain<ColumnHandle>)newDomain));
            newDomain = newDomain.intersect(filtered);
        }
        if (oldDomain.equals((Object)newDomain)) {
            return Optional.empty();
        }
        if (newDomain.isNone()) {
            // empty if block
        }
        table = new SystemTableHandle(table.getSchemaName(), table.getTableName(), (TupleDomain<ColumnHandle>)newDomain);
        return Optional.of(new ConstraintApplicationResult((Object)table, constraint.getSummary(), false));
    }

    private Constraint effectiveConstraint(TupleDomain<ColumnHandle> oldDomain, Constraint newConstraint, TupleDomain<ColumnHandle> effectiveDomain) {
        if (effectiveDomain.isNone() || newConstraint.predicate().isEmpty()) {
            return new Constraint(effectiveDomain);
        }
        return new Constraint(effectiveDomain, oldDomain.asPredicate().and((Predicate)newConstraint.predicate().get()), (Set)Sets.union(((Map)oldDomain.getDomains().orElseThrow()).keySet(), (Set)((Set)newConstraint.getPredicateColumns().orElseThrow())));
    }
}

