/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.selector;

import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.selector.FirstDLSNNotLessThanSelector;
import org.apache.distributedlog.selector.FirstRecordSelector;
import org.apache.distributedlog.selector.FirstTxIdNotLessThanSelector;
import org.apache.distributedlog.selector.LastRecordSelector;
import org.junit.Assert;
import org.junit.Test;

public class TestLogRecordSelectors {
    @Test(timeout=60000L)
    public void testFirstRecordSelector() {
        FirstRecordSelector selectorIncludeControlRecord = new FirstRecordSelector(true);
        for (int i = 0; i < 5; ++i) {
            selectorIncludeControlRecord.process(DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(1L, (long)(i * 2), 0L), i * 2, true));
            selectorIncludeControlRecord.process(DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(1L, (long)(i * 2 + 1), 0L), i * 2 + 1));
        }
        Assert.assertEquals((Object)new DLSN(1L, 0L, 0L), (Object)selectorIncludeControlRecord.result().getDlsn());
        FirstRecordSelector selectorExcludeControlRecord = new FirstRecordSelector(false);
        for (int i = 0; i < 5; ++i) {
            selectorExcludeControlRecord.process(DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(1L, (long)(i * 2), 0L), i * 2, true));
            selectorExcludeControlRecord.process(DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(1L, (long)(i * 2 + 1), 0L), i * 2 + 1));
        }
        Assert.assertEquals((Object)new DLSN(1L, 1L, 0L), (Object)selectorExcludeControlRecord.result().getDlsn());
    }

    @Test(timeout=60000L)
    public void testLastRecordSelector() {
        LastRecordSelector selector = new LastRecordSelector();
        for (int i = 0; i < 10; ++i) {
            selector.process(DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(1L, (long)i, 0L), i));
        }
        Assert.assertEquals((Object)new DLSN(1L, 9L, 0L), (Object)selector.result().getDlsn());
    }

    @Test(timeout=60000L)
    public void testFirstDLSNNotLessThanSelector() {
        DLSN dlsn = new DLSN(5L, 5L, 0L);
        FirstDLSNNotLessThanSelector largerSelector = new FirstDLSNNotLessThanSelector(dlsn);
        for (int i = 0; i < 10; ++i) {
            largerSelector.process(DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(4L, (long)i, 0L), i));
        }
        Assert.assertNull((Object)largerSelector.result());
        FirstDLSNNotLessThanSelector smallerSelector = new FirstDLSNNotLessThanSelector(dlsn);
        for (int i = 0; i < 10; ++i) {
            smallerSelector.process(DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(6L, (long)i, 0L), i));
        }
        Assert.assertEquals((Object)new DLSN(6L, 0L, 0L), (Object)smallerSelector.result().getDlsn());
        FirstDLSNNotLessThanSelector selector = new FirstDLSNNotLessThanSelector(dlsn);
        for (int i = 0; i < 10; ++i) {
            selector.process(DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(5L, (long)i, 0L), i));
        }
        Assert.assertEquals((Object)dlsn, (Object)selector.result().getDlsn());
    }

    @Test(timeout=60000L)
    public void testFirstTxIdNotLessThanSelector() {
        long txId = 55L;
        FirstTxIdNotLessThanSelector largerSelector = new FirstTxIdNotLessThanSelector(txId);
        for (int i = 0; i < 10; ++i) {
            largerSelector.process(DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(4L, (long)i, 0L), 40 + i));
        }
        Assert.assertEquals((long)49L, (long)largerSelector.result().getTransactionId());
        FirstTxIdNotLessThanSelector smallerSelector = new FirstTxIdNotLessThanSelector(txId);
        for (int i = 0; i < 10; ++i) {
            smallerSelector.process(DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(6L, (long)i, 0L), 60 + i));
        }
        Assert.assertEquals((long)60L, (long)smallerSelector.result().getTransactionId());
        FirstTxIdNotLessThanSelector selector = new FirstTxIdNotLessThanSelector(txId);
        for (int i = 0; i < 10; ++i) {
            selector.process(DLMTestUtil.getLogRecordWithDLSNInstance(new DLSN(5L, (long)i, 0L), 50 + i));
        }
        Assert.assertEquals((long)txId, (long)selector.result().getTransactionId());
    }
}

