/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.AnnotationDefinition;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.ParameterizedType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;

@Immutable
public class FieldDefinition {
    private final ClassDefinition declaringClass;
    private final ImmutableSet<Access> access;
    private final String name;
    private final ParameterizedType type;
    private final List<AnnotationDefinition> annotations = new ArrayList<AnnotationDefinition>();

    public FieldDefinition(ClassDefinition declaringClass, EnumSet<Access> access, String name, ParameterizedType type) {
        this.declaringClass = declaringClass;
        this.access = Sets.immutableEnumSet(access);
        this.name = name;
        this.type = type;
    }

    public FieldDefinition(ClassDefinition declaringClass, EnumSet<Access> access, String name, Class<?> type) {
        this(declaringClass, access, name, ParameterizedType.type(type));
    }

    public ClassDefinition getDeclaringClass() {
        return this.declaringClass;
    }

    public ImmutableSet<Access> getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public ParameterizedType getType() {
        return this.type;
    }

    public List<AnnotationDefinition> getAnnotations() {
        return ImmutableList.copyOf(this.annotations);
    }

    public AnnotationDefinition declareAnnotation(Class<?> type) {
        AnnotationDefinition annotationDefinition = new AnnotationDefinition(type);
        this.annotations.add(annotationDefinition);
        return annotationDefinition;
    }

    public AnnotationDefinition declareAnnotation(ParameterizedType type) {
        AnnotationDefinition annotationDefinition = new AnnotationDefinition(type);
        this.annotations.add(annotationDefinition);
        return annotationDefinition;
    }

    public void visit(ClassVisitor visitor) {
        FieldVisitor fieldVisitor = visitor.visitField(Access.toAccessModifier(this.access), this.name, this.type.getType(), this.type.getGenericSignature(), null);
        if (fieldVisitor == null) {
            return;
        }
        for (AnnotationDefinition annotation : this.annotations) {
            annotation.visitFieldAnnotation(fieldVisitor);
        }
        fieldVisitor.visitEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FieldDefinition");
        sb.append("{access=").append(this.access);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }
}

