/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;

public class PulsarTopicDescription {
    private final String tableName;
    private final String topicName;
    private final String schemaName;

    @JsonCreator
    public PulsarTopicDescription(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="topicName") String topicName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableName) ? 1 : 0) != 0, (Object)"tableName is null or is empty");
        this.tableName = tableName;
        this.topicName = Objects.requireNonNull(topicName, "topicName is null");
        this.schemaName = schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getTopicName() {
        return this.topicName;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("topicName", (Object)this.topicName).add("schemaName", (Object)this.schemaName).toString();
    }
}

