/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import javax.naming.AuthenticationException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationFilter.class);
    private final AuthenticationService authenticationService;
    public static final String AuthenticatedRoleAttributeName = AuthenticationFilter.class.getName() + "-role";
    public static final String AuthenticatedDataAttributeName = AuthenticationFilter.class.getName() + "-data";
    public static final String PULSAR_AUTH_METHOD_NAME = "X-Pulsar-Auth-Method-Name";

    public AuthenticationFilter(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean allowed = false;
        Exception authenticationException = null;
        try {
            allowed = this.authenticationService.authenticateHttpRequest((HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (Exception e) {
            authenticationException = e;
        }
        if (allowed) {
            chain.doFilter(request, response);
            return;
        }
        if (authenticationException != null) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            if (authenticationException instanceof AuthenticationException) {
                String msg = authenticationException.getMessage();
                if (msg == null) {
                    msg = "Authentication required";
                }
                httpResponse.sendError(401, msg);
                LOG.warn("[{}] Failed to authenticate HTTP request: {}", (Object)request.getRemoteAddr(), (Object)msg);
            } else {
                httpResponse.sendError(401, "Authentication required");
                LOG.error("[{}] Error performing authentication for HTTP", (Object)request.getRemoteAddr(), (Object)authenticationException);
            }
        }
    }

    public void init(FilterConfig arg) throws ServletException {
    }

    public void destroy() {
    }
}

