/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.server.service;

import java.io.IOException;
import java.net.URI;
import java.util.function.Supplier;
import org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.bookkeeper.common.conf.ComponentConfiguration;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stream.server.conf.DLConfiguration;
import org.apache.bookkeeper.stream.storage.StorageConstants;
import org.apache.commons.configuration.Configuration;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.config.DynamicDistributedLogConfiguration;
import org.apache.distributedlog.exceptions.ZKException;
import org.apache.distributedlog.impl.metadata.BKDLConfig;
import org.apache.distributedlog.metadata.DLMetadata;
import org.apache.distributedlog.util.ConfUtils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLNamespaceProviderService
extends AbstractLifecycleComponent<DLConfiguration>
implements Supplier<Namespace> {
    private static final Logger log = LoggerFactory.getLogger(DLNamespaceProviderService.class);
    private final ServerConfiguration bkServerConf;
    private final DistributedLogConfiguration dlConf;
    private final DynamicDistributedLogConfiguration dlDynConf;
    private final URI dlogUri;
    private Namespace namespace;

    private static URI initializeNamespace(ServerConfiguration bkServerConf, URI dlogUri) throws IOException {
        BKDLConfig dlConfig = new BKDLConfig(ZKMetadataDriverBase.resolveZkServers((AbstractConfiguration)bkServerConf), ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)bkServerConf));
        DLMetadata dlMetadata = DLMetadata.create((BKDLConfig)dlConfig);
        try {
            log.info("Initializing dlog namespace at {}", (Object)dlogUri);
            dlMetadata.create(dlogUri);
            log.info("Initialized dlog namespace at {}", (Object)dlogUri);
        }
        catch (ZKException e) {
            if (e.getKeeperExceptionCode() == KeeperException.Code.NODEEXISTS) {
                if (log.isDebugEnabled()) {
                    log.debug("Dlog uri is already bound at {}", (Object)dlogUri);
                }
                return dlogUri;
            }
            log.error("Failed to initialize dlog namespace at {}", (Object)dlogUri, (Object)e);
            throw e;
        }
        return dlogUri;
    }

    public DLNamespaceProviderService(ServerConfiguration bkServerConf, DLConfiguration conf, StatsLogger statsLogger) {
        super("namespace-provider", (ComponentConfiguration)conf, statsLogger);
        this.dlogUri = URI.create(String.format("distributedlog://%s%s", ZKMetadataDriverBase.resolveZkServers((AbstractConfiguration)bkServerConf), StorageConstants.getStoragePath((String)"/stream")));
        this.bkServerConf = bkServerConf;
        this.dlConf = new DistributedLogConfiguration();
        this.dlConf.loadConf((Configuration)conf);
        this.dlConf.setWriteLockEnabled(false);
        this.dlConf.setImmediateFlushEnabled(false);
        this.dlConf.setOutputBufferSize(524288);
        this.dlConf.setPeriodicFlushFrequencyMilliSeconds(2);
        this.dlConf.setExplicitTruncationByApplication(true);
        this.dlConf.setLogSegmentRollingConcurrency(1);
        this.dlConf.setMaxLogSegmentBytes(0x10000000L);
        this.dlDynConf = ConfUtils.getConstDynConf((DistributedLogConfiguration)this.dlConf);
    }

    @Override
    public Namespace get() {
        return this.namespace;
    }

    protected void doStart() {
        URI uri;
        try {
            uri = DLNamespaceProviderService.initializeNamespace(this.bkServerConf, this.dlogUri);
            this.namespace = NamespaceBuilder.newBuilder().statsLogger(this.getStatsLogger()).clientId("storage-server").conf(this.dlConf).dynConf(this.dlDynConf).uri(uri).build();
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to build the distributedlog namespace at " + this.bkServerConf.getMetadataServiceUriUnchecked(), e);
        }
        log.info("Provided distributedlog namespace at {}.", (Object)uri);
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
        if (null != this.namespace) {
            this.namespace.close();
        }
    }

    public DistributedLogConfiguration getDlConf() {
        return this.dlConf;
    }

    public URI getDlogUri() {
        return this.dlogUri;
    }
}

