/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *******************************************************************************/


package org.apache.ofbiz.common;

import java.util.HashMap;
import java.util.Map;


public final class JsLanguageFilesMapping {

    // DO NOT EDIT THIS FILE!  THIS IS AUTO GENERATED AND WILL GET WRITTEN OVER PERIODICALLY WHEN THE DATA CHANGE
    // Rather use the createJsLanguageFileMapping service to create or update it. You will still need to compile thereafter

    public static class DateJs {

        private static Map<String, String> localeFiles = new HashMap<>();
        private static String defaultDateJs = "/common/js/jquery/plugins/datejs/date-en-US.js";

        static {
            localeFiles.put("sq", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("sq_AL", "/common/js/jquery/plugins/datejs/date-sq-AL.js");
            localeFiles.put("ar", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("ar_DZ", "/common/js/jquery/plugins/datejs/date-ar-DZ.js");
            localeFiles.put("ar_BH", "/common/js/jquery/plugins/datejs/date-ar-BH.js");
            localeFiles.put("ar_EG", "/common/js/jquery/plugins/datejs/date-ar-EG.js");
            localeFiles.put("ar_IQ", "/common/js/jquery/plugins/datejs/date-ar-IQ.js");
            localeFiles.put("ar_JO", "/common/js/jquery/plugins/datejs/date-ar-JO.js");
            localeFiles.put("ar_KW", "/common/js/jquery/plugins/datejs/date-ar-KW.js");
            localeFiles.put("ar_LB", "/common/js/jquery/plugins/datejs/date-ar-LB.js");
            localeFiles.put("ar_LY", "/common/js/jquery/plugins/datejs/date-ar-LY.js");
            localeFiles.put("ar_MA", "/common/js/jquery/plugins/datejs/date-ar-MA.js");
            localeFiles.put("ar_OM", "/common/js/jquery/plugins/datejs/date-ar-OM.js");
            localeFiles.put("ar_QA", "/common/js/jquery/plugins/datejs/date-ar-QA.js");
            localeFiles.put("ar_SA", "/common/js/jquery/plugins/datejs/date-ar-SA.js");
            localeFiles.put("ar_SD", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("ar_SY", "/common/js/jquery/plugins/datejs/date-ar-SY.js");
            localeFiles.put("ar_TN", "/common/js/jquery/plugins/datejs/date-ar-TN.js");
            localeFiles.put("ar_AE", "/common/js/jquery/plugins/datejs/date-ar-AE.js");
            localeFiles.put("ar_YE", "/common/js/jquery/plugins/datejs/date-ar-YE.js");
            localeFiles.put("be", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("be_BY", "/common/js/jquery/plugins/datejs/date-be-BY.js");
            localeFiles.put("bg", "/common/js/jquery/plugins/datejs/date-bg-BG.js");
            localeFiles.put("bg_BG", "/common/js/jquery/plugins/datejs/date-bg-BG.js");
            localeFiles.put("ca", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("ca_ES", "/common/js/jquery/plugins/datejs/date-ca-ES.js");
            localeFiles.put("zh", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("zh_CN", "/common/js/jquery/plugins/datejs/date-zh-CN.js");
            localeFiles.put("zh_HK", "/common/js/jquery/plugins/datejs/date-zh-HK.js");
            localeFiles.put("zh_SG", "/common/js/jquery/plugins/datejs/date-zh-SG.js");
            localeFiles.put("zh_TW", "/common/js/jquery/plugins/datejs/date-zh-TW.js");
            localeFiles.put("hr", "/common/js/jquery/plugins/datejs/date-hr-HR.js");
            localeFiles.put("hr_HR", "/common/js/jquery/plugins/datejs/date-hr-HR.js");
            localeFiles.put("cs", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("cs_CZ", "/common/js/jquery/plugins/datejs/date-cs-CZ.js");
            localeFiles.put("da", "/common/js/jquery/plugins/datejs/date-da-DA.js");
            localeFiles.put("da_DK", "/common/js/jquery/plugins/datejs/date-da-DK.js");
            localeFiles.put("nl", "/common/js/jquery/plugins/datejs/date-nl-NL.js");
            localeFiles.put("nl_BE", "/common/js/jquery/plugins/datejs/date-nl-BE.js");
            localeFiles.put("nl_NL", "/common/js/jquery/plugins/datejs/date-nl-NL.js");
            localeFiles.put("en", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("en_AU", "/common/js/jquery/plugins/datejs/date-en-AU.js");
            localeFiles.put("en_CA", "/common/js/jquery/plugins/datejs/date-en-CA.js");
            localeFiles.put("en_IN", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("en_IE", "/common/js/jquery/plugins/datejs/date-en-IE.js");
            localeFiles.put("en_MT", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("en_NZ", "/common/js/jquery/plugins/datejs/date-en-NZ.js");
            localeFiles.put("en_PH", "/common/js/jquery/plugins/datejs/date-en-PH.js");
            localeFiles.put("en_SG", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("en_ZA", "/common/js/jquery/plugins/datejs/date-en-ZA.js");
            localeFiles.put("en_GB", "/common/js/jquery/plugins/datejs/date-en-GB.js");
            localeFiles.put("en_US", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("et", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("et_EE", "/common/js/jquery/plugins/datejs/date-et-EE.js");
            localeFiles.put("fi", "/common/js/jquery/plugins/datejs/date-fi-FI.js");
            localeFiles.put("fi_FI", "/common/js/jquery/plugins/datejs/date-fi-FI.js");
            localeFiles.put("fr", "/common/js/jquery/plugins/datejs/date-fr-FR.js");
            localeFiles.put("fr_BE", "/common/js/jquery/plugins/datejs/date-fr-BE.js");
            localeFiles.put("fr_CA", "/common/js/jquery/plugins/datejs/date-fr-CA.js");
            localeFiles.put("fr_FR", "/common/js/jquery/plugins/datejs/date-fr-FR.js");
            localeFiles.put("fr_LU", "/common/js/jquery/plugins/datejs/date-fr-LU.js");
            localeFiles.put("fr_CH", "/common/js/jquery/plugins/datejs/date-fr-CH.js");
            localeFiles.put("de", "/common/js/jquery/plugins/datejs/date-de-DE.js");
            localeFiles.put("de_AT", "/common/js/jquery/plugins/datejs/date-de-AT.js");
            localeFiles.put("de_DE", "/common/js/jquery/plugins/datejs/date-de-DE.js");
            localeFiles.put("de_GR", "/common/js/jquery/plugins/datejs/date-de-DE.js");
            localeFiles.put("de_LU", "/common/js/jquery/plugins/datejs/date-de-LU.js");
            localeFiles.put("de_CH", "/common/js/jquery/plugins/datejs/date-de-CH.js");
            localeFiles.put("el", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("el_CY", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("el_GR", "/common/js/jquery/plugins/datejs/date-el-GR.js");
            localeFiles.put("iw", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("iw_IL", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("hi", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("hi_IN", "/common/js/jquery/plugins/datejs/date-hi-IN.js");
            localeFiles.put("hu", "/common/js/jquery/plugins/datejs/date-hu-HU.js");
            localeFiles.put("hu_HU", "/common/js/jquery/plugins/datejs/date-hu-HU.js");
            localeFiles.put("is", "/common/js/jquery/plugins/datejs/date-is-IS.js");
            localeFiles.put("is_IS", "/common/js/jquery/plugins/datejs/date-is-IS.js");
            localeFiles.put("in", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("in_ID", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("ga", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("ga_IE", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("it", "/common/js/jquery/plugins/datejs/date-it-IT.js");
            localeFiles.put("it_IT", "/common/js/jquery/plugins/datejs/date-it-IT.js");
            localeFiles.put("it_CH", "/common/js/jquery/plugins/datejs/date-it-CH.js");
            localeFiles.put("ja", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("ja_JP", "/common/js/jquery/plugins/datejs/date-ja-JP.js");
            localeFiles.put("ja_JP_JP_#u-ca-japanese", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("ko", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("ko_KR", "/common/js/jquery/plugins/datejs/date-ko-KR.js");
            localeFiles.put("lv", "/common/js/jquery/plugins/datejs/date-lv-LV.js");
            localeFiles.put("lv_LV", "/common/js/jquery/plugins/datejs/date-lv-LV.js");
            localeFiles.put("lt", "/common/js/jquery/plugins/datejs/date-lt-LT.js");
            localeFiles.put("lt_LT", "/common/js/jquery/plugins/datejs/date-lt-LT.js");
            localeFiles.put("mk", "/common/js/jquery/plugins/datejs/date-mk-MK.js");
            localeFiles.put("mk_MK", "/common/js/jquery/plugins/datejs/date-mk-MK.js");
            localeFiles.put("ms", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("ms_MY", "/common/js/jquery/plugins/datejs/date-ms-MY.js");
            localeFiles.put("mt", "/common/js/jquery/plugins/datejs/date-mt-MT.js");
            localeFiles.put("mt_MT", "/common/js/jquery/plugins/datejs/date-mt-MT.js");
            localeFiles.put("no", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("no_NO", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("no_NO_NY", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("pl", "/common/js/jquery/plugins/datejs/date-pl-PL.js");
            localeFiles.put("pl_PL", "/common/js/jquery/plugins/datejs/date-pl-PL.js");
            localeFiles.put("pt", "/common/js/jquery/plugins/datejs/date-pt-PT.js");
            localeFiles.put("pt_BR", "/common/js/jquery/plugins/datejs/date-pt-BR.js");
            localeFiles.put("pt_PT", "/common/js/jquery/plugins/datejs/date-pt-PT.js");
            localeFiles.put("ro", "/common/js/jquery/plugins/datejs/date-ro-RO.js");
            localeFiles.put("ro_RO", "/common/js/jquery/plugins/datejs/date-ro-RO.js");
            localeFiles.put("ru", "/common/js/jquery/plugins/datejs/date-ru-RU.js");
            localeFiles.put("ru_RU", "/common/js/jquery/plugins/datejs/date-ru-RU.js");
            localeFiles.put("sr", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("sr_BA", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("sr__#Latn", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("sr_BA_#Latn", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("sr_ME_#Latn", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("sr_RS_#Latn", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("sr_ME", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("sr_CS", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("sr_RS", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("sk", "/common/js/jquery/plugins/datejs/date-sk-SK.js");
            localeFiles.put("sk_SK", "/common/js/jquery/plugins/datejs/date-sk-SK.js");
            localeFiles.put("sl", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("sl_SI", "/common/js/jquery/plugins/datejs/date-sl-SI.js");
            localeFiles.put("es", "/common/js/jquery/plugins/datejs/date-es-ES.js");
            localeFiles.put("es_AR", "/common/js/jquery/plugins/datejs/date-es-AR.js");
            localeFiles.put("es_BO", "/common/js/jquery/plugins/datejs/date-es-BO.js");
            localeFiles.put("es_CL", "/common/js/jquery/plugins/datejs/date-es-CL.js");
            localeFiles.put("es_CO", "/common/js/jquery/plugins/datejs/date-es-CO.js");
            localeFiles.put("es_CR", "/common/js/jquery/plugins/datejs/date-es-CR.js");
            localeFiles.put("es_CU", "/common/js/jquery/plugins/datejs/date-es-ES.js");
            localeFiles.put("es_DO", "/common/js/jquery/plugins/datejs/date-es-DO.js");
            localeFiles.put("es_EC", "/common/js/jquery/plugins/datejs/date-es-EC.js");
            localeFiles.put("es_SV", "/common/js/jquery/plugins/datejs/date-es-SV.js");
            localeFiles.put("es_GT", "/common/js/jquery/plugins/datejs/date-es-GT.js");
            localeFiles.put("es_HN", "/common/js/jquery/plugins/datejs/date-es-HN.js");
            localeFiles.put("es_MX", "/common/js/jquery/plugins/datejs/date-es-MX.js");
            localeFiles.put("es_NI", "/common/js/jquery/plugins/datejs/date-es-NI.js");
            localeFiles.put("es_PA", "/common/js/jquery/plugins/datejs/date-es-PA.js");
            localeFiles.put("es_PY", "/common/js/jquery/plugins/datejs/date-es-PY.js");
            localeFiles.put("es_PE", "/common/js/jquery/plugins/datejs/date-es-PE.js");
            localeFiles.put("es_PR", "/common/js/jquery/plugins/datejs/date-es-PR.js");
            localeFiles.put("es_ES", "/common/js/jquery/plugins/datejs/date-es-ES.js");
            localeFiles.put("es_US", "/common/js/jquery/plugins/datejs/date-es-ES.js");
            localeFiles.put("es_UY", "/common/js/jquery/plugins/datejs/date-es-UY.js");
            localeFiles.put("es_VE", "/common/js/jquery/plugins/datejs/date-es-VE.js");
            localeFiles.put("sv", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("sv_SE", "/common/js/jquery/plugins/datejs/date-sv-SE.js");
            localeFiles.put("th", "/common/js/jquery/plugins/datejs/date-th-TH.js");
            localeFiles.put("th_TH", "/common/js/jquery/plugins/datejs/date-th-TH.js");
            localeFiles.put("th_TH_TH_#u-nu-thai", "/common/js/jquery/plugins/datejs/date-th-TH.js");
            localeFiles.put("tr", "/common/js/jquery/plugins/datejs/date-tr-TR.js");
            localeFiles.put("tr_TR", "/common/js/jquery/plugins/datejs/date-tr-TR.js");
            localeFiles.put("uk", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("uk_UA", "/common/js/jquery/plugins/datejs/date-uk-UA.js");
            localeFiles.put("vi", "/common/js/jquery/plugins/datejs/date-en-US.js");
            localeFiles.put("vi_VN", "/common/js/jquery/plugins/datejs/date-vi-VN.js");
        }

        public static String getFilePath(String locale) {
            if (DateJs.localeFiles.containsKey(locale)) {
                return DateJs.localeFiles.get(locale);
            }
            return DateJs.defaultDateJs;
        }

    }

    public static class JQuery {
        private static Map<String, String> localeFiles = new HashMap<>();
        private static String defaultDateJs = "/common/js/jquery/ui/i18n/datepicker-en.js";

        static {
            localeFiles.put("sq", "/common/js/jquery/ui/i18n/datepicker-sq.js");
            localeFiles.put("sq_AL", "/common/js/jquery/ui/i18n/datepicker-sq.js");
            localeFiles.put("ar", "/common/js/jquery/ui/i18n/datepicker-ar.js");
            localeFiles.put("ar_DZ", "/common/js/jquery/ui/i18n/datepicker-ar.js");
            localeFiles.put("ar_BH", "/common/js/jquery/ui/i18n/datepicker-ar.js");
            localeFiles.put("ar_EG", "/common/js/jquery/ui/i18n/datepicker-ar.js");
            localeFiles.put("ar_IQ", "/common/js/jquery/ui/i18n/datepicker-ar.js");
            localeFiles.put("ar_JO", "/common/js/jquery/ui/i18n/datepicker-ar.js");
            localeFiles.put("ar_KW", "/common/js/jquery/ui/i18n/datepicker-ar.js");
            localeFiles.put("ar_LB", "/common/js/jquery/ui/i18n/datepicker-ar.js");
            localeFiles.put("ar_LY", "/common/js/jquery/ui/i18n/datepicker-ar.js");
            localeFiles.put("ar_MA", "/common/js/jquery/ui/i18n/datepicker-ar.js");
            localeFiles.put("ar_OM", "/common/js/jquery/ui/i18n/datepicker-ar.js");
            localeFiles.put("ar_QA", "/common/js/jquery/ui/i18n/datepicker-ar.js");
            localeFiles.put("ar_SA", "/common/js/jquery/ui/i18n/datepicker-ar.js");
            localeFiles.put("ar_SD", "/common/js/jquery/ui/i18n/datepicker-ar.js");
            localeFiles.put("ar_SY", "/common/js/jquery/ui/i18n/datepicker-ar.js");
            localeFiles.put("ar_TN", "/common/js/jquery/ui/i18n/datepicker-ar.js");
            localeFiles.put("ar_AE", "/common/js/jquery/ui/i18n/datepicker-ar.js");
            localeFiles.put("ar_YE", "/common/js/jquery/ui/i18n/datepicker-ar.js");
            localeFiles.put("be", "/common/js/jquery/ui/i18n/datepicker-be.js");
            localeFiles.put("be_BY", "/common/js/jquery/ui/i18n/datepicker-be.js");
            localeFiles.put("bg", "/common/js/jquery/ui/i18n/datepicker-bg.js");
            localeFiles.put("bg_BG", "/common/js/jquery/ui/i18n/datepicker-bg.js");
            localeFiles.put("ca", "/common/js/jquery/ui/i18n/datepicker-ca.js");
            localeFiles.put("ca_ES", "/common/js/jquery/ui/i18n/datepicker-ca.js");
            localeFiles.put("zh", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("zh_CN", "/common/js/jquery/ui/i18n/datepicker-zh-CN.js");
            localeFiles.put("zh_HK", "/common/js/jquery/ui/i18n/datepicker-zh-HK.js");
            localeFiles.put("zh_SG", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("zh_TW", "/common/js/jquery/ui/i18n/datepicker-zh-TW.js");
            localeFiles.put("hr", "/common/js/jquery/ui/i18n/datepicker-hr.js");
            localeFiles.put("hr_HR", "/common/js/jquery/ui/i18n/datepicker-hr.js");
            localeFiles.put("cs", "/common/js/jquery/ui/i18n/datepicker-cs.js");
            localeFiles.put("cs_CZ", "/common/js/jquery/ui/i18n/datepicker-cs.js");
            localeFiles.put("da", "/common/js/jquery/ui/i18n/datepicker-da.js");
            localeFiles.put("da_DK", "/common/js/jquery/ui/i18n/datepicker-da.js");
            localeFiles.put("nl", "/common/js/jquery/ui/i18n/datepicker-nl.js");
            localeFiles.put("nl_BE", "/common/js/jquery/ui/i18n/datepicker-nl.js");
            localeFiles.put("nl_NL", "/common/js/jquery/ui/i18n/datepicker-nl.js");
            localeFiles.put("en", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("en_AU", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("en_CA", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("en_IN", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("en_IE", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("en_MT", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("en_NZ", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("en_PH", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("en_SG", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("en_ZA", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("en_GB", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("en_US", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("et", "/common/js/jquery/ui/i18n/datepicker-et.js");
            localeFiles.put("et_EE", "/common/js/jquery/ui/i18n/datepicker-et.js");
            localeFiles.put("fi", "/common/js/jquery/ui/i18n/datepicker-fi.js");
            localeFiles.put("fi_FI", "/common/js/jquery/ui/i18n/datepicker-fi.js");
            localeFiles.put("fr", "/common/js/jquery/ui/i18n/datepicker-fr.js");
            localeFiles.put("fr_BE", "/common/js/jquery/ui/i18n/datepicker-fr.js");
            localeFiles.put("fr_CA", "/common/js/jquery/ui/i18n/datepicker-fr.js");
            localeFiles.put("fr_FR", "/common/js/jquery/ui/i18n/datepicker-fr.js");
            localeFiles.put("fr_LU", "/common/js/jquery/ui/i18n/datepicker-fr.js");
            localeFiles.put("fr_CH", "/common/js/jquery/ui/i18n/datepicker-fr.js");
            localeFiles.put("de", "/common/js/jquery/ui/i18n/datepicker-de.js");
            localeFiles.put("de_AT", "/common/js/jquery/ui/i18n/datepicker-de.js");
            localeFiles.put("de_DE", "/common/js/jquery/ui/i18n/datepicker-de.js");
            localeFiles.put("de_GR", "/common/js/jquery/ui/i18n/datepicker-de.js");
            localeFiles.put("de_LU", "/common/js/jquery/ui/i18n/datepicker-de.js");
            localeFiles.put("de_CH", "/common/js/jquery/ui/i18n/datepicker-de.js");
            localeFiles.put("el", "/common/js/jquery/ui/i18n/datepicker-el.js");
            localeFiles.put("el_CY", "/common/js/jquery/ui/i18n/datepicker-el.js");
            localeFiles.put("el_GR", "/common/js/jquery/ui/i18n/datepicker-el.js");
            localeFiles.put("iw", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("iw_IL", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("hi", "/common/js/jquery/ui/i18n/datepicker-hi.js");
            localeFiles.put("hi_IN", "/common/js/jquery/ui/i18n/datepicker-hi.js");
            localeFiles.put("hu", "/common/js/jquery/ui/i18n/datepicker-hu.js");
            localeFiles.put("hu_HU", "/common/js/jquery/ui/i18n/datepicker-hu.js");
            localeFiles.put("is", "/common/js/jquery/ui/i18n/datepicker-is.js");
            localeFiles.put("is_IS", "/common/js/jquery/ui/i18n/datepicker-is.js");
            localeFiles.put("in", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("in_ID", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("ga", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("ga_IE", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("it", "/common/js/jquery/ui/i18n/datepicker-it.js");
            localeFiles.put("it_IT", "/common/js/jquery/ui/i18n/datepicker-it.js");
            localeFiles.put("it_CH", "/common/js/jquery/ui/i18n/datepicker-it.js");
            localeFiles.put("ja", "/common/js/jquery/ui/i18n/datepicker-ja.js");
            localeFiles.put("ja_JP", "/common/js/jquery/ui/i18n/datepicker-ja.js");
            localeFiles.put("ja_JP_JP_#u-ca-japanese", "/common/js/jquery/ui/i18n/datepicker-ja.js");
            localeFiles.put("ko", "/common/js/jquery/ui/i18n/datepicker-ko.js");
            localeFiles.put("ko_KR", "/common/js/jquery/ui/i18n/datepicker-ko.js");
            localeFiles.put("lv", "/common/js/jquery/ui/i18n/datepicker-lv.js");
            localeFiles.put("lv_LV", "/common/js/jquery/ui/i18n/datepicker-lv.js");
            localeFiles.put("lt", "/common/js/jquery/ui/i18n/datepicker-lt.js");
            localeFiles.put("lt_LT", "/common/js/jquery/ui/i18n/datepicker-lt.js");
            localeFiles.put("mk", "/common/js/jquery/ui/i18n/datepicker-mk.js");
            localeFiles.put("mk_MK", "/common/js/jquery/ui/i18n/datepicker-mk.js");
            localeFiles.put("ms", "/common/js/jquery/ui/i18n/datepicker-ms.js");
            localeFiles.put("ms_MY", "/common/js/jquery/ui/i18n/datepicker-ms.js");
            localeFiles.put("mt", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("mt_MT", "/common/js/jquery/ui/i18n/datepicker-en.js");
            localeFiles.put("no", "/common/js/jquery/ui/i18n/datepicker-no.js");
            localeFiles.put("no_NO", "/common/js/jquery/ui/i18n/datepicker-no.js");
            localeFiles.put("no_NO_NY", "/common/js/jquery/ui/i18n/datepicker-no.js");
            localeFiles.put("pl", "/common/js/jquery/ui/i18n/datepicker-pl.js");
            localeFiles.put("pl_PL", "/common/js/jquery/ui/i18n/datepicker-pl.js");
            localeFiles.put("pt", "/common/js/jquery/ui/i18n/datepicker-pt.js");
            localeFiles.put("pt_BR", "/common/js/jquery/ui/i18n/datepicker-pt.js");
            localeFiles.put("pt_PT", "/common/js/jquery/ui/i18n/datepicker-pt.js");
            localeFiles.put("ro", "/common/js/jquery/ui/i18n/datepicker-ro.js");
            localeFiles.put("ro_RO", "/common/js/jquery/ui/i18n/datepicker-ro.js");
            localeFiles.put("ru", "/common/js/jquery/ui/i18n/datepicker-ru.js");
            localeFiles.put("ru_RU", "/common/js/jquery/ui/i18n/datepicker-ru.js");
            localeFiles.put("sr", "/common/js/jquery/ui/i18n/datepicker-sr.js");
            localeFiles.put("sr_BA", "/common/js/jquery/ui/i18n/datepicker-sr.js");
            localeFiles.put("sr__#Latn", "/common/js/jquery/ui/i18n/datepicker-sr.js");
            localeFiles.put("sr_BA_#Latn", "/common/js/jquery/ui/i18n/datepicker-sr.js");
            localeFiles.put("sr_ME_#Latn", "/common/js/jquery/ui/i18n/datepicker-sr.js");
            localeFiles.put("sr_RS_#Latn", "/common/js/jquery/ui/i18n/datepicker-sr.js");
            localeFiles.put("sr_ME", "/common/js/jquery/ui/i18n/datepicker-sr.js");
            localeFiles.put("sr_CS", "/common/js/jquery/ui/i18n/datepicker-sr.js");
            localeFiles.put("sr_RS", "/common/js/jquery/ui/i18n/datepicker-sr.js");
            localeFiles.put("sk", "/common/js/jquery/ui/i18n/datepicker-sk.js");
            localeFiles.put("sk_SK", "/common/js/jquery/ui/i18n/datepicker-sk.js");
            localeFiles.put("sl", "/common/js/jquery/ui/i18n/datepicker-sl.js");
            localeFiles.put("sl_SI", "/common/js/jquery/ui/i18n/datepicker-sl.js");
            localeFiles.put("es", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_AR", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_BO", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_CL", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_CO", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_CR", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_CU", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_DO", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_EC", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_SV", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_GT", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_HN", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_MX", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_NI", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_PA", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_PY", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_PE", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_PR", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_ES", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_US", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_UY", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("es_VE", "/common/js/jquery/ui/i18n/datepicker-es.js");
            localeFiles.put("sv", "/common/js/jquery/ui/i18n/datepicker-sv.js");
            localeFiles.put("sv_SE", "/common/js/jquery/ui/i18n/datepicker-sv.js");
            localeFiles.put("th", "/common/js/jquery/ui/i18n/datepicker-th.js");
            localeFiles.put("th_TH", "/common/js/jquery/ui/i18n/datepicker-th.js");
            localeFiles.put("th_TH_TH_#u-nu-thai", "/common/js/jquery/ui/i18n/datepicker-th.js");
            localeFiles.put("tr", "/common/js/jquery/ui/i18n/datepicker-tr.js");
            localeFiles.put("tr_TR", "/common/js/jquery/ui/i18n/datepicker-tr.js");
            localeFiles.put("uk", "/common/js/jquery/ui/i18n/datepicker-uk.js");
            localeFiles.put("uk_UA", "/common/js/jquery/ui/i18n/datepicker-uk.js");
            localeFiles.put("vi", "/common/js/jquery/ui/i18n/datepicker-vi.js");
            localeFiles.put("vi_VN", "/common/js/jquery/ui/i18n/datepicker-vi.js");
        }

        public static String getFilePath(String locale) {
            if (DateJs.localeFiles.containsKey(locale)) {
                return JQuery.localeFiles.get(locale);
            }
            return JQuery.defaultDateJs;
        }

    }

    public static class Validation {
        private static Map<String, String> localeFiles = new HashMap<>();
        private static String defaultValidation = "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js";

        static {
            localeFiles.put("sq", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("sq_AL", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("ar", "/common/js/node_modules/jquery-validation/dist/localization/messages_ar.js");
            localeFiles.put("ar_DZ", "/common/js/node_modules/jquery-validation/dist/localization/messages_ar.js");
            localeFiles.put("ar_BH", "/common/js/node_modules/jquery-validation/dist/localization/messages_ar.js");
            localeFiles.put("ar_EG", "/common/js/node_modules/jquery-validation/dist/localization/messages_ar.js");
            localeFiles.put("ar_IQ", "/common/js/node_modules/jquery-validation/dist/localization/messages_ar.js");
            localeFiles.put("ar_JO", "/common/js/node_modules/jquery-validation/dist/localization/messages_ar.js");
            localeFiles.put("ar_KW", "/common/js/node_modules/jquery-validation/dist/localization/messages_ar.js");
            localeFiles.put("ar_LB", "/common/js/node_modules/jquery-validation/dist/localization/messages_ar.js");
            localeFiles.put("ar_LY", "/common/js/node_modules/jquery-validation/dist/localization/messages_ar.js");
            localeFiles.put("ar_MA", "/common/js/node_modules/jquery-validation/dist/localization/messages_ar.js");
            localeFiles.put("ar_OM", "/common/js/node_modules/jquery-validation/dist/localization/messages_ar.js");
            localeFiles.put("ar_QA", "/common/js/node_modules/jquery-validation/dist/localization/messages_ar.js");
            localeFiles.put("ar_SA", "/common/js/node_modules/jquery-validation/dist/localization/messages_ar.js");
            localeFiles.put("ar_SD", "/common/js/node_modules/jquery-validation/dist/localization/messages_ar.js");
            localeFiles.put("ar_SY", "/common/js/node_modules/jquery-validation/dist/localization/messages_ar.js");
            localeFiles.put("ar_TN", "/common/js/node_modules/jquery-validation/dist/localization/messages_ar.js");
            localeFiles.put("ar_AE", "/common/js/node_modules/jquery-validation/dist/localization/messages_ar.js");
            localeFiles.put("ar_YE", "/common/js/node_modules/jquery-validation/dist/localization/messages_ar.js");
            localeFiles.put("be", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("be_BY", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("bg", "/common/js/node_modules/jquery-validation/dist/localization/messages_bg.js");
            localeFiles.put("bg_BG", "/common/js/node_modules/jquery-validation/dist/localization/messages_bg.js");
            localeFiles.put("ca", "/common/js/node_modules/jquery-validation/dist/localization/messages_ca.js");
            localeFiles.put("ca_ES", "/common/js/node_modules/jquery-validation/dist/localization/messages_ca.js");
            localeFiles.put("zh", "/common/js/node_modules/jquery-validation/dist/localization/messages_zh.js");
            localeFiles.put("zh_CN", "/common/js/node_modules/jquery-validation/dist/localization/messages_zh.js");
            localeFiles.put("zh_HK", "/common/js/node_modules/jquery-validation/dist/localization/messages_zh.js");
            localeFiles.put("zh_SG", "/common/js/node_modules/jquery-validation/dist/localization/messages_zh.js");
            localeFiles.put("zh_TW", "/common/js/node_modules/jquery-validation/dist/localization/messages_zh_TW.js");
            localeFiles.put("hr", "/common/js/node_modules/jquery-validation/dist/localization/messages_hr.js");
            localeFiles.put("hr_HR", "/common/js/node_modules/jquery-validation/dist/localization/messages_hr.js");
            localeFiles.put("cs", "/common/js/node_modules/jquery-validation/dist/localization/messages_cs.js");
            localeFiles.put("cs_CZ", "/common/js/node_modules/jquery-validation/dist/localization/messages_cs.js");
            localeFiles.put("da", "/common/js/node_modules/jquery-validation/dist/localization/messages_da.js");
            localeFiles.put("da_DK", "/common/js/node_modules/jquery-validation/dist/localization/messages_da.js");
            localeFiles.put("nl", "/common/js/node_modules/jquery-validation/dist/localization/messages_nl.js");
            localeFiles.put("nl_BE", "/common/js/node_modules/jquery-validation/dist/localization/messages_nl.js");
            localeFiles.put("nl_NL", "/common/js/node_modules/jquery-validation/dist/localization/messages_nl.js");
            localeFiles.put("en", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("en_AU", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("en_CA", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("en_IN", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("en_IE", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("en_MT", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("en_NZ", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("en_PH", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("en_SG", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("en_ZA", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("en_GB", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("en_US", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("et", "/common/js/node_modules/jquery-validation/dist/localization/messages_et.js");
            localeFiles.put("et_EE", "/common/js/node_modules/jquery-validation/dist/localization/messages_et.js");
            localeFiles.put("fi", "/common/js/node_modules/jquery-validation/dist/localization/messages_fi.js");
            localeFiles.put("fi_FI", "/common/js/node_modules/jquery-validation/dist/localization/messages_fi.js");
            localeFiles.put("fr", "/common/js/node_modules/jquery-validation/dist/localization/messages_fr.js");
            localeFiles.put("fr_BE", "/common/js/node_modules/jquery-validation/dist/localization/messages_fr.js");
            localeFiles.put("fr_CA", "/common/js/node_modules/jquery-validation/dist/localization/messages_fr.js");
            localeFiles.put("fr_FR", "/common/js/node_modules/jquery-validation/dist/localization/messages_fr.js");
            localeFiles.put("fr_LU", "/common/js/node_modules/jquery-validation/dist/localization/messages_fr.js");
            localeFiles.put("fr_CH", "/common/js/node_modules/jquery-validation/dist/localization/messages_fr.js");
            localeFiles.put("de", "/common/js/node_modules/jquery-validation/dist/localization/messages_de.js");
            localeFiles.put("de_AT", "/common/js/node_modules/jquery-validation/dist/localization/messages_de.js");
            localeFiles.put("de_DE", "/common/js/node_modules/jquery-validation/dist/localization/messages_de.js");
            localeFiles.put("de_GR", "/common/js/node_modules/jquery-validation/dist/localization/messages_de.js");
            localeFiles.put("de_LU", "/common/js/node_modules/jquery-validation/dist/localization/messages_de.js");
            localeFiles.put("de_CH", "/common/js/node_modules/jquery-validation/dist/localization/messages_de.js");
            localeFiles.put("el", "/common/js/node_modules/jquery-validation/dist/localization/messages_el.js");
            localeFiles.put("el_CY", "/common/js/node_modules/jquery-validation/dist/localization/messages_el.js");
            localeFiles.put("el_GR", "/common/js/node_modules/jquery-validation/dist/localization/messages_el.js");
            localeFiles.put("iw", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("iw_IL", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("hi", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("hi_IN", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("hu", "/common/js/node_modules/jquery-validation/dist/localization/messages_hu.js");
            localeFiles.put("hu_HU", "/common/js/node_modules/jquery-validation/dist/localization/messages_hu.js");
            localeFiles.put("is", "/common/js/node_modules/jquery-validation/dist/localization/messages_is.js");
            localeFiles.put("is_IS", "/common/js/node_modules/jquery-validation/dist/localization/messages_is.js");
            localeFiles.put("in", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("in_ID", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("ga", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("ga_IE", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("it", "/common/js/node_modules/jquery-validation/dist/localization/messages_it.js");
            localeFiles.put("it_IT", "/common/js/node_modules/jquery-validation/dist/localization/messages_it.js");
            localeFiles.put("it_CH", "/common/js/node_modules/jquery-validation/dist/localization/messages_it.js");
            localeFiles.put("ja", "/common/js/node_modules/jquery-validation/dist/localization/messages_ja.js");
            localeFiles.put("ja_JP", "/common/js/node_modules/jquery-validation/dist/localization/messages_ja.js");
            localeFiles.put("ja_JP_JP_#u-ca-japanese", "/common/js/node_modules/jquery-validation/dist/localization/messages_ja.js");
            localeFiles.put("ko", "/common/js/node_modules/jquery-validation/dist/localization/messages_ko.js");
            localeFiles.put("ko_KR", "/common/js/node_modules/jquery-validation/dist/localization/messages_ko.js");
            localeFiles.put("lv", "/common/js/node_modules/jquery-validation/dist/localization/messages_lv.js");
            localeFiles.put("lv_LV", "/common/js/node_modules/jquery-validation/dist/localization/messages_lv.js");
            localeFiles.put("lt", "/common/js/node_modules/jquery-validation/dist/localization/messages_lt.js");
            localeFiles.put("lt_LT", "/common/js/node_modules/jquery-validation/dist/localization/messages_lt.js");
            localeFiles.put("mk", "/common/js/node_modules/jquery-validation/dist/localization/messages_mk.js");
            localeFiles.put("mk_MK", "/common/js/node_modules/jquery-validation/dist/localization/messages_mk.js");
            localeFiles.put("ms", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("ms_MY", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("mt", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("mt_MT", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("no", "/common/js/node_modules/jquery-validation/dist/localization/messages_no.js");
            localeFiles.put("no_NO", "/common/js/node_modules/jquery-validation/dist/localization/messages_no.js");
            localeFiles.put("no_NO_NY", "/common/js/node_modules/jquery-validation/dist/localization/messages_no.js");
            localeFiles.put("pl", "/common/js/node_modules/jquery-validation/dist/localization/messages_pl.js");
            localeFiles.put("pl_PL", "/common/js/node_modules/jquery-validation/dist/localization/messages_pl.js");
            localeFiles.put("pt", "/common/js/node_modules/jquery-validation/dist/localization/messages_en.js");
            localeFiles.put("pt_BR", "/common/js/node_modules/jquery-validation/dist/localization/messages_pt_BR.js");
            localeFiles.put("pt_PT", "/common/js/node_modules/jquery-validation/dist/localization/messages_pt_PT.js");
            localeFiles.put("ro", "/common/js/node_modules/jquery-validation/dist/localization/messages_ro.js");
            localeFiles.put("ro_RO", "/common/js/node_modules/jquery-validation/dist/localization/messages_ro.js");
            localeFiles.put("ru", "/common/js/node_modules/jquery-validation/dist/localization/messages_ru.js");
            localeFiles.put("ru_RU", "/common/js/node_modules/jquery-validation/dist/localization/messages_ru.js");
            localeFiles.put("sr", "/common/js/node_modules/jquery-validation/dist/localization/messages_sr.js");
            localeFiles.put("sr_BA", "/common/js/node_modules/jquery-validation/dist/localization/messages_sr.js");
            localeFiles.put("sr__#Latn", "/common/js/node_modules/jquery-validation/dist/localization/messages_sr.js");
            localeFiles.put("sr_BA_#Latn", "/common/js/node_modules/jquery-validation/dist/localization/messages_sr.js");
            localeFiles.put("sr_ME_#Latn", "/common/js/node_modules/jquery-validation/dist/localization/messages_sr.js");
            localeFiles.put("sr_RS_#Latn", "/common/js/node_modules/jquery-validation/dist/localization/messages_sr.js");
            localeFiles.put("sr_ME", "/common/js/node_modules/jquery-validation/dist/localization/messages_sr.js");
            localeFiles.put("sr_CS", "/common/js/node_modules/jquery-validation/dist/localization/messages_sr.js");
            localeFiles.put("sr_RS", "/common/js/node_modules/jquery-validation/dist/localization/messages_sr.js");
            localeFiles.put("sk", "/common/js/node_modules/jquery-validation/dist/localization/messages_sk.js");
            localeFiles.put("sk_SK", "/common/js/node_modules/jquery-validation/dist/localization/messages_sk.js");
            localeFiles.put("sl", "/common/js/node_modules/jquery-validation/dist/localization/messages_sl.js");
            localeFiles.put("sl_SI", "/common/js/node_modules/jquery-validation/dist/localization/messages_sl.js");
            localeFiles.put("es", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_AR", "/common/js/node_modules/jquery-validation/dist/localization/messages_es_AR.js");
            localeFiles.put("es_BO", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_CL", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_CO", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_CR", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_CU", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_DO", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_EC", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_SV", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_GT", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_HN", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_MX", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_NI", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_PA", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_PY", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_PE", "/common/js/node_modules/jquery-validation/dist/localization/messages_es_PE.js");
            localeFiles.put("es_PR", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_ES", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_US", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_UY", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("es_VE", "/common/js/node_modules/jquery-validation/dist/localization/messages_es.js");
            localeFiles.put("sv", "/common/js/node_modules/jquery-validation/dist/localization/messages_sv.js");
            localeFiles.put("sv_SE", "/common/js/node_modules/jquery-validation/dist/localization/messages_sv.js");
            localeFiles.put("th", "/common/js/node_modules/jquery-validation/dist/localization/messages_th.js");
            localeFiles.put("th_TH", "/common/js/node_modules/jquery-validation/dist/localization/messages_th.js");
            localeFiles.put("th_TH_TH_#u-nu-thai", "/common/js/node_modules/jquery-validation/dist/localization/messages_th.js");
            localeFiles.put("tr", "/common/js/node_modules/jquery-validation/dist/localization/messages_tr.js");
            localeFiles.put("tr_TR", "/common/js/node_modules/jquery-validation/dist/localization/messages_tr.js");
            localeFiles.put("uk", "/common/js/node_modules/jquery-validation/dist/localization/messages_uk.js");
            localeFiles.put("uk_UA", "/common/js/node_modules/jquery-validation/dist/localization/messages_uk.js");
            localeFiles.put("vi", "/common/js/node_modules/jquery-validation/dist/localization/messages_vi.js");
            localeFiles.put("vi_VN", "/common/js/node_modules/jquery-validation/dist/localization/messages_vi.js");
        }

        public static String getFilePath(String locale) {
            if (Validation.localeFiles.containsKey(locale)) {
                return Validation.localeFiles.get(locale);
            }
            return Validation.defaultValidation;
        }
    }

    public static class DateTime {
        private static Map<String, String> localeFiles = new HashMap<>();
        private static String defaultDateTime = "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js";

        static {
            localeFiles.put("sq", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-sq.js");
            localeFiles.put("sq_AL", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-sq.js");
            localeFiles.put("ar", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ar_DZ", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ar_BH", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ar_EG", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ar_IQ", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ar_JO", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ar_KW", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ar_LB", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ar_LY", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ar_MA", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ar_OM", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ar_QA", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ar_SA", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ar_SD", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ar_SY", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ar_TN", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ar_AE", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ar_YE", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("be", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("be_BY", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("bg", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-bg.js");
            localeFiles.put("bg_BG", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-bg.js");
            localeFiles.put("ca", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-ca.js");
            localeFiles.put("ca_ES", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-ca.js");
            localeFiles.put("zh", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("zh_CN", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-zh-CN.js");
            localeFiles.put("zh_HK", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-zh-HK.js");
            localeFiles.put("zh_SG", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("zh_TW", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-zh-TW.js");
            localeFiles.put("hr", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-hr.js");
            localeFiles.put("hr_HR", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-hr.js");
            localeFiles.put("cs", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-cs.js");
            localeFiles.put("cs_CZ", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-cs.js");
            localeFiles.put("da", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-da.js");
            localeFiles.put("da_DK", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-da.js");
            localeFiles.put("nl", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-nl.js");
            localeFiles.put("nl_BE", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-nl.js");
            localeFiles.put("nl_NL", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-nl.js");
            localeFiles.put("en", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("en_AU", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("en_CA", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("en_IN", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("en_IE", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("en_MT", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("en_NZ", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("en_PH", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("en_SG", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("en_ZA", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("en_GB", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("en_US", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("et", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-et.js");
            localeFiles.put("et_EE", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-et.js");
            localeFiles.put("fi", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-fi.js");
            localeFiles.put("fi_FI", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-fi.js");
            localeFiles.put("fr", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-fr.js");
            localeFiles.put("fr_BE", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-fr.js");
            localeFiles.put("fr_CA", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-fr.js");
            localeFiles.put("fr_FR", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-fr.js");
            localeFiles.put("fr_LU", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-fr.js");
            localeFiles.put("fr_CH", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-fr.js");
            localeFiles.put("de", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-de.js");
            localeFiles.put("de_AT", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-de.js");
            localeFiles.put("de_DE", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-de.js");
            localeFiles.put("de_GR", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-de.js");
            localeFiles.put("de_LU", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-de.js");
            localeFiles.put("de_CH", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-de.js");
            localeFiles.put("el", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-el.js");
            localeFiles.put("el_CY", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-el.js");
            localeFiles.put("el_GR", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-el.js");
            localeFiles.put("iw", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("iw_IL", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("hi", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("hi_IN", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("hu", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-hu.js");
            localeFiles.put("hu_HU", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-hu.js");
            localeFiles.put("is", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("is_IS", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("in", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("in_ID", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ga", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ga_IE", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("it", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-it.js");
            localeFiles.put("it_IT", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-it.js");
            localeFiles.put("it_CH", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-it.js");
            localeFiles.put("ja", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-ja.js");
            localeFiles.put("ja_JP", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-ja.js");
            localeFiles.put("ja_JP_JP_#u-ca-japanese", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-ja.js");
            localeFiles.put("ko", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-ko.js");
            localeFiles.put("ko_KR", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-ko.js");
            localeFiles.put("lv", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-lv.js");
            localeFiles.put("lv_LV", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-lv.js");
            localeFiles.put("lt", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-lt.js");
            localeFiles.put("lt_LT", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-lt.js");
            localeFiles.put("mk", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-mk.js");
            localeFiles.put("mk_MK", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-mk.js");
            localeFiles.put("ms", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("ms_MY", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("mt", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("mt_MT", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("no", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-no.js");
            localeFiles.put("no_NO", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-no.js");
            localeFiles.put("no_NO_NY", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-no.js");
            localeFiles.put("pl", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-pl.js");
            localeFiles.put("pl_PL", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-pl.js");
            localeFiles.put("pt", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-pt.js");
            localeFiles.put("pt_BR", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-pt.js");
            localeFiles.put("pt_PT", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-pt.js");
            localeFiles.put("ro", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-ro.js");
            localeFiles.put("ro_RO", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-ro.js");
            localeFiles.put("ru", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-ru.js");
            localeFiles.put("ru_RU", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-ru.js");
            localeFiles.put("sr", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("sr_BA", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("sr__#Latn", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("sr_BA_#Latn", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("sr_ME_#Latn", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("sr_RS_#Latn", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("sr_ME", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("sr_CS", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-en.js");
            localeFiles.put("sr_RS", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-sr-RS.js");
            localeFiles.put("sk", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-sk.js");
            localeFiles.put("sk_SK", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-sk.js");
            localeFiles.put("sl", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-sl.js");
            localeFiles.put("sl_SI", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-sl.js");
            localeFiles.put("es", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_AR", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_BO", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_CL", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_CO", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_CR", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_CU", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_DO", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_EC", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_SV", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_GT", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_HN", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_MX", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_NI", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_PA", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_PY", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_PE", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_PR", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_ES", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_US", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_UY", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("es_VE", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-es.js");
            localeFiles.put("sv", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-sv.js");
            localeFiles.put("sv_SE", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-sv.js");
            localeFiles.put("th", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-th.js");
            localeFiles.put("th_TH", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-th.js");
            localeFiles.put("th_TH_TH_#u-nu-thai", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-th.js");
            localeFiles.put("tr", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-tr.js");
            localeFiles.put("tr_TR", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-tr.js");
            localeFiles.put("uk", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-uk.js");
            localeFiles.put("uk_UA", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-uk.js");
            localeFiles.put("vi", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-vi.js");
            localeFiles.put("vi_VN", "/common/js/jquery/plugins/datetimepicker/i18n/jquery-ui-timepicker-vi.js");
        }

        public static String getFilePath(String locale) {
            if (DateTime.localeFiles.containsKey(locale)) {
                return DateTime.localeFiles.get(locale);
            }
            return DateTime.defaultDateTime;
        }
    }

    public static class Select2 {
        private static Map<String, String> localeFiles = new HashMap<>();
        private static String defaultSelect2 = "/common/js/jquery/plugins/select2/js/i18n/en.js";

        static {
            localeFiles.put("sq", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("sq_AL", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("ar", "/common/js/jquery/plugins/select2/js/i18n/ar.js");
            localeFiles.put("ar_DZ", "/common/js/jquery/plugins/select2/js/i18n/ar.js");
            localeFiles.put("ar_BH", "/common/js/jquery/plugins/select2/js/i18n/ar.js");
            localeFiles.put("ar_EG", "/common/js/jquery/plugins/select2/js/i18n/ar.js");
            localeFiles.put("ar_IQ", "/common/js/jquery/plugins/select2/js/i18n/ar.js");
            localeFiles.put("ar_JO", "/common/js/jquery/plugins/select2/js/i18n/ar.js");
            localeFiles.put("ar_KW", "/common/js/jquery/plugins/select2/js/i18n/ar.js");
            localeFiles.put("ar_LB", "/common/js/jquery/plugins/select2/js/i18n/ar.js");
            localeFiles.put("ar_LY", "/common/js/jquery/plugins/select2/js/i18n/ar.js");
            localeFiles.put("ar_MA", "/common/js/jquery/plugins/select2/js/i18n/ar.js");
            localeFiles.put("ar_OM", "/common/js/jquery/plugins/select2/js/i18n/ar.js");
            localeFiles.put("ar_QA", "/common/js/jquery/plugins/select2/js/i18n/ar.js");
            localeFiles.put("ar_SA", "/common/js/jquery/plugins/select2/js/i18n/ar.js");
            localeFiles.put("ar_SD", "/common/js/jquery/plugins/select2/js/i18n/ar.js");
            localeFiles.put("ar_SY", "/common/js/jquery/plugins/select2/js/i18n/ar.js");
            localeFiles.put("ar_TN", "/common/js/jquery/plugins/select2/js/i18n/ar.js");
            localeFiles.put("ar_AE", "/common/js/jquery/plugins/select2/js/i18n/ar.js");
            localeFiles.put("ar_YE", "/common/js/jquery/plugins/select2/js/i18n/ar.js");
            localeFiles.put("be", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("be_BY", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("bg", "/common/js/jquery/plugins/select2/js/i18n/bg.js");
            localeFiles.put("bg_BG", "/common/js/jquery/plugins/select2/js/i18n/bg.js");
            localeFiles.put("ca", "/common/js/jquery/plugins/select2/js/i18n/ca.js");
            localeFiles.put("ca_ES", "/common/js/jquery/plugins/select2/js/i18n/ca.js");
            localeFiles.put("zh", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("zh_CN", "/common/js/jquery/plugins/select2/js/i18n/zh-CN.js");
            localeFiles.put("zh_HK", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("zh_SG", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("zh_TW", "/common/js/jquery/plugins/select2/js/i18n/zh-TW.js");
            localeFiles.put("hr", "/common/js/jquery/plugins/select2/js/i18n/hr.js");
            localeFiles.put("hr_HR", "/common/js/jquery/plugins/select2/js/i18n/hr.js");
            localeFiles.put("cs", "/common/js/jquery/plugins/select2/js/i18n/cs.js");
            localeFiles.put("cs_CZ", "/common/js/jquery/plugins/select2/js/i18n/cs.js");
            localeFiles.put("da", "/common/js/jquery/plugins/select2/js/i18n/da.js");
            localeFiles.put("da_DK", "/common/js/jquery/plugins/select2/js/i18n/da.js");
            localeFiles.put("nl", "/common/js/jquery/plugins/select2/js/i18n/nl.js");
            localeFiles.put("nl_BE", "/common/js/jquery/plugins/select2/js/i18n/nl.js");
            localeFiles.put("nl_NL", "/common/js/jquery/plugins/select2/js/i18n/nl.js");
            localeFiles.put("en", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("en_AU", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("en_CA", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("en_IN", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("en_IE", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("en_MT", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("en_NZ", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("en_PH", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("en_SG", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("en_ZA", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("en_GB", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("en_US", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("et", "/common/js/jquery/plugins/select2/js/i18n/et.js");
            localeFiles.put("et_EE", "/common/js/jquery/plugins/select2/js/i18n/et.js");
            localeFiles.put("fi", "/common/js/jquery/plugins/select2/js/i18n/fi.js");
            localeFiles.put("fi_FI", "/common/js/jquery/plugins/select2/js/i18n/fi.js");
            localeFiles.put("fr", "/common/js/jquery/plugins/select2/js/i18n/fr.js");
            localeFiles.put("fr_BE", "/common/js/jquery/plugins/select2/js/i18n/fr.js");
            localeFiles.put("fr_CA", "/common/js/jquery/plugins/select2/js/i18n/fr.js");
            localeFiles.put("fr_FR", "/common/js/jquery/plugins/select2/js/i18n/fr.js");
            localeFiles.put("fr_LU", "/common/js/jquery/plugins/select2/js/i18n/fr.js");
            localeFiles.put("fr_CH", "/common/js/jquery/plugins/select2/js/i18n/fr.js");
            localeFiles.put("de", "/common/js/jquery/plugins/select2/js/i18n/de.js");
            localeFiles.put("de_AT", "/common/js/jquery/plugins/select2/js/i18n/de.js");
            localeFiles.put("de_DE", "/common/js/jquery/plugins/select2/js/i18n/de.js");
            localeFiles.put("de_GR", "/common/js/jquery/plugins/select2/js/i18n/de.js");
            localeFiles.put("de_LU", "/common/js/jquery/plugins/select2/js/i18n/de.js");
            localeFiles.put("de_CH", "/common/js/jquery/plugins/select2/js/i18n/de.js");
            localeFiles.put("el", "/common/js/jquery/plugins/select2/js/i18n/el.js");
            localeFiles.put("el_CY", "/common/js/jquery/plugins/select2/js/i18n/el.js");
            localeFiles.put("el_GR", "/common/js/jquery/plugins/select2/js/i18n/el.js");
            localeFiles.put("iw", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("iw_IL", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("hi", "/common/js/jquery/plugins/select2/js/i18n/hi.js");
            localeFiles.put("hi_IN", "/common/js/jquery/plugins/select2/js/i18n/hi.js");
            localeFiles.put("hu", "/common/js/jquery/plugins/select2/js/i18n/hu.js");
            localeFiles.put("hu_HU", "/common/js/jquery/plugins/select2/js/i18n/hu.js");
            localeFiles.put("is", "/common/js/jquery/plugins/select2/js/i18n/is.js");
            localeFiles.put("is_IS", "/common/js/jquery/plugins/select2/js/i18n/is.js");
            localeFiles.put("in", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("in_ID", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("ga", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("ga_IE", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("it", "/common/js/jquery/plugins/select2/js/i18n/it.js");
            localeFiles.put("it_IT", "/common/js/jquery/plugins/select2/js/i18n/it.js");
            localeFiles.put("it_CH", "/common/js/jquery/plugins/select2/js/i18n/it.js");
            localeFiles.put("ja", "/common/js/jquery/plugins/select2/js/i18n/ja.js");
            localeFiles.put("ja_JP", "/common/js/jquery/plugins/select2/js/i18n/ja.js");
            localeFiles.put("ja_JP_JP_#u-ca-japanese", "/common/js/jquery/plugins/select2/js/i18n/ja.js");
            localeFiles.put("ko", "/common/js/jquery/plugins/select2/js/i18n/ko.js");
            localeFiles.put("ko_KR", "/common/js/jquery/plugins/select2/js/i18n/ko.js");
            localeFiles.put("lv", "/common/js/jquery/plugins/select2/js/i18n/lv.js");
            localeFiles.put("lv_LV", "/common/js/jquery/plugins/select2/js/i18n/lv.js");
            localeFiles.put("lt", "/common/js/jquery/plugins/select2/js/i18n/lt.js");
            localeFiles.put("lt_LT", "/common/js/jquery/plugins/select2/js/i18n/lt.js");
            localeFiles.put("mk", "/common/js/jquery/plugins/select2/js/i18n/mk.js");
            localeFiles.put("mk_MK", "/common/js/jquery/plugins/select2/js/i18n/mk.js");
            localeFiles.put("ms", "/common/js/jquery/plugins/select2/js/i18n/ms.js");
            localeFiles.put("ms_MY", "/common/js/jquery/plugins/select2/js/i18n/ms.js");
            localeFiles.put("mt", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("mt_MT", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("no", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("no_NO", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("no_NO_NY", "/common/js/jquery/plugins/select2/js/i18n/en.js");
            localeFiles.put("pl", "/common/js/jquery/plugins/select2/js/i18n/pl.js");
            localeFiles.put("pl_PL", "/common/js/jquery/plugins/select2/js/i18n/pl.js");
            localeFiles.put("pt", "/common/js/jquery/plugins/select2/js/i18n/pt.js");
            localeFiles.put("pt_BR", "/common/js/jquery/plugins/select2/js/i18n/pt.js");
            localeFiles.put("pt_PT", "/common/js/jquery/plugins/select2/js/i18n/pt.js");
            localeFiles.put("ro", "/common/js/jquery/plugins/select2/js/i18n/ro.js");
            localeFiles.put("ro_RO", "/common/js/jquery/plugins/select2/js/i18n/ro.js");
            localeFiles.put("ru", "/common/js/jquery/plugins/select2/js/i18n/ru.js");
            localeFiles.put("ru_RU", "/common/js/jquery/plugins/select2/js/i18n/ru.js");
            localeFiles.put("sr", "/common/js/jquery/plugins/select2/js/i18n/sr.js");
            localeFiles.put("sr_BA", "/common/js/jquery/plugins/select2/js/i18n/sr.js");
            localeFiles.put("sr__#Latn", "/common/js/jquery/plugins/select2/js/i18n/sr.js");
            localeFiles.put("sr_BA_#Latn", "/common/js/jquery/plugins/select2/js/i18n/sr.js");
            localeFiles.put("sr_ME_#Latn", "/common/js/jquery/plugins/select2/js/i18n/sr.js");
            localeFiles.put("sr_RS_#Latn", "/common/js/jquery/plugins/select2/js/i18n/sr.js");
            localeFiles.put("sr_ME", "/common/js/jquery/plugins/select2/js/i18n/sr.js");
            localeFiles.put("sr_CS", "/common/js/jquery/plugins/select2/js/i18n/sr.js");
            localeFiles.put("sr_RS", "/common/js/jquery/plugins/select2/js/i18n/sr.js");
            localeFiles.put("sk", "/common/js/jquery/plugins/select2/js/i18n/sk.js");
            localeFiles.put("sk_SK", "/common/js/jquery/plugins/select2/js/i18n/sk.js");
            localeFiles.put("sl", "/common/js/jquery/plugins/select2/js/i18n/sl.js");
            localeFiles.put("sl_SI", "/common/js/jquery/plugins/select2/js/i18n/sl.js");
            localeFiles.put("es", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_AR", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_BO", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_CL", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_CO", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_CR", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_CU", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_DO", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_EC", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_SV", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_GT", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_HN", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_MX", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_NI", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_PA", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_PY", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_PE", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_PR", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_ES", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_US", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_UY", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("es_VE", "/common/js/jquery/plugins/select2/js/i18n/es.js");
            localeFiles.put("sv", "/common/js/jquery/plugins/select2/js/i18n/sv.js");
            localeFiles.put("sv_SE", "/common/js/jquery/plugins/select2/js/i18n/sv.js");
            localeFiles.put("th", "/common/js/jquery/plugins/select2/js/i18n/th.js");
            localeFiles.put("th_TH", "/common/js/jquery/plugins/select2/js/i18n/th.js");
            localeFiles.put("th_TH_TH_#u-nu-thai", "/common/js/jquery/plugins/select2/js/i18n/th.js");
            localeFiles.put("tr", "/common/js/jquery/plugins/select2/js/i18n/tr.js");
            localeFiles.put("tr_TR", "/common/js/jquery/plugins/select2/js/i18n/tr.js");
            localeFiles.put("uk", "/common/js/jquery/plugins/select2/js/i18n/uk.js");
            localeFiles.put("uk_UA", "/common/js/jquery/plugins/select2/js/i18n/uk.js");
            localeFiles.put("vi", "/common/js/jquery/plugins/select2/js/i18n/vi.js");
            localeFiles.put("vi_VN", "/common/js/jquery/plugins/select2/js/i18n/vi.js");
        }

        public static String getFilePath(String locale) {
            if (Select2.localeFiles.containsKey(locale)) {
                return Select2.localeFiles.get(locale);
            }
            return Select2.defaultSelect2;
        }
    }
}
