/****************************************************************************
 * arch/arm/include/imx9/irq.h
 *
 * SPDX-License-Identifier: Apache-2.0
 * SPDX-FileCopyrightText: 2024 NXP
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

/* This file should never be included directly but, rather,
 * only indirectly through nuttx/irq.h
 */

#ifndef __ARCH_ARM_INCLUDE_IMX9_IRQ_H
#define __ARCH_ARM_INCLUDE_IMX9_IRQ_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>

#if defined(CONFIG_ARCH_CHIP_IMX95_M7)
#  include <arch/imx9/imx95_irq.h>
#else
#  error "Unrecognized i.MX9 architecture"
#endif

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/* IRQ numbers.  The IRQ number corresponds vector number and hence map
 * directly to bits in the NVIC.  This does, however, waste several words
 * of memory in the IRQ to handle mapping tables.
 */

/* Common Processor Exceptions (vectors 0-15) */

#define IMX9_IRQ_RESERVED       (0) /* Reserved vector .. only used with
                                     * CONFIG_DEBUG_FEATURES */

                                    /* Vector 0: Reset stack pointer value */

                                    /* Vector 1: Reset(not handled by IRQ) */

#define IMX9_IRQ_NMI            (2) /* Vector  2: Non-Maskable Int (NMI) */
#define IMX9_IRQ_HARDFAULT      (3) /* Vector  3: Hard fault */
#define IMX9_IRQ_MEMFAULT       (4) /* Vector  4: Memory management (MPU) */
#define IMX9_IRQ_BUSFAULT       (5) /* Vector  5: Bus fault */
#define IMX9_IRQ_USAGEFAULT     (6) /* Vector  6: Usage fault */
                                    /* Vectors 7-10: Reserved */

#define IMX9_IRQ_SVCALL        (11) /* Vector 11: SVC call */
#define IMX9_IRQ_DBGMONITOR    (12) /* Vector 12: Debug Monitor */
                                    /* Vector 13: Reserved */

#define IMX9_IRQ_PENDSV        (14) /* Vector 14: Pendable SSR */
#define IMX9_IRQ_SYSTICK       (15) /* Vector 15: System tick */

/* Chip-Specific External interrupts */

#define IMX9_IRQ_EXTINT        (16) /* Vector number of the first ext int */
#define ARMV7M_PERIPHERAL_INTERRUPTS IMX9_IRQ_NEXTINT

#endif /* __ARCH_ARM_INCLUDE_IMX9_IRQ_H */
