/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.archive.format.http.HttpHeader;

public class LaxHttpParser {
    private static final Logger LOG = Logger.getLogger(LaxHttpParser.class.getName());

    protected LaxHttpParser() {
    }

    public static byte[] readRawLine(InputStream inputStream) throws IOException {
        int ch;
        LOG.finest("enter LaxHttpParser.readRawLine()");
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        while ((ch = inputStream.read()) >= 0) {
            buf.write(ch);
            if (ch != 10) continue;
        }
        if (buf.size() == 0) {
            return null;
        }
        return buf.toByteArray();
    }

    public static String readLine(InputStream inputStream, String charset) throws IOException {
        LOG.finest("enter LaxHttpParser.readLine(InputStream, String)");
        byte[] rawdata = LaxHttpParser.readRawLine(inputStream);
        if (rawdata == null) {
            return null;
        }
        int len = rawdata.length;
        int offset = 0;
        if (len > 0 && rawdata[len - 1] == 10) {
            ++offset;
            if (len > 1 && rawdata[len - 2] == 13) {
                ++offset;
            }
        }
        try {
            return new String(rawdata, 0, len - offset, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(rawdata, 0, len - offset, StandardCharsets.ISO_8859_1);
        }
    }

    public static String readLine(InputStream inputStream) throws IOException {
        LOG.finest("enter LaxHttpParser.readLine(InputStream)");
        return LaxHttpParser.readLine(inputStream, StandardCharsets.US_ASCII.name());
    }

    public static HttpHeader[] parseHeaders(InputStream is, String charset) throws IOException {
        String line;
        LOG.finest("enter HeaderParser.parseHeaders(InputStream, String)");
        ArrayList<HttpHeader> headers = new ArrayList<HttpHeader>();
        String name = null;
        StringBuffer value = null;
        while ((line = LaxHttpParser.readLine(is, charset)) != null && line.trim().length() >= 1) {
            int colon;
            if (line.charAt(0) == ' ' || line.charAt(0) == '\t') {
                if (value == null) continue;
                value.append(' ');
                value.append(line.trim());
                continue;
            }
            if (name != null) {
                headers.add(new HttpHeader(name, value.toString()));
            }
            if ((colon = line.indexOf(":")) < 0) {
                name = "HttpClient-Bad-Header-Line-Failed-Parse";
                value = new StringBuffer(line);
                continue;
            }
            name = line.substring(0, colon).trim();
            value = new StringBuffer(line.substring(colon + 1).trim());
        }
        if (name != null) {
            headers.add(new HttpHeader(name, value.toString()));
        }
        return headers.toArray(new HttpHeader[0]);
    }

    public static HttpHeader[] parseHeaders(InputStream is) throws IOException {
        LOG.finest("enter HeaderParser.parseHeaders(InputStream, String)");
        return LaxHttpParser.parseHeaders(is, StandardCharsets.US_ASCII.name());
    }
}

