/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io.warc;

import com.google.common.io.CountingInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import org.archive.io.ArchiveReader;
import org.archive.io.ArchiveReaderFactory;
import org.archive.io.ArchiveRecord;
import org.archive.io.warc.WARCReader;
import org.archive.io.warc.WARCRecord;
import org.archive.util.ArchiveUtils;
import org.archive.util.FileUtils;
import org.archive.util.zip.GZIPMembersInputStream;

public class WARCReaderFactory
extends ArchiveReaderFactory {
    private static final WARCReaderFactory factory = new WARCReaderFactory();

    private WARCReaderFactory() {
    }

    public static WARCReader get(String arcFileOrUrl) throws MalformedURLException, IOException {
        return (WARCReader)factory.getArchiveReader(arcFileOrUrl);
    }

    public static WARCReader get(File f) throws IOException {
        return (WARCReader)factory.getArchiveReader(f);
    }

    public static WARCReader get(File f, long offset) throws IOException {
        return (WARCReader)factory.getArchiveReader(f, offset);
    }

    @Override
    protected ArchiveReader getArchiveReader(File f, long offset) throws IOException {
        WARCReader wARCReader;
        boolean compressed = WARCReaderFactory.testCompressedWARCFile(f);
        if (!compressed && !FileUtils.isReadableWithExtensionAndMagic(f, ".warc", "WARC/")) {
            throw new IOException(f.getAbsolutePath() + " is not a WARC file.");
        }
        if (compressed) {
            WARCReaderFactory wARCReaderFactory = factory;
            Objects.requireNonNull(wARCReaderFactory);
            wARCReader = wARCReaderFactory.new CompressedWARCReader(f, offset);
        } else {
            WARCReaderFactory wARCReaderFactory = factory;
            Objects.requireNonNull(wARCReaderFactory);
            wARCReader = wARCReaderFactory.new UncompressedWARCReader(f, offset);
        }
        return wARCReader;
    }

    public static ArchiveReader get(String s, InputStream is, boolean atFirstRecord) throws IOException {
        return factory.getArchiveReader(s, is, atFirstRecord);
    }

    @Override
    protected ArchiveReader getArchiveReader(String f, InputStream is, boolean atFirstRecord) throws IOException {
        if (f.endsWith(".gz")) {
            return new CompressedWARCReader(f, is, atFirstRecord);
        }
        return new UncompressedWARCReader(f, is);
    }

    public static WARCReader get(URL arcUrl, long offset) throws IOException {
        return (WARCReader)factory.getArchiveReader(arcUrl, offset);
    }

    public static WARCReader get(URL arcUrl) throws IOException {
        return (WARCReader)factory.getArchiveReader(arcUrl);
    }

    public static boolean testCompressedWARCFile(File f) throws IOException {
        FileUtils.assertReadable(f);
        boolean compressed = false;
        try (FileInputStream is = new FileInputStream(f);){
            compressed = ArchiveUtils.isGzipped(is);
        }
        return compressed;
    }

    public static boolean isWARCSuffix(String f) {
        return f == null ? false : (f.toLowerCase(Locale.ROOT).endsWith(".warc.gz") ? true : f.toLowerCase(Locale.ROOT).endsWith(".warc"));
    }

    public class CompressedWARCReader
    extends WARCReader {
        public CompressedWARCReader(File f) throws IOException {
            this(f, 0L);
        }

        public CompressedWARCReader(File f, long offset) throws IOException {
            this.setIn(new GZIPMembersInputStream(this.getInputStream(f, offset)));
            ((GZIPMembersInputStream)this.getIn()).compressedSeek(offset);
            this.setCompressed(offset == 0L);
            this.initialize(f.getAbsolutePath());
        }

        public CompressedWARCReader(String f, InputStream is, boolean atFirstRecord) throws IOException {
            this.setIn(new GZIPMembersInputStream(is));
            this.setCompressed(true);
            this.initialize(f);
        }

        @Override
        public WARCRecord get(long offset) throws IOException {
            this.cleanupCurrentRecord();
            ((GZIPMembersInputStream)this.getIn()).compressedSeek(offset);
            return this.createArchiveRecord(this.getIn(), offset);
        }

        @Override
        public Iterator<ArchiveRecord> iterator() {
            return new ArchiveReader.ArchiveRecordIterator(){
                private GZIPMembersInputStream gis;
                private Iterator<GZIPMembersInputStream> gzipIterator;
                {
                    this.gis = (GZIPMembersInputStream)CompressedWARCReader.this.getIn();
                    this.gzipIterator = this.gis.memberIterator();
                }

                @Override
                protected boolean innerHasNext() {
                    return this.gzipIterator.hasNext();
                }

                @Override
                protected ArchiveRecord innerNext() throws IOException {
                    InputStream is = this.gzipIterator.next();
                    return CompressedWARCReader.this.createArchiveRecord(is, Math.max(this.gis.getCurrentMemberStart(), this.gis.getCurrentMemberEnd()));
                }
            };
        }

        @Override
        protected void gotoEOR(ArchiveRecord rec) throws IOException {
            long skipped = 0L;
            while (this.getIn().read() > -1) {
                ++skipped;
            }
            if (skipped > 4L) {
                System.err.println("unexpected extra data after record " + rec);
            }
        }
    }

    public class UncompressedWARCReader
    extends WARCReader {
        public UncompressedWARCReader(File f) throws IOException {
            this(f, 0L);
        }

        public UncompressedWARCReader(File f, long offset) throws IOException {
            this.setIn((InputStream)new CountingInputStream(this.getInputStream(f, offset)));
            this.getIn().skip(offset);
            this.initialize(f.getAbsolutePath());
        }

        public UncompressedWARCReader(String f, InputStream is) {
            this.setIn((InputStream)new CountingInputStream(is));
            this.initialize(f);
        }
    }
}

