/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.dns;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.archive.format.dns.DNSParseException;
import org.archive.format.dns.DNSRecord;
import org.archive.format.dns.DNSResponse;

public class DNSResponseParser {
    private boolean isBlank(String line) {
        return line.matches("\\S");
    }

    private boolean isDate(String dateLine) {
        return !this.isBlank(dateLine);
    }

    public void parse(InputStream is, DNSResponse response) throws IOException, DNSParseException {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String date = br.readLine().trim();
            if (this.isDate(date)) {
                response.setDate(date);
            }
            while ((line = br.readLine()) != null) {
                if (this.isBlank(line)) continue;
                response.add(DNSRecord.parse(line));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

