/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support.single.shard;

import java.io.IOException;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.NoShardAvailableActionException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.ChannelActionListener;
import org.opensearch.action.support.TransportAction;
import org.opensearch.action.support.TransportActions;
import org.opensearch.action.support.single.shard.SingleShardRequest;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardsIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.logging.LoggerMessageFormat;
import org.opensearch.index.shard.ShardId;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestHandler;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public abstract class TransportSingleShardAction<Request extends SingleShardRequest<Request>, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final ThreadPool threadPool;
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final IndexNameExpressionResolver indexNameExpressionResolver;
    private final String transportShardAction;
    private final String executor;

    protected TransportSingleShardAction(String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Writeable.Reader<Request> request, String executor) {
        super(actionName, actionFilters, transportService.getTaskManager());
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.transportShardAction = actionName + "[s]";
        this.executor = executor;
        if (!this.isSubAction()) {
            transportService.registerRequestHandler(actionName, "same", request, new TransportHandler());
        }
        transportService.registerRequestHandler(this.transportShardAction, "same", request, new ShardTransportHandler());
    }

    protected boolean isSubAction() {
        return false;
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        new AsyncSingleAction(this, (SingleShardRequest)request, listener).start();
    }

    protected abstract Response shardOperation(Request var1, ShardId var2) throws IOException;

    protected void asyncShardOperation(Request request, ShardId shardId, ActionListener<Response> listener) throws IOException {
        this.threadPool.executor(this.getExecutor(request, shardId)).execute(ActionRunnable.supply(listener, () -> this.shardOperation(request, shardId)));
    }

    protected abstract Writeable.Reader<Response> getResponseReader();

    protected abstract boolean resolveIndex(Request var1);

    protected ClusterBlockException checkGlobalBlock(ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, InternalRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.READ, request.concreteIndex());
    }

    protected void resolveRequest(ClusterState state, InternalRequest request) {
    }

    @Nullable
    protected abstract ShardsIterator shards(ClusterState var1, InternalRequest var2);

    protected String getExecutor(Request request, ShardId shardId) {
        return this.executor;
    }

    protected static class InternalRequest {
        final Request request;
        final String concreteIndex;
        final /* synthetic */ TransportSingleShardAction this$0;

        InternalRequest(Request request, String concreteIndex) {
            this.this$0 = this$0;
            this.request = request;
            this.concreteIndex = concreteIndex;
        }

        public Request request() {
            return this.request;
        }

        public String concreteIndex() {
            return this.concreteIndex;
        }
    }

    private class ShardTransportHandler
    implements TransportRequestHandler<Request> {
        private ShardTransportHandler() {
        }

        @Override
        public void messageReceived(Request request, TransportChannel channel, Task task) throws Exception {
            if (TransportSingleShardAction.this.logger.isTraceEnabled()) {
                TransportSingleShardAction.this.logger.trace("executing [{}] on shard [{}]", request, (Object)((SingleShardRequest)request).internalShardId);
            }
            TransportSingleShardAction.this.asyncShardOperation(request, ((SingleShardRequest)request).internalShardId, new ChannelActionListener(channel, TransportSingleShardAction.this.transportShardAction, request));
        }
    }

    private class TransportHandler
    implements TransportRequestHandler<Request> {
        private TransportHandler() {
        }

        @Override
        public void messageReceived(Request request, TransportChannel channel, Task task) throws Exception {
            TransportSingleShardAction.this.execute(request, new ChannelActionListener(channel, TransportSingleShardAction.this.actionName, request));
        }
    }

    static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final ShardsIterator shardIt;
        private final InternalRequest internalRequest;
        private final DiscoveryNodes nodes;
        private volatile Exception lastFailure;
        final /* synthetic */ TransportSingleShardAction this$0;

        private AsyncSingleAction(Request request, ActionListener<Response> listener) {
            this.this$0 = this$0;
            this.listener = listener;
            ClusterState clusterState = this$0.clusterService.state();
            if (((TransportSingleShardAction)this$0).logger.isTraceEnabled()) {
                ((TransportSingleShardAction)this$0).logger.trace("executing [{}] based on cluster state version [{}]", request, (Object)clusterState.version());
            }
            this.nodes = clusterState.nodes();
            ClusterBlockException blockException = this$0.checkGlobalBlock(clusterState);
            if (blockException != null) {
                throw blockException;
            }
            String concreteSingleIndex = this$0.resolveIndex(request) ? this$0.indexNameExpressionResolver.concreteSingleIndex(clusterState, (IndicesRequest)request).getName() : ((SingleShardRequest)request).index();
            this.internalRequest = new InternalRequest((TransportSingleShardAction)this$0, request, concreteSingleIndex);
            this$0.resolveRequest(clusterState, this.internalRequest);
            blockException = this$0.checkRequestBlock(clusterState, this.internalRequest);
            if (blockException != null) {
                throw blockException;
            }
            this.shardIt = this$0.shards(clusterState, this.internalRequest);
        }

        public void start() {
            if (this.shardIt == null) {
                final Writeable.Reader reader = this.this$0.getResponseReader();
                this.this$0.transportService.sendRequest(this.this$0.clusterService.localNode(), this.this$0.transportShardAction, (TransportRequest)this.internalRequest.request(), new TransportResponseHandler<Response>(){

                    @Override
                    public Response read(StreamInput in) throws IOException {
                        return (ActionResponse)reader.read(in);
                    }

                    @Override
                    public String executor() {
                        return "same";
                    }

                    @Override
                    public void handleResponse(Response response) {
                        AsyncSingleAction.this.listener.onResponse(response);
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        AsyncSingleAction.this.listener.onFailure(exp);
                    }
                });
            } else {
                this.perform(null);
            }
        }

        private void onFailure(ShardRouting shardRouting, Exception e) {
            if (e != null) {
                this.this$0.logger.trace(() -> new ParameterizedMessage("{}: failed to execute [{}]", (Object)shardRouting, this.internalRequest.request()), (Throwable)e);
            }
            this.perform(e);
        }

        private void perform(@Nullable Exception currentFailure) {
            ShardRouting shardRouting;
            Exception lastFailure = this.lastFailure;
            if (lastFailure == null || TransportActions.isReadOverrideException(currentFailure)) {
                lastFailure = currentFailure;
                this.lastFailure = currentFailure;
            }
            if ((shardRouting = this.shardIt.nextOrNull()) == null) {
                Exception failure = lastFailure;
                if (failure == null || TransportActions.isShardNotAvailableException(failure)) {
                    failure = new NoShardAvailableActionException(null, LoggerMessageFormat.format("No shard available for [{}]", this.internalRequest.request()), failure);
                } else {
                    this.this$0.logger.debug(() -> new ParameterizedMessage("{}: failed to execute [{}]", null, this.internalRequest.request()), (Throwable)failure);
                }
                this.listener.onFailure(failure);
                return;
            }
            DiscoveryNode node = this.nodes.get(shardRouting.currentNodeId());
            if (node == null) {
                this.onFailure(shardRouting, new NoShardAvailableActionException(shardRouting.shardId()));
            } else {
                ((SingleShardRequest)this.internalRequest.request()).internalShardId = shardRouting.shardId();
                if (this.this$0.logger.isTraceEnabled()) {
                    this.this$0.logger.trace("sending request [{}] to shard [{}] on node [{}]", this.internalRequest.request(), (Object)((SingleShardRequest)this.internalRequest.request()).internalShardId, (Object)node);
                }
                final Writeable.Reader reader = this.this$0.getResponseReader();
                this.this$0.transportService.sendRequest(node, this.this$0.transportShardAction, (TransportRequest)this.internalRequest.request(), new TransportResponseHandler<Response>(){

                    @Override
                    public Response read(StreamInput in) throws IOException {
                        return (ActionResponse)reader.read(in);
                    }

                    @Override
                    public String executor() {
                        return "same";
                    }

                    @Override
                    public void handleResponse(Response response) {
                        AsyncSingleAction.this.listener.onResponse(response);
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        AsyncSingleAction.this.onFailure(shardRouting, exp);
                    }
                });
            }
        }
    }
}

