/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasAuthentication;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.logging.HasLogEvents;
import org.openqa.selenium.remote.AddHasAuthentication;
import org.openqa.selenium.remote.AddHasLogEvents;
import org.openqa.selenium.remote.Augmentable;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.RemoteExecuteMethod;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.html5.AddWebStorage;
import org.openqa.selenium.support.decorators.Decorated;

@Beta
public class Augmenter {
    private static final Logger LOG = Logger.getLogger(Augmenter.class.getName());
    private final Set<Augmentation<?>> augmentations;

    public Augmenter() {
        HashSet augmentations = new HashSet();
        Stream.of(new AddWebStorage()).forEach(provider -> augmentations.add(Augmenter.createAugmentation(provider)));
        StreamSupport.stream(ServiceLoader.load(AugmenterProvider.class).spliterator(), false).forEach(provider -> augmentations.add(Augmenter.createAugmentation(provider)));
        this.augmentations = Collections.unmodifiableSet(augmentations);
    }

    private static <X> Augmentation<X> createAugmentation(AugmenterProvider<X> provider) {
        Require.nonNull((String)"Interface provider", provider);
        return new Augmentation<Object>(provider.isApplicable(), provider.getDescribedInterface(), provider::getImplementation);
    }

    private Augmenter(Set<Augmentation<?>> augmentations, Augmentation<?> toAdd) {
        Require.nonNull((String)"Current list of augmentations", augmentations);
        Require.nonNull((String)"Augmentation to add", toAdd);
        HashSet toUse = new HashSet(augmentations.size() + 1);
        toUse.addAll(augmentations);
        toUse.add(toAdd);
        this.augmentations = Collections.unmodifiableSet(toUse);
    }

    public <X> Augmenter addDriverAugmentation(AugmenterProvider<X> provider) {
        Require.nonNull((String)"Interface provider", provider);
        return this.addDriverAugmentation(provider.isApplicable(), provider.getDescribedInterface(), provider::getImplementation);
    }

    public <X> Augmenter addDriverAugmentation(String capabilityName, Class<X> implementThis, BiFunction<Capabilities, ExecuteMethod, X> usingThis) {
        Require.nonNull((String)"Capability name", (Object)capabilityName);
        Require.nonNull((String)"Interface to implement", implementThis);
        Require.nonNull((String)"Concrete implementation", usingThis, (String)"of %s", (Object[])new Object[]{implementThis});
        return this.addDriverAugmentation(this.check(capabilityName), implementThis, usingThis);
    }

    public <X> Augmenter addDriverAugmentation(Predicate<Capabilities> whenThisMatches, Class<X> implementThis, BiFunction<Capabilities, ExecuteMethod, X> usingThis) {
        Require.nonNull((String)"Capability predicate", whenThisMatches);
        Require.nonNull((String)"Interface to implement", implementThis);
        Require.nonNull((String)"Concrete implementation", usingThis, (String)"of %s", (Object[])new Object[]{implementThis});
        Require.precondition((boolean)implementThis.isInterface(), (String)"Expected %s to be an interface", (Object[])new Object[]{implementThis});
        return new Augmenter(this.augmentations, new Augmentation<X>(whenThisMatches, implementThis, usingThis));
    }

    private Predicate<Capabilities> check(String capabilityName) {
        return caps -> {
            Require.nonNull((String)"Capability name", (Object)capabilityName);
            Object value = caps.getCapability(capabilityName);
            if (value instanceof Boolean && !((Boolean)value).booleanValue()) {
                return false;
            }
            return value != null;
        };
    }

    public WebDriver augment(WebDriver driver) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        Require.precondition((boolean)(driver instanceof HasCapabilities), (String)"Driver must have capabilities", (Object[])new Object[]{driver});
        if (driver instanceof Decorated) {
            LOG.warning("Warning: In future versions, passing a decorated driver will no longer be allowed.\n Instead, augment the driver first and then use it to created a decorated driver.\n Explanation: Decorated drivers are not aware of the augmentations applied to them. It can lead to expected behavior.\n For example, augmenting HasDevTools interface to a decorated driver. \n The decorated driver is not aware that after augmentation it is an instance of HasDevTools. So it does not invoke the close() method of the underlying websocket, potentially causing a memory leak. ");
        }
        ImmutableCapabilities caps = ImmutableCapabilities.copyOf((Capabilities)((HasCapabilities)driver).getCapabilities());
        List<Augmentation<?>> matchingAugmenters = this.augmentations.stream().filter(augmentation -> !augmentation.interfaceClass.isAssignableFrom(driver.getClass())).filter(arg_0 -> Augmenter.lambda$augment$4((Capabilities)caps, arg_0)).collect(Collectors.toList());
        return this.augment(driver, matchingAugmenters);
    }

    private WebDriver augment(WebDriver driver, List<Augmentation<?>> matchingAugmenters) {
        ImmutableCapabilities caps = ImmutableCapabilities.copyOf((Capabilities)((HasCapabilities)driver).getCapabilities());
        if (matchingAugmenters.isEmpty()) {
            return driver;
        }
        RemoteWebDriver remote = this.extractRemoteWebDriver(driver);
        ExecuteMethod execute = remote == null ? (commandName, parameters) -> {
            throw new WebDriverException("Cannot execute remote command: " + commandName);
        } : new RemoteExecuteMethod(remote);
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = new ByteBuddy().subclass(driver.getClass()).annotateType(new AnnotationDescription[]{AnnotationDescription.Builder.ofType(Augmentable.class).build()}).method((ElementMatcher)ElementMatchers.named((String)"isAugmented")).intercept((Implementation)FixedValue.value((Object)true));
        for (Augmentation<?> augmentation : matchingAugmenters) {
            Class iface = augmentation.interfaceClass;
            Object instance = augmentation.implementation.apply((Capabilities)caps, execute);
            builder = builder.implement(new Type[]{iface}).method((ElementMatcher)ElementMatchers.anyOf((Method[])iface.getDeclaredMethods())).intercept((Implementation)MethodDelegation.to(instance, iface));
        }
        Class<?> definition = builder.make().load(driver.getClass().getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded().asSubclass(driver.getClass());
        try {
            WebDriver toReturn = (WebDriver)definition.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.copyFields(driver.getClass(), driver, toReturn);
            toReturn = this.addDependentAugmentations(toReturn);
            return toReturn;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Unable to create new proxy", e);
        }
    }

    private WebDriver addDependentAugmentations(WebDriver driver) {
        ArrayList<Augmentation<Object>> augmentationList = new ArrayList<Augmentation<Object>>();
        WebDriver toReturn = driver;
        if (!(driver instanceof HasAuthentication)) {
            augmentationList.add(Augmenter.createAugmentation(new AddHasAuthentication()));
        }
        if (!(driver instanceof HasLogEvents)) {
            augmentationList.add(Augmenter.createAugmentation(new AddHasLogEvents()));
        }
        if (!augmentationList.isEmpty()) {
            ImmutableCapabilities caps = ImmutableCapabilities.copyOf((Capabilities)((HasCapabilities)driver).getCapabilities());
            List<Augmentation<?>> matchingAugmenters = augmentationList.stream().filter(arg_0 -> Augmenter.lambda$addDependentAugmentations$6((Capabilities)caps, arg_0)).collect(Collectors.toList());
            toReturn = this.augment(driver, matchingAugmenters);
        }
        return toReturn;
    }

    private RemoteWebDriver extractRemoteWebDriver(WebDriver driver) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        if (driver instanceof RemoteWebDriver) {
            return (RemoteWebDriver)driver;
        }
        if (driver instanceof Decorated) {
            return this.extractRemoteWebDriver((WebDriver)((Decorated)driver).getOriginal());
        }
        if (driver instanceof WrapsDriver) {
            return this.extractRemoteWebDriver(((WrapsDriver)driver).getWrappedDriver());
        }
        return null;
    }

    private void copyFields(Class<?> clazz, Object source, Object target) {
        if (Object.class.equals(clazz)) {
            return;
        }
        for (Field field : clazz.getDeclaredFields()) {
            this.copyField(source, target, field);
        }
        this.copyFields(clazz.getSuperclass(), source, target);
    }

    private void copyField(Object source, Object target, Field field) {
        if (Modifier.isFinal(field.getModifiers())) {
            return;
        }
        try {
            field.setAccessible(true);
            Object value = field.get(source);
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ boolean lambda$addDependentAugmentations$6(Capabilities caps, Augmentation augmentation) {
        return augmentation.whenMatches.test(caps);
    }

    private static /* synthetic */ boolean lambda$augment$4(Capabilities caps, Augmentation augmentation) {
        return augmentation.whenMatches.test(caps);
    }

    private static class Augmentation<X> {
        public final Predicate<Capabilities> whenMatches;
        public final Class<X> interfaceClass;
        public final BiFunction<Capabilities, ExecuteMethod, X> implementation;

        public Augmentation(Predicate<Capabilities> whenMatches, Class<X> interfaceClass, BiFunction<Capabilities, ExecuteMethod, X> implementation) {
            this.whenMatches = (Predicate)Require.nonNull((String)"Capabilities predicate", whenMatches);
            this.interfaceClass = (Class)Require.nonNull((String)"Interface to implement", interfaceClass);
            this.implementation = (BiFunction)Require.nonNull((String)"Interface implementation", implementation);
            Require.precondition((boolean)interfaceClass.isInterface(), (String)"%s must be an interface, not a concrete class", (Object[])new Object[]{interfaceClass});
        }
    }
}

