/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexwriter.solr;

import java.util.Arrays;
import java.util.List;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;

public class SolrUtils {
    static CloudSolrClient getCloudSolrClient(List<String> urls) {
        CloudSolrClient sc = new CloudSolrClient.Builder(urls).withParallelUpdates(true).build();
        sc.connect();
        return sc;
    }

    static CloudSolrClient getCloudSolrClient(List<String> urls, String username, String password) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
        CloudSolrClient sc = ((CloudSolrClient.Builder)new CloudSolrClient.Builder(urls).withParallelUpdates(true).withHttpClient((HttpClient)client)).build();
        sc.connect();
        return sc;
    }

    static CloudSolrClient getCloudSolrClientHeaderAuthorization(List<String> urls, String headerName, String headerValue) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setDefaultHeaders(Arrays.asList(new BasicHeader("Authorization", headerName + " " + headerValue)));
        CloudSolrClient sc = ((CloudSolrClient.Builder)new CloudSolrClient.Builder(urls).withParallelUpdates(true).withHttpClient((HttpClient)httpClientBuilder.build())).build();
        sc.connect();
        return sc;
    }

    static SolrClient getHttpSolrClient(String url) {
        return new HttpSolrClient.Builder(url).build();
    }

    static SolrClient getHttpSolrClientHeaderAuthorization(String url, String headerName, String headerValue) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setDefaultHeaders(Arrays.asList(new BasicHeader("Authorization", headerName + " " + headerValue)));
        return ((HttpSolrClient.Builder)new HttpSolrClient.Builder(url).withHttpClient((HttpClient)httpClientBuilder.build())).build();
    }

    static SolrClient getHttpSolrClient(String url, String username, String password) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        return ((HttpSolrClient.Builder)new HttpSolrClient.Builder(url).withHttpClient((HttpClient)httpClientBuilder.build())).build();
    }

    static String stripNonCharCodepoints(String input) {
        StringBuilder retval = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch % 65536 == 65535 || ch % 65536 == 65534 || ch > '\ufdd0' && ch < '\ufdef' || ch <= '\u001f' && ch != '\t' && ch != '\n' && ch != '\r') continue;
            retval.append(ch);
        }
        return retval.toString();
    }
}

