/*
 * Decompiled with CFR 0.152.
 */
package org.archive.streamcontext;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.archive.streamcontext.AbstractBufferingStream;

public class HTTP11Stream
extends AbstractBufferingStream {
    private URL url;
    private URLConnection conn = null;
    private InputStream is = null;

    public HTTP11Stream(URL url) throws IndexOutOfBoundsException, FileNotFoundException, IOException {
        this(url, 0L, DEFAULT_READ_SIZE);
    }

    public HTTP11Stream(URL url, long offset) throws IndexOutOfBoundsException, FileNotFoundException, IOException {
        this(url, offset, DEFAULT_READ_SIZE);
    }

    public HTTP11Stream(URL url, long offset, int readSize) throws IOException {
        super(offset, readSize);
        this.url = url;
        this.doSeek(offset);
    }

    @Override
    public void doClose() throws IOException {
        if (this.is != null) {
            this.is.close();
            this.is = null;
        }
    }

    @Override
    public int doRead(byte[] b, int off, int len) throws IOException {
        return this.is.read(b, off, len);
    }

    @Override
    public void doSeek(long offset) throws IOException {
        this.doClose();
        this.conn = this.url.openConnection();
        this.conn.setRequestProperty("Range", String.format("bytes=%d-", offset));
        this.conn.connect();
        this.is = this.conn.getInputStream();
    }
}

