/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.archive.io.ArchiveReader;
import org.archive.io.arc.ARCReaderFactory;
import org.archive.io.warc.WARCReaderFactory;
import org.archive.net.md5.Md5URLConnection;
import org.archive.net.rsync.RsyncURLConnection;
import org.archive.url.UsableURI;
import org.archive.util.FileUtils;

public class ArchiveReaderFactory {
    private static final ArchiveReaderFactory factory;

    protected ArchiveReaderFactory() {
    }

    public static ArchiveReader get(String arcFileOrUrl) throws MalformedURLException, IOException {
        return factory.getArchiveReader(arcFileOrUrl);
    }

    protected ArchiveReader getArchiveReader(String arcFileOrUrl) throws MalformedURLException, IOException {
        return this.getArchiveReader(arcFileOrUrl, 0L);
    }

    protected ArchiveReader getArchiveReader(String arcFileOrUrl, long offset) throws MalformedURLException, IOException {
        return UsableURI.hasScheme(arcFileOrUrl) && arcFileOrUrl.indexOf(":") > 1 ? ArchiveReaderFactory.get(new URL(arcFileOrUrl), offset) : ArchiveReaderFactory.get(new File(arcFileOrUrl), offset);
    }

    public static ArchiveReader get(File f) throws IOException {
        return factory.getArchiveReader(f);
    }

    protected ArchiveReader getArchiveReader(File f) throws IOException {
        return this.getArchiveReader(f, 0L);
    }

    public static ArchiveReader get(File f, long offset) throws IOException {
        return factory.getArchiveReader(f, offset);
    }

    protected ArchiveReader getArchiveReader(File f, long offset) throws IOException {
        if (ARCReaderFactory.isARCSuffix(f.getName())) {
            return ARCReaderFactory.get(f, true, offset);
        }
        if (WARCReaderFactory.isWARCSuffix(f.getName())) {
            return WARCReaderFactory.get(f, offset);
        }
        throw new IOException("Unknown file extension (Not ARC nor WARC): " + f.getName());
    }

    public static ArchiveReader get(String s, InputStream is, boolean atFirstRecord) throws IOException {
        return factory.getArchiveReader(s, is, atFirstRecord);
    }

    protected ArchiveReader getArchiveReader(String id, InputStream is, boolean atFirstRecord) throws IOException {
        InputStream stream = is;
        if (ARCReaderFactory.isARCSuffix(id)) {
            return ARCReaderFactory.get(id, stream, atFirstRecord);
        }
        if (WARCReaderFactory.isWARCSuffix(id)) {
            return WARCReaderFactory.get(id, stream, atFirstRecord);
        }
        throw new IOException("Unknown extension (Not ARC nor WARC): " + id);
    }

    public static ArchiveReader get(URL u, long offset) throws IOException {
        return factory.getArchiveReader(u, offset);
    }

    protected ArchiveReader getArchiveReader(URL f, long offset) throws IOException {
        URLConnection connection = f.openConnection();
        if (connection instanceof HttpURLConnection) {
            this.addUserAgent((HttpURLConnection)connection);
        }
        if (offset != 0L) {
            connection.addRequestProperty("Range", "bytes=" + offset + "-");
        }
        return this.getArchiveReader(f.toString(), connection.getInputStream(), offset == 0L);
    }

    public static ArchiveReader get(URL u) throws IOException {
        return factory.getArchiveReader(u);
    }

    protected ArchiveReader getArchiveReader(URL u) throws IOException {
        File f;
        if (u.getPath() != null && (f = new File(u.getPath())).exists()) {
            return ArchiveReaderFactory.get(f, 0L);
        }
        String scheme = u.getProtocol();
        if (scheme.startsWith("http") || scheme.equals("s3")) {
            return ArchiveReaderFactory.get(u, 0L);
        }
        return this.makeARCLocal(u.openConnection());
    }

    protected ArchiveReader makeARCLocal(URLConnection connection) throws IOException {
        File localFile = null;
        if (connection instanceof HttpURLConnection) {
            String p = connection.getURL().getPath();
            int index = p.lastIndexOf(47);
            if (index >= 0) {
                localFile = File.createTempFile("", p.substring(index + 1));
                if (localFile.exists()) {
                    localFile.delete();
                }
            } else {
                localFile = File.createTempFile(ArchiveReader.class.getName(), ".tmp");
            }
            this.addUserAgent((HttpURLConnection)connection);
            connection.connect();
            try {
                FileUtils.readFullyToFile(connection.getInputStream(), localFile);
            }
            catch (IOException ioe) {
                localFile.delete();
                throw ioe;
            }
        } else if (connection instanceof RsyncURLConnection) {
            connection.connect();
            localFile = ((RsyncURLConnection)connection).getFile();
        } else if (connection instanceof Md5URLConnection) {
            connection.connect();
            localFile = ((Md5URLConnection)connection).getFile();
        } else {
            throw new UnsupportedOperationException("No support for " + connection);
        }
        ArchiveReader reader = null;
        try {
            reader = ArchiveReaderFactory.get(localFile, 0L);
        }
        catch (IOException e) {
            localFile.delete();
            throw e;
        }
        return reader.getDeleteFileOnCloseReader(localFile);
    }

    protected void addUserAgent(HttpURLConnection connection) {
        connection.addRequestProperty("User-Agent", this.getClass().getName());
    }

    protected boolean isCompressed(File f) throws IOException {
        return f.getName().toLowerCase().endsWith(".gz");
    }

    static {
        if (System.getProperty("java.protocol.handler.pkgs") != null) {
            System.setProperty("java.protocol.handler.pkgs", System.getProperty("java.protocol.handler.pkgs") + "|org.archive.net");
        } else {
            System.setProperty("java.protocol.handler.pkgs", "org.archive.net");
        }
        factory = new ArchiveReaderFactory();
    }
}

