/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class NutchField
implements Writable,
Cloneable {
    private float weight;
    private ArrayList<Object> values = new ArrayList();

    public NutchField() {
    }

    public NutchField(Object value) {
        this(value, 1.0f);
    }

    public NutchField(Object value, float weight) {
        this.weight = weight;
        if (value instanceof Collection) {
            this.values.addAll((Collection)value);
        } else {
            this.values.add(value);
        }
    }

    public void add(Object value) {
        this.values.add(value);
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public void reset() {
        this.weight = 1.0f;
        this.values.clear();
    }

    public NutchField clone() throws CloneNotSupportedException {
        NutchField result = (NutchField)super.clone();
        result.weight = this.weight;
        result.values = (ArrayList)this.values.clone();
        return result;
    }

    public void readFields(DataInput in) throws IOException {
        this.weight = in.readFloat();
        int count = in.readInt();
        this.values = new ArrayList();
        for (int i = 0; i < count; ++i) {
            String type = Text.readString((DataInput)in);
            if ("java.lang.String".equals(type)) {
                this.values.add(Text.readString((DataInput)in));
                continue;
            }
            if ("java.lang.Boolean".equals(type)) {
                this.values.add(in.readBoolean());
                continue;
            }
            if ("java.lang.Integer".equals(type)) {
                this.values.add(in.readInt());
                continue;
            }
            if ("java.lang.Float".equals(type)) {
                this.values.add(Float.valueOf(in.readFloat()));
                continue;
            }
            if ("java.lang.Long".equals(type)) {
                this.values.add(in.readLong());
                continue;
            }
            if (!"java.util.Date".equals(type)) continue;
            this.values.add(new Date(in.readLong()));
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeFloat(this.weight);
        out.writeInt(this.values.size());
        for (Object value : this.values) {
            Text.writeString((DataOutput)out, (String)value.getClass().getName());
            if (value instanceof Boolean) {
                out.writeBoolean((Boolean)value);
                continue;
            }
            if (value instanceof Integer) {
                out.writeInt((Integer)value);
                continue;
            }
            if (value instanceof Long) {
                out.writeLong((Long)value);
                continue;
            }
            if (value instanceof Float) {
                out.writeFloat(((Float)value).floatValue());
                continue;
            }
            if (value instanceof String) {
                Text.writeString((DataOutput)out, (String)((String)value));
                continue;
            }
            if (!(value instanceof Date)) continue;
            Date date = (Date)value;
            out.writeLong(date.getTime());
        }
    }

    public String toString() {
        return this.values.toString();
    }
}

