/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VersionMismatchException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.nutch.indexer.NutchField;
import org.apache.nutch.metadata.Metadata;

public class NutchDocument
implements Writable,
Iterable<Map.Entry<String, NutchField>>,
Cloneable {
    public static final byte VERSION = 2;
    private HashMap<String, NutchField> fields = new HashMap();
    private Metadata documentMeta = new Metadata();
    private float weight = 1.0f;

    public void add(String name, Object value) {
        NutchField field = this.fields.get(name);
        if (field == null) {
            field = new NutchField(value);
            this.fields.put(name, field);
        } else {
            field.add(value);
        }
    }

    public Object getFieldValue(String name) {
        NutchField field = this.fields.get(name);
        if (field == null) {
            return null;
        }
        if (field.getValues().size() == 0) {
            return null;
        }
        return field.getValues().get(0);
    }

    public NutchField getField(String name) {
        return this.fields.get(name);
    }

    public NutchField removeField(String name) {
        return this.fields.remove(name);
    }

    public Collection<String> getFieldNames() {
        return this.fields.keySet();
    }

    @Override
    public Iterator<Map.Entry<String, NutchField>> iterator() {
        return this.fields.entrySet().iterator();
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public Metadata getDocumentMeta() {
        return this.documentMeta;
    }

    public void readFields(DataInput in) throws IOException {
        this.fields.clear();
        byte version = in.readByte();
        if (version != 2) {
            throw new VersionMismatchException(2, version);
        }
        int size = WritableUtils.readVInt((DataInput)in);
        for (int i = 0; i < size; ++i) {
            String name = Text.readString((DataInput)in);
            NutchField field = new NutchField();
            field.readFields(in);
            this.fields.put(name, field);
        }
        this.weight = in.readFloat();
        this.documentMeta.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(2);
        WritableUtils.writeVInt((DataOutput)out, (int)this.fields.size());
        for (Map.Entry<String, NutchField> entry : this.fields.entrySet()) {
            Text.writeString((DataOutput)out, (String)entry.getKey());
            NutchField field = entry.getValue();
            field.write(out);
        }
        out.writeFloat(this.weight);
        this.documentMeta.write(out);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("doc {\n");
        for (Map.Entry<String, NutchField> entry : this.fields.entrySet()) {
            sb.append("\t");
            sb.append(entry.getKey());
            sb.append(":\t");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public NutchDocument clone() throws CloneNotSupportedException {
        NutchDocument clonedDocument = (NutchDocument)super.clone();
        clonedDocument.fields = new HashMap();
        for (Map.Entry<String, NutchField> field : this.fields.entrySet()) {
            clonedDocument.fields.put(field.getKey(), field.getValue().clone());
        }
        return clonedDocument;
    }
}

