/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.aot.hint;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.aop.SpringProxy;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.security.aot.hint.SecurityHintsRegistrar;
import org.springframework.security.authorization.AuthorizationProxyFactory;
import org.springframework.security.authorization.method.AuthorizeReturnObject;
import org.springframework.security.core.annotation.SecurityAnnotationScanner;
import org.springframework.security.core.annotation.SecurityAnnotationScanners;
import org.springframework.util.Assert;

public final class AuthorizeReturnObjectHintsRegistrar
implements SecurityHintsRegistrar {
    private final AuthorizationProxyFactory proxyFactory;
    private final SecurityAnnotationScanner<AuthorizeReturnObject> scanner = SecurityAnnotationScanners.requireUnique(AuthorizeReturnObject.class);
    private final Set<Class<?>> visitedClasses = new HashSet();
    private final List<Class<?>> classesToProxy;

    public AuthorizeReturnObjectHintsRegistrar(AuthorizationProxyFactory proxyFactory, Class<?> ... classes) {
        Assert.notNull((Object)proxyFactory, (String)"proxyFactory cannot be null");
        Assert.noNullElements((Object[])classes, (String)"classes cannot contain null elements");
        this.proxyFactory = proxyFactory;
        this.classesToProxy = new ArrayList(List.of(classes));
    }

    public AuthorizeReturnObjectHintsRegistrar(AuthorizationProxyFactory proxyFactory, List<Class<?>> classes) {
        this.proxyFactory = proxyFactory;
        this.classesToProxy = new ArrayList(classes);
    }

    @Override
    public void registerHints(RuntimeHints hints, ConfigurableListableBeanFactory beanFactory) {
        ArrayList toProxy = new ArrayList();
        for (Class<Object> clazz : this.classesToProxy) {
            toProxy.add(clazz);
            this.traverseType(toProxy, clazz);
        }
        for (Class<Object> clazz : toProxy) {
            this.registerProxy(hints, clazz);
        }
    }

    private void registerProxy(RuntimeHints hints, Class<?> clazz) {
        Class<?> proxied = this.proxyFactory.proxy(clazz);
        if (proxied == null) {
            return;
        }
        if (Proxy.isProxyClass(proxied)) {
            hints.proxies().registerJdkProxy((Class[])proxied.getInterfaces());
            return;
        }
        if (SpringProxy.class.isAssignableFrom(proxied)) {
            hints.reflection().registerType(clazz, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS}).registerType(proxied, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.ACCESS_DECLARED_FIELDS});
        }
    }

    private void traverseType(List<Class<?>> toProxy, Class<?> clazz) {
        if (clazz == Object.class || this.visitedClasses.contains(clazz)) {
            return;
        }
        this.visitedClasses.add(clazz);
        for (Method m : clazz.getDeclaredMethods()) {
            AuthorizeReturnObject object = this.scanner.scan(m, clazz);
            if (object == null) continue;
            Class<?> returnType = m.getReturnType();
            toProxy.add(returnType);
            this.traverseType(toProxy, returnType);
        }
    }
}

