#!/bin/sh -e

#    Licensed to the Apache Software Foundation (ASF) under one or more
#    contributor license agreements.  See the NOTICE file distributed with
#    this work for additional information regarding copyright ownership.
#    The ASF licenses this file to You under the Apache License, Version 2.0
#    (the "License"); you may not use this file except in compliance with
#    the License.  You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.

state_providers_file=${NIFI_HOME}/conf/state-management.xml
property_xpath='/stateManagement/cluster-provider/property'

edit_property() {
  property_name=$1
  property_value=$2

  if [ -n "${property_value}" ]; then
    xmlstarlet ed --inplace -u "${property_xpath}[@name='${property_name}']" -v "${property_value}" "${state_providers_file}"
  fi
}

edit_property 'Connect String'     "${NIFI_ZK_CONNECT_STRING}"
edit_property "Root Node"                   "${NIFI_ZK_ROOT_NODE}"

edit_property 'ConfigMap Name Prefix'     "${NIFI_KUBERNETES_CONFIGMAP_NAME_PREFIX}"