/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.cert;

import java.util.Base64;
import java.util.Objects;
import org.apache.nifi.security.cert.GeneralNameType;
import org.apache.nifi.security.cert.SubjectAlternativeName;

class StandardSubjectAlternativeName
implements SubjectAlternativeName {
    private final String name;
    private final GeneralNameType generalNameType;

    StandardSubjectAlternativeName(GeneralNameType generalNameType, String name) {
        this.generalNameType = Objects.requireNonNull(generalNameType, "General Name Type required");
        this.name = Objects.requireNonNull(name, "Name required");
    }

    StandardSubjectAlternativeName(GeneralNameType generalNameType, byte[] nameEncoded) {
        this.generalNameType = Objects.requireNonNull(generalNameType, "General Name Type required");
        this.name = Base64.getEncoder().encodeToString(nameEncoded);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public GeneralNameType getGeneralNameType() {
        return this.generalNameType;
    }
}

