/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Function;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ByFunctionOrdering;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ComparatorOrdering;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.NaturalOrdering;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ReverseOrdering;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Comparator;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Ordering
implements Comparator {
    public static Ordering natural() {
        return NaturalOrdering.INSTANCE;
    }

    public static Ordering from(Comparator comparator) {
        return comparator instanceof Ordering ? (Ordering)comparator : new ComparatorOrdering(comparator);
    }

    protected Ordering() {
    }

    public Ordering reverse() {
        return new ReverseOrdering(this);
    }

    public Ordering onResultOf(Function function) {
        return new ByFunctionOrdering(function, this);
    }

    @CanIgnoreReturnValue
    public abstract int compare(@Nullable Object var1, @Nullable Object var2);

    @CanIgnoreReturnValue
    public ImmutableList immutableSortedCopy(Iterable iterable) {
        return ImmutableList.sortedCopyOf(this, iterable);
    }
}

