/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.utils;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.common.io.resultset.ResultSetReader;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.hadoop.common.conf.HadoopConf$;
import org.apache.linkis.storage.LineMetaData;
import org.apache.linkis.storage.LineMetaData$;
import org.apache.linkis.storage.LineRecord;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageFatalException;
import org.apache.linkis.storage.resultset.ResultSetFactory$;
import org.apache.linkis.storage.resultset.ResultSetReader$;
import org.apache.linkis.storage.resultset.ResultSetWriter$;
import org.apache.linkis.storage.utils.StorageConfiguration$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class StorageUtils$
implements Logging {
    public static StorageUtils$ MODULE$;
    private final String HDFS;
    private final String FILE;
    private final String OSS;
    private final String S3;
    private final String BLOB;
    private final String FILE_SCHEMA;
    private final String HDFS_SCHEMA;
    private final String OSS_SCHEMA;
    private final String S3_SCHEMA;
    private final String BLOB_SCHEMA;
    private final NumberFormat nf;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new StorageUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        StorageUtils$ storageUtils$ = this;
        synchronized (storageUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String HDFS() {
        return this.HDFS;
    }

    public String FILE() {
        return this.FILE;
    }

    public String OSS() {
        return this.OSS;
    }

    public String S3() {
        return this.S3;
    }

    public String BLOB() {
        return this.BLOB;
    }

    public String FILE_SCHEMA() {
        return this.FILE_SCHEMA;
    }

    public String HDFS_SCHEMA() {
        return this.HDFS_SCHEMA;
    }

    public String OSS_SCHEMA() {
        return this.OSS_SCHEMA;
    }

    public String S3_SCHEMA() {
        return this.S3_SCHEMA;
    }

    public String BLOB_SCHEMA() {
        return this.BLOB_SCHEMA;
    }

    private NumberFormat nf() {
        return this.nf;
    }

    public String doubleToString(double value) {
        if (Double.isNaN(value)) {
            return "NaN";
        }
        return this.nf().format(value);
    }

    public <T> Map<String, T> loadClass(String classStr, Function1<T, String> op) {
        String[] _classes = classStr.split(",");
        LinkedHashMap classes = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])_classes)).foreach((Function1 & Serializable & scala.Serializable)clazz -> (LinkedHashMap)Utils$.MODULE$.tryAndError((Function0 & Serializable & scala.Serializable)() -> {
            Object obj = Utils$.MODULE$.getClassInstance(clazz.trim());
            return classes.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(op.apply(obj)), obj));
        }, MODULE$.logger()));
        return classes.toMap(Predef$.MODULE$.$conforms());
    }

    public <T> Map<String, Class<T>> loadClasses(String classStr, String pge, Function1<Class<T>, String> op) {
        String[] _classes = StringUtils.isEmpty((CharSequence)pge) ? classStr.split(",") : (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classStr.split(","))).map((Function1 & Serializable & scala.Serializable)value -> new java.lang.StringBuilder(1).append(pge).append(".").append((String)value).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        LinkedHashMap classes = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])_classes)).foreach((Function1 & Serializable & scala.Serializable)clazz -> (LinkedHashMap)Utils$.MODULE$.tryAndError((Function0 & Serializable & scala.Serializable)() -> {
            Class<?> _class = Thread.currentThread().getContextClassLoader().loadClass(clazz.trim());
            return classes.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(op.apply(_class)), _class));
        }, MODULE$.logger()));
        return classes.toMap(Predef$.MODULE$.$conforms());
    }

    public String pathToSuffix(String path) {
        int dot;
        String fileName = new File(path).getName();
        if (fileName != null && fileName.length() > 0 && (dot = fileName.lastIndexOf(46)) > -1 && dot < fileName.length() - 1) {
            return fileName.substring(dot + 1);
        }
        return fileName;
    }

    public Object invoke(Object obj, Method method, Object[] args) {
        return method.invoke(obj, new Object[]{args});
    }

    public String serializerStringToResult(String value) {
        ResultSet<? extends MetaData, ? extends Record> resultSet = ResultSetFactory$.MODULE$.getInstance().getResultSetByType(ResultSetFactory$.MODULE$.TEXT_TYPE());
        ResultSetWriter<? extends MetaData, ? extends Record> writer = ResultSetWriter$.MODULE$.getResultSetWriter(resultSet, Long.MAX_VALUE, null);
        LineMetaData metaData = new LineMetaData(LineMetaData$.MODULE$.$lessinit$greater$default$1());
        LineRecord record = new LineRecord(value);
        writer.addMetaData((MetaData)metaData);
        writer.addRecord((Record)record);
        String res = writer.toString();
        Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writer.close());
        return res;
    }

    public String deserializerResultToString(String result) {
        ResultSet<? extends MetaData, ? extends Record> resultSet = ResultSetFactory$.MODULE$.getInstance().getResultSetByType(ResultSetFactory$.MODULE$.TEXT_TYPE());
        ResultSetReader<? extends MetaData, ? extends Record> reader = ResultSetReader$.MODULE$.getResultSetReader(resultSet, result);
        reader.getMetaData();
        StringBuilder sb = new StringBuilder();
        while (reader.hasNext()) {
            LineRecord record = (LineRecord)reader.getRecord();
            sb.append(record.getLine());
        }
        String value = sb.toString();
        Utils$.MODULE$.tryQuietly((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> reader.close());
        return value;
    }

    public void close(OutputStream outputStream) {
        this.close(outputStream, null, null);
    }

    public void close(InputStream inputStream) {
        this.close(null, inputStream, null);
    }

    public void close(Fs fs) {
        this.close(null, null, fs);
    }

    public void close(OutputStream outputStream, InputStream inputStream, Fs fs) {
        Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (outputStream != null) {
                outputStream.close();
                return;
            }
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
        Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (inputStream != null) {
                inputStream.close();
                return;
            }
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
        Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (fs != null) {
                fs.close();
                return;
            }
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
    }

    public void close(Closeable closeable) {
        Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (closeable != null) {
                closeable.close();
                return;
            }
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
    }

    public String getJvmUser() {
        return System.getProperty("user.name");
    }

    public boolean isHDFSNode() {
        File confPath = new File(HadoopConf$.MODULE$.hadoopConfDir());
        if (!confPath.exists() || confPath.isFile()) {
            throw new StorageFatalException(LinkisStorageErrorCodeSummary.CONFIGURATION_NOT_READ.getErrorCode(), LinkisStorageErrorCodeSummary.CONFIGURATION_NOT_READ.getErrorDesc());
        }
        return true;
    }

    public FsPath getFsPath(String path) {
        if (path.startsWith(this.FILE_SCHEMA()) || path.startsWith(this.HDFS_SCHEMA()) || path.startsWith(this.BLOB_SCHEMA())) {
            return new FsPath(path);
        }
        return new FsPath(new java.lang.StringBuilder(0).append(this.FILE_SCHEMA()).append(path).toString());
    }

    public int readBytes(InputStream inputStream, byte[] bytes, int len) {
        int readLen;
        int count = 0;
        for (readLen = 0; readLen < len && readLen >= 0; readLen += count) {
            count = inputStream.read(bytes, readLen, len - readLen);
            if (count != -1 || inputStream.available() >= 1) continue;
            return readLen;
        }
        return readLen;
    }

    public boolean isIOProxy() {
        return BoxesRunTime.unboxToBoolean((Object)StorageConfiguration$.MODULE$.ENABLE_IO_PROXY().getValue());
    }

    public boolean isHDFSPath(FsPath fsPath) {
        return this.HDFS().equals(fsPath.getFsType());
    }

    private StorageUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.HDFS = "hdfs";
        this.FILE = "file";
        this.OSS = "oss";
        this.S3 = "s3";
        this.BLOB = "https";
        this.FILE_SCHEMA = "file://";
        this.HDFS_SCHEMA = "hdfs://";
        this.OSS_SCHEMA = "oss://";
        this.S3_SCHEMA = "s3://";
        this.BLOB_SCHEMA = "https://";
        this.nf = NumberFormat.getInstance();
        this.nf().setGroupingUsed(false);
        this.nf().setMaximumFractionDigits(BoxesRunTime.unboxToInt((Object)StorageConfiguration$.MODULE$.DOUBLE_FRACTION_LEN().getValue()));
    }
}

