/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.entity.resource;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.manager.common.entity.resource.Resource;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MemoryResource
extends Resource {
    private final long memory;

    public MemoryResource() {
        this(Long.MAX_VALUE);
    }

    public MemoryResource(long memory) {
        this.memory = memory;
    }

    private MemoryResource toMemoryResource(Resource r) {
        if (r instanceof MemoryResource) {
            return (MemoryResource)r;
        }
        return new MemoryResource(Long.MAX_VALUE);
    }

    @Override
    public Resource add(Resource resource) {
        MemoryResource r = this.toMemoryResource(resource);
        return new MemoryResource(this.memory + r.getMemory());
    }

    @Override
    public Resource minus(Resource resource) {
        MemoryResource r = this.toMemoryResource(resource);
        return new MemoryResource(this.memory - r.getMemory());
    }

    @Override
    public Resource multiplied(Resource resource) {
        MemoryResource r = this.toMemoryResource(resource);
        return new MemoryResource(this.memory * r.getMemory());
    }

    @Override
    public Resource multiplied(float rate) {
        return new MemoryResource((long)((float)this.memory * rate));
    }

    @Override
    public Resource divide(Resource resource) {
        MemoryResource r = this.toMemoryResource(resource);
        return new MemoryResource(this.memory / r.getMemory());
    }

    @Override
    public Resource divide(int rate) {
        return new MemoryResource(this.memory / (long)rate);
    }

    @Override
    public boolean moreThan(Resource resource) {
        MemoryResource r = this.toMemoryResource(resource);
        return this.memory > r.getMemory();
    }

    @Override
    public boolean notLess(Resource resource) {
        MemoryResource r = this.toMemoryResource(resource);
        return this.memory >= r.getMemory();
    }

    @Override
    public boolean less(Resource r) {
        return !this.notLess(r);
    }

    @Override
    public int compare(Resource resource) {
        MemoryResource r = this.toMemoryResource(resource);
        return Long.compare(this.getMemory(), r.getMemory());
    }

    @Override
    public boolean caseMore(Resource r) {
        return this.moreThan(r);
    }

    @Override
    public boolean equalsTo(Resource resource) {
        MemoryResource r = this.toMemoryResource(resource);
        return this.memory == r.getMemory();
    }

    @Override
    public String toJson() {
        return " {\"memory\":\"" + ByteTimeUtils.bytesToString((long)this.memory) + " }";
    }

    public String toString() {
        return this.toJson();
    }

    public long getMemory() {
        return this.memory;
    }
}

