/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.launch;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.ServiceInstance$;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.common.creation.DefaultEngineCreationContext;
import org.apache.linkis.engineconn.common.creation.EngineCreationContext;
import org.apache.linkis.engineconn.common.engineconn.EngineConn;
import org.apache.linkis.engineconn.common.execution.EngineConnExecution;
import org.apache.linkis.engineconn.common.hook.EngineConnHook;
import org.apache.linkis.engineconn.common.hook.EngineConnHook$;
import org.apache.linkis.engineconn.core.EngineConnObject$;
import org.apache.linkis.engineconn.core.engineconn.EngineConnManager;
import org.apache.linkis.engineconn.core.engineconn.EngineConnManager$;
import org.apache.linkis.engineconn.core.execution.AbstractEngineConnExecution;
import org.apache.linkis.engineconn.core.execution.EngineConnExecution$;
import org.apache.linkis.engineconn.core.hook.ShutdownHook;
import org.apache.linkis.engineconn.core.hook.ShutdownHook$;
import org.apache.linkis.engineconn.core.util.EngineConnUtils$;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf$;
import org.apache.linkis.governance.common.constant.ec.ECConstants$;
import org.apache.linkis.governance.common.exception.engineconn.EngineConnExecutorErrorException;
import org.apache.linkis.governance.common.utils.EngineConnArguments;
import org.apache.linkis.governance.common.utils.EngineConnArgumentsParser$;
import org.apache.linkis.manager.engineplugin.common.launch.process.Environment$;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.engine.EngineConnMode$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

public final class EngineConnServer$
implements Logging {
    public static EngineConnServer$ MODULE$;
    private final EngineCreationContext engineCreationContext;
    private final LabelBuilderFactory labelBuilderFactory;
    private boolean onceMode;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new EngineConnServer$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        EngineConnServer$ engineConnServer$ = this;
        synchronized (engineConnServer$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private EngineCreationContext engineCreationContext() {
        return this.engineCreationContext;
    }

    private LabelBuilderFactory labelBuilderFactory() {
        return this.labelBuilderFactory;
    }

    private boolean onceMode() {
        return this.onceMode;
    }

    private void onceMode_$eq(boolean x$1) {
        this.onceMode = x$1;
    }

    public void main(String[] args) {
        this.logger().info("<<---------------------EngineConnServer Start --------------------->>");
        try {
            this.init(args);
            boolean isTestMode = BoxesRunTime.unboxToBoolean((Object)Configuration$.MODULE$.IS_TEST_MODE().getValue(this.engineCreationContext().getOptions()));
            if (isTestMode) {
                this.logger().info(new StringBuilder(107).append("Step into test mode, pause 30s if debug is required. If you want to disable test mode, please set ").append(Configuration$.MODULE$.IS_TEST_MODE().key()).append(" = false.").toString());
                Utils$.MODULE$.sleepQuietly(30000L);
            }
            this.logger().info(new StringBuilder(73).append("Finished to create EngineCreationContext, EngineCreationContext content: ").append(EngineConnUtils$.MODULE$.GSON().toJson((Object)this.engineCreationContext())).toString());
            EngineConnHook[] ecHooks = EngineConnHook$.MODULE$.getEngineConnHooks(this.onceMode());
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ecHooks)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.beforeCreateEngineConn(EngineConnServer$.MODULE$.getEngineCreationContext());
                return BoxedUnit.UNIT;
            });
            this.logger().info("Finished to execute hook of beforeCreateEngineConn.");
            EngineConn engineConn = this.getEngineConnManager().createEngineConn(this.getEngineCreationContext());
            this.logger().info(new StringBuilder(31).append("Finished to create ").append(engineConn.getEngineConnType()).append(" EngineConn.").toString());
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ecHooks)).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.beforeExecutionExecute(EngineConnServer$.MODULE$.getEngineCreationContext(), engineConn);
                return BoxedUnit.UNIT;
            });
            this.logger().info("Finished to execute all hooks of beforeExecutionExecute.");
            Utils$.MODULE$.tryThrow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.executeEngineConn(engineConn), (Function1 & Serializable & scala.Serializable)t -> {
                MODULE$.logger().error(new StringBuilder(30).append("Init executors error. Reason: ").append(ExceptionUtils.getRootCauseMessage((Throwable)t)).toString(), t);
                throw new EngineConnExecutorErrorException(40106, "Init executors failed. ", t);
            });
            EngineConnObject$.MODULE$.setReady();
            this.logger().info("Finished to execute executions.");
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ecHooks)).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.afterExecutionExecute(EngineConnServer$.MODULE$.getEngineCreationContext(), engineConn);
                return BoxedUnit.UNIT;
            });
            this.logger().info("Finished to execute hook of afterExecutionExecute");
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ecHooks)).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.afterEngineServerStartSuccess(EngineConnServer$.MODULE$.getEngineCreationContext(), engineConn);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t2) {
            this.logger().error("EngineConnServer Start Failed.", t2);
            EngineConnHook[] ecHooks = EngineConnHook$.MODULE$.getEngineConnHooks(this.onceMode());
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ecHooks)).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.afterEngineServerStartFailed(EngineConnServer$.MODULE$.getEngineCreationContext(), t2);
                return BoxedUnit.UNIT;
            });
            System.exit(1);
        }
        ShutdownHook qual$1 = ShutdownHook$.MODULE$.getShutdownHook();
        long x$12 = qual$1.waitForStopOrError$default$1();
        qual$1.waitForStopOrError(x$12);
        this.logger().info("<<---------------------EngineConnServer Exit --------------------->>");
        System.exit(ShutdownHook$.MODULE$.getShutdownHook().getExitCode());
    }

    private void init(String[] args) {
        EngineConnArguments arguments = EngineConnArgumentsParser$.MODULE$.getEngineConnArgumentsParser().parseToObj(args);
        scala.collection.immutable.Map engineConf = arguments.getEngineConnConfMap();
        this.engineCreationContext().setUser((String)engineConf.getOrElse((Object)"user", (Function0 & Serializable & scala.Serializable)() -> Utils$.MODULE$.getJvmUser()));
        this.engineCreationContext().setTicketId((String)engineConf.getOrElse((Object)ECConstants$.MODULE$.EC_TICKET_ID_KEY(), (Function0 & Serializable & scala.Serializable)() -> ""));
        String host = (String)CommonVars$.MODULE$.apply(Environment$.MODULE$.ECM_HOST().toString(), (Object)"127.0.0.1").getValue();
        String port = (String)CommonVars$.MODULE$.apply(Environment$.MODULE$.ECM_PORT().toString(), (Object)"80").getValue();
        this.engineCreationContext().setEMInstance(ServiceInstance$.MODULE$.apply((String)GovernanceCommonConf$.MODULE$.ENGINE_CONN_MANAGER_SPRING_NAME().getValue(), new StringBuilder(1).append(host).append(":").append(port).toString()));
        ArrayBuffer labels = new ArrayBuffer();
        scala.collection.immutable.Map labelArgs = (scala.collection.immutable.Map)engineConf.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)EngineConnServer$.$anonfun$init$3(x$6)));
        if (labelArgs.nonEmpty()) {
            labelArgs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    String realKey = key.substring(EngineConnArgumentsParser$.MODULE$.LABEL_PREFIX().length());
                    if ("engineConnMode".equals(realKey)) {
                        MODULE$.onceMode_$eq(EngineConnMode$.MODULE$.isOnceMode(value));
                    }
                    return labels.$plus$eq((Object)MODULE$.labelBuilderFactory().createLabel(realKey, (Object)value));
                }
                throw new MatchError((Object)tuple2);
            });
            this.engineCreationContext().setLabels((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)labels.toList()).asJava());
        }
        HashMap jMap = new HashMap(engineConf.size());
        jMap.putAll((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)engineConf).asJava());
        this.engineCreationContext().setOptions(jMap);
        this.engineCreationContext().setArgs(args);
        EngineConnObject$.MODULE$.setEngineCreationContext(this.engineCreationContext());
        this.logger().info(new StringBuilder(40).append("Finished to init engineCreationContext: ").append(EngineConnUtils$.MODULE$.GSON().toJson((Object)this.engineCreationContext())).toString());
    }

    private void executeEngineConn(EngineConn engineConn) {
        Object object = new Object();
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])EngineConnExecution$.MODULE$.getEngineConnExecutions())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                EngineConnServer$.$anonfun$executeEngineConn$1(engineConn, object, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public boolean isOnceMode() {
        return this.onceMode();
    }

    public EngineCreationContext getEngineCreationContext() {
        return this.engineCreationContext();
    }

    private EngineConnManager getEngineConnManager() {
        return EngineConnManager$.MODULE$.getEngineConnManager();
    }

    public static final /* synthetic */ boolean $anonfun$init$3(Tuple2 x$6) {
        return ((String)x$6._1()).startsWith(EngineConnArgumentsParser$.MODULE$.LABEL_PREFIX());
    }

    public static final /* synthetic */ void $anonfun$executeEngineConn$1(EngineConn engineConn$2, Object nonLocalReturnKey1$1, EngineConnExecution x0$1) {
        EngineConnExecution engineConnExecution = x0$1;
        if (engineConnExecution instanceof AbstractEngineConnExecution) {
            AbstractEngineConnExecution abstractEngineConnExecution = (AbstractEngineConnExecution)engineConnExecution;
            MODULE$.logger().info(new StringBuilder(18).append("Ready to execute ").append(abstractEngineConnExecution.getClass().getSimpleName()).append(".").toString());
            abstractEngineConnExecution.execute(MODULE$.getEngineCreationContext(), engineConn$2);
            if (abstractEngineConnExecution.returnAfterMeExecuted(MODULE$.getEngineCreationContext(), engineConn$2)) {
                throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
            }
            return;
        }
        MODULE$.logger().info(new StringBuilder(18).append("Ready to execute ").append(engineConnExecution.getClass().getSimpleName()).append(".").toString());
        engineConnExecution.execute(MODULE$.getEngineCreationContext(), engineConn$2);
    }

    private EngineConnServer$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.engineCreationContext = new DefaultEngineCreationContext();
        this.labelBuilderFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();
        this.onceMode = false;
    }
}

